/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.impl.sql.execute.CursorActivation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.ProjectRestrictResultSet;

public class ScrollInsensitiveResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public NoPutResultSet source;
    private int sourceRowWidth;
    private BackingStoreHashtable ht;
    private ExecRow resultRow;
    private int positionInSource;
    private int currentPosition;
    private int lastPosition;
    private boolean seenFirst;
    private boolean seenLast;
    private boolean beforeFirst = true;
    private boolean afterLast;
    public int numFromHashTable;
    public int numToHashTable;
    private int maxRows;
    private boolean keepAfterCommit;
    private int extraColumns;
    private SQLInteger positionInHashTable;
    private CursorResultSet target;
    private boolean needsRepositioning;
    private static final int POS_ROWLOCATION = 1;
    private static final int POS_ROWDELETED = 2;
    private static final int POS_ROWUPDATED = 3;
    private static final int LAST_EXTRA_COLUMN = 3;

    public ScrollInsensitiveResultSet(NoPutResultSet noPutResultSet, Activation activation, int n, int n2, double d, double d2) throws StandardException {
        super(activation, n, d, d2);
        this.source = noPutResultSet;
        this.sourceRowWidth = n2;
        this.keepAfterCommit = activation.getResultSetHoldability();
        this.maxRows = activation.getMaxRows();
        this.positionInHashTable = new SQLInteger();
        this.needsRepositioning = false;
        if (this.isForUpdate()) {
            this.target = ((CursorActivation)activation).getTargetResultSet();
            this.extraColumns = 4;
        } else {
            this.target = null;
            this.extraColumns = 1;
        }
        this.recordConstructorTime();
    }

    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.source.openCore();
        this.isOpen = true;
        ++this.numOpens;
        int[] nArray = new int[]{0};
        this.ht = new BackingStoreHashtable(this.getTransactionController(), null, nArray, false, -1L, -1L, -1, -1.0f, false, this.keepAfterCommit);
        this.lastPosition = 0;
        this.needsRepositioning = false;
        this.numFromHashTable = 0;
        this.numToHashTable = 0;
        this.positionInSource = 0;
        this.seenFirst = false;
        this.seenLast = false;
        this.openTime += this.getElapsedMillis(this.beginTime);
        this.setBeforeFirstRow();
    }

    public void reopenCore() throws StandardException {
        boolean bl = true;
        this.beginTime = this.getCurrentTimeMillis();
        this.setBeforeFirstRow();
    }

    public ExecRow getAbsoluteRow(int n) throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "absolute");
        }
        this.attachStatementContext();
        if (n == 0) {
            this.setBeforeFirstRow();
            return null;
        }
        if (this.seenLast && n > this.lastPosition) {
            return this.setAfterLastRow();
        }
        if (n > 0) {
            if (n <= this.positionInSource) {
                return this.getRowFromHashTable(n);
            }
            ExecRow execRow = null;
            for (int i = n - this.positionInSource; i > 0 && (execRow = this.getNextRowFromSource()) != null; --i) {
            }
            if (execRow != null) {
                execRow = this.getRowFromHashTable(n);
            }
            this.currentRow = execRow;
            return execRow;
        }
        if (n < 0) {
            int n2;
            if (!this.seenLast) {
                this.getLastRow();
            }
            if ((n2 = this.lastPosition + 1) + n > 0) {
                return this.getRowFromHashTable(n2 + n);
            }
            return this.setBeforeFirstRow();
        }
        this.currentRow = null;
        return null;
    }

    public ExecRow getRelativeRow(int n) throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "relative");
        }
        this.attachStatementContext();
        if (n == 0) {
            if (this.beforeFirst || this.afterLast || this.currentPosition == 0) {
                return null;
            }
            return this.getRowFromHashTable(this.currentPosition);
        }
        if (n > 0) {
            return this.getAbsoluteRow(this.currentPosition + n);
        }
        if (this.currentPosition + n < 0) {
            return this.setBeforeFirstRow();
        }
        return this.getAbsoluteRow(this.currentPosition + n);
    }

    public ExecRow setBeforeFirstRow() {
        this.currentPosition = 0;
        this.beforeFirst = true;
        this.afterLast = false;
        this.currentRow = null;
        return null;
    }

    public ExecRow getFirstRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "first");
        }
        if (this.seenFirst) {
            return this.getRowFromHashTable(1);
        }
        this.attachStatementContext();
        return this.getNextRowCore();
    }

    public ExecRow getNextRowCore() throws StandardException {
        ExecRow execRow = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "next");
        }
        if (this.seenLast && this.currentPosition == this.lastPosition) {
            return this.setAfterLastRow();
        }
        if (this.currentPosition == this.positionInSource) {
            execRow = this.getNextRowFromSource();
            if (execRow != null) {
                execRow = this.getRowFromHashTable(this.currentPosition);
            }
        } else {
            execRow = this.currentPosition < this.positionInSource ? this.getRowFromHashTable(this.currentPosition + 1) : null;
        }
        if (execRow != null) {
            ++this.rowsSeen;
            this.afterLast = false;
        }
        this.setCurrentRow(execRow);
        this.beforeFirst = false;
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow;
    }

    public ExecRow getPreviousRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "next");
        }
        if (this.beforeFirst || this.currentPosition == 0) {
            this.currentRow = null;
            return null;
        }
        if (this.afterLast) {
            if (this.lastPosition == 0) {
                this.afterLast = false;
                this.beforeFirst = false;
                this.currentRow = null;
                return null;
            }
            return this.getRowFromHashTable(this.lastPosition);
        }
        --this.currentPosition;
        if (this.currentPosition == 0) {
            this.setBeforeFirstRow();
            return null;
        }
        return this.getRowFromHashTable(this.currentPosition);
    }

    public ExecRow getLastRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "next");
        }
        if (!this.seenLast) {
            this.attachStatementContext();
            ExecRow execRow = null;
            while ((execRow = this.getNextRowFromSource()) != null) {
            }
        }
        this.beforeFirst = false;
        this.afterLast = false;
        if (this.lastPosition == 0) {
            this.currentRow = null;
            return null;
        }
        return this.getRowFromHashTable(this.lastPosition);
    }

    public ExecRow setAfterLastRow() throws StandardException {
        if (!this.seenLast) {
            this.getLastRow();
        }
        if (this.lastPosition == 0) {
            this.currentPosition = 0;
            this.afterLast = false;
        } else {
            this.currentPosition = this.lastPosition + 1;
            this.afterLast = true;
        }
        this.beforeFirst = false;
        this.currentRow = null;
        return null;
    }

    public boolean checkRowPosition(int n) throws StandardException {
        switch (n) {
            case 101: {
                if (!this.beforeFirst) {
                    return false;
                }
                if (this.seenFirst) {
                    return true;
                }
                ExecRow execRow = this.getFirstRow();
                if (execRow == null) {
                    return false;
                }
                this.getPreviousRow();
                return true;
            }
            case 102: {
                return this.currentPosition == 1;
            }
            case 103: {
                if (this.beforeFirst || this.afterLast || this.currentPosition == 0 || this.currentPosition < this.positionInSource) {
                    return false;
                }
                if (this.seenLast) {
                    return this.currentPosition == this.lastPosition;
                }
                int n2 = this.currentPosition;
                boolean bl = this.getNextRowFromSource() == null;
                this.getRowFromHashTable(n2);
                return bl;
            }
            case 104: {
                return this.afterLast;
            }
        }
        return false;
    }

    public int getRowNumber() {
        return this.currentRow == null ? 0 : this.currentPosition;
    }

    private ExecRow getNextRowFromSource() throws StandardException {
        ExecRow execRow = null;
        Object var2_2 = null;
        if (this.maxRows > 0 && this.maxRows == this.positionInSource) {
            this.seenLast = true;
            this.lastPosition = this.positionInSource;
            this.afterLast = true;
            return null;
        }
        if (this.needsRepositioning) {
            this.positionInLastFetchedRow();
            this.needsRepositioning = false;
        }
        if ((execRow = this.source.getNextRowCore()) != null) {
            this.seenFirst = true;
            this.beforeFirst = false;
            long l = this.getCurrentTimeMillis();
            if (this.resultRow == null) {
                this.resultRow = this.activation.getExecutionFactory().getValueRow(this.sourceRowWidth);
            }
            ++this.positionInSource;
            this.currentPosition = this.positionInSource;
            RowLocation rowLocation = null;
            if (this.source.isForUpdate()) {
                rowLocation = ((CursorResultSet)((Object)this.source)).getRowLocation();
            }
            this.addRowToHashTable(execRow, this.currentPosition, rowLocation, false);
        } else {
            if (!this.seenLast) {
                this.lastPosition = this.positionInSource;
            }
            this.seenLast = true;
            if (this.positionInSource == 0) {
                this.afterLast = false;
            } else {
                this.afterLast = true;
                this.currentPosition = this.positionInSource + 1;
            }
        }
        return execRow;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.currentRow = null;
            this.source.close();
            if (this.ht != null) {
                this.ht.close();
                this.ht = null;
            }
            super.close();
        }
        this.setBeforeFirstRow();
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public void finish() throws StandardException {
        this.source.finish();
        this.finishAndRTS();
    }

    public long getTimeSpent(int n) {
        long l = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n == 0) {
            return l - this.source.getTimeSpent(1);
        }
        return l;
    }

    public RowLocation getRowLocation() throws StandardException {
        return ((CursorResultSet)((Object)this.source)).getRowLocation();
    }

    public ExecRow getCurrentRow() throws StandardException {
        if (this.isForUpdate() && this.isDeleted()) {
            return null;
        }
        return this.currentRow;
    }

    private void addRowToHashTable(ExecRow execRow, int n, RowLocation rowLocation, boolean bl) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[this.sourceRowWidth + this.extraColumns];
        dataValueDescriptorArray[0] = new SQLInteger(n);
        if (this.isForUpdate()) {
            dataValueDescriptorArray[1] = rowLocation.getClone();
            dataValueDescriptorArray[2] = new SQLBoolean(false);
            dataValueDescriptorArray[3] = new SQLBoolean(bl);
        }
        DataValueDescriptor[] dataValueDescriptorArray2 = execRow.getRowArray();
        System.arraycopy(dataValueDescriptorArray2, 0, dataValueDescriptorArray, this.extraColumns, dataValueDescriptorArray2.length);
        this.ht.putRow(true, dataValueDescriptorArray);
        ++this.numToHashTable;
    }

    private ExecRow getRowFromHashTable(int n) throws StandardException {
        this.positionInHashTable.setValue(n);
        DataValueDescriptor[] dataValueDescriptorArray = (DataValueDescriptor[])this.ht.get(this.positionInHashTable);
        DataValueDescriptor[] dataValueDescriptorArray2 = new DataValueDescriptor[dataValueDescriptorArray.length - this.extraColumns];
        System.arraycopy(dataValueDescriptorArray, this.extraColumns, dataValueDescriptorArray2, 0, dataValueDescriptorArray2.length);
        this.resultRow.setRowArray(dataValueDescriptorArray2);
        this.currentPosition = n;
        ++this.numFromHashTable;
        if (this.resultRow != null) {
            this.beforeFirst = false;
            this.afterLast = false;
        }
        if (this.isForUpdate()) {
            RowLocation rowLocation = (RowLocation)dataValueDescriptorArray[1];
            ((NoPutResultSet)((Object)this.target)).setCurrentRow(this.resultRow);
            ((NoPutResultSet)((Object)this.target)).positionScanAtRowLocation(rowLocation);
            this.needsRepositioning = true;
        }
        this.setCurrentRow(this.resultRow);
        return this.resultRow;
    }

    private DataValueDescriptor[] getRowArrayFromHashTable(int n) throws StandardException {
        this.positionInHashTable.setValue(n);
        DataValueDescriptor[] dataValueDescriptorArray = (DataValueDescriptor[])this.ht.get(this.positionInHashTable);
        DataValueDescriptor[] dataValueDescriptorArray2 = new DataValueDescriptor[dataValueDescriptorArray.length - this.extraColumns];
        System.arraycopy(dataValueDescriptorArray, this.extraColumns, dataValueDescriptorArray2, 0, dataValueDescriptorArray2.length);
        return dataValueDescriptorArray2;
    }

    private void positionInLastFetchedRow() throws StandardException {
        if (this.positionInSource > 0) {
            this.positionInHashTable.setValue(this.positionInSource);
            DataValueDescriptor[] dataValueDescriptorArray = (DataValueDescriptor[])this.ht.get(this.positionInHashTable);
            RowLocation rowLocation = (RowLocation)dataValueDescriptorArray[1];
            ((NoPutResultSet)((Object)this.target)).positionScanAtRowLocation(rowLocation);
            this.currentPosition = this.positionInSource;
        }
    }

    public void updateRow(ExecRow execRow) throws StandardException {
        ExecRow execRow2 = execRow;
        boolean bl = false;
        if (this.source instanceof ProjectRestrictResultSet) {
            execRow2 = ((ProjectRestrictResultSet)this.source).doBaseRowProjection(execRow);
            bl = true;
        }
        this.positionInHashTable.setValue(this.currentPosition);
        DataValueDescriptor[] dataValueDescriptorArray = (DataValueDescriptor[])this.ht.get(this.positionInHashTable);
        RowLocation rowLocation = (RowLocation)dataValueDescriptorArray[1];
        this.ht.remove(new SQLInteger(this.currentPosition));
        this.addRowToHashTable(execRow2, this.currentPosition, rowLocation, true);
        if (bl) {
            DataValueDescriptor[] dataValueDescriptorArray2 = execRow2.getRowArray();
            int[] nArray = ((ProjectRestrictResultSet)this.source).getBaseProjectMapping();
            DataValueDescriptor[] dataValueDescriptorArray3 = this.getRowArrayFromHashTable(this.currentPosition);
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] < 0) continue;
                execRow.setColumn(nArray[i], dataValueDescriptorArray3[i]);
            }
        } else {
            execRow.setRowArray(this.getRowArrayFromHashTable(this.currentPosition));
        }
    }

    public void markRowAsDeleted() throws StandardException {
        this.positionInHashTable.setValue(this.currentPosition);
        DataValueDescriptor[] dataValueDescriptorArray = (DataValueDescriptor[])this.ht.get(this.positionInHashTable);
        RowLocation rowLocation = (RowLocation)dataValueDescriptorArray[1];
        this.ht.remove(new SQLInteger(this.currentPosition));
        ((SQLBoolean)dataValueDescriptorArray[2]).setValue(true);
        for (int i = this.extraColumns; i < dataValueDescriptorArray.length; ++i) {
            dataValueDescriptorArray[i].setToNull();
        }
        this.ht.putRow(true, dataValueDescriptorArray);
    }

    public boolean isDeleted() throws StandardException {
        if (this.currentPosition <= this.positionInSource && this.currentPosition > 0) {
            this.positionInHashTable.setValue(this.currentPosition);
            DataValueDescriptor[] dataValueDescriptorArray = (DataValueDescriptor[])this.ht.get(this.positionInHashTable);
            return dataValueDescriptorArray[2].getBoolean();
        }
        return false;
    }

    public boolean isUpdated() throws StandardException {
        if (this.currentPosition <= this.positionInSource && this.currentPosition > 0) {
            this.positionInHashTable.setValue(this.currentPosition);
            DataValueDescriptor[] dataValueDescriptorArray = (DataValueDescriptor[])this.ht.get(this.positionInHashTable);
            return dataValueDescriptorArray[3].getBoolean();
        }
        return false;
    }

    public boolean isForUpdate() {
        return this.source.isForUpdate();
    }
}

