/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.support;

import java.io.Serializable;
import org.springframework.beans.support.SortDefinition;
import org.springframework.util.StringUtils;

public class MutableSortDefinition
implements SortDefinition,
Serializable {
    private String property = "";
    private boolean ignoreCase = true;
    private boolean ascending = true;
    private boolean toggleAscendingOnProperty = false;

    public MutableSortDefinition() {
    }

    public MutableSortDefinition(SortDefinition sortDefinition) {
        this.property = sortDefinition.getProperty();
        this.ignoreCase = sortDefinition.isIgnoreCase();
        this.ascending = sortDefinition.isAscending();
    }

    public MutableSortDefinition(String string, boolean bl, boolean bl2) {
        this.property = string;
        this.ignoreCase = bl;
        this.ascending = bl2;
    }

    public MutableSortDefinition(boolean bl) {
        this.toggleAscendingOnProperty = bl;
    }

    public void setProperty(String string) {
        if (!StringUtils.hasLength((String)string)) {
            this.property = "";
        } else {
            if (this.isToggleAscendingOnProperty()) {
                this.ascending = !string.equals(this.property) || !this.ascending;
            }
            this.property = string;
        }
    }

    public String getProperty() {
        return this.property;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setAscending(boolean bl) {
        this.ascending = bl;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setToggleAscendingOnProperty(boolean bl) {
        this.toggleAscendingOnProperty = bl;
    }

    public boolean isToggleAscendingOnProperty() {
        return this.toggleAscendingOnProperty;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SortDefinition)) {
            return false;
        }
        SortDefinition sortDefinition = (SortDefinition)object;
        return this.getProperty().equals(sortDefinition.getProperty()) && this.isAscending() == sortDefinition.isAscending() && this.isIgnoreCase() == sortDefinition.isIgnoreCase();
    }

    public int hashCode() {
        int n = this.getProperty().hashCode();
        n = 29 * n + (this.isIgnoreCase() ? 1 : 0);
        n = 29 * n + (this.isAscending() ? 1 : 0);
        return n;
    }
}

