/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer.configure;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;

public class MRUFileManager {
    private static final String CONFIG_FILE_NAME = "mru_file_manager";
    private static final int DEFAULT_MAX_SIZE = 3;
    private int _maxSize = 0;
    private LinkedList _mruFileList;

    public MRUFileManager() {
        this.load();
        this.setMaxSize(3);
    }

    public MRUFileManager(int n) {
        this.load();
        this.setMaxSize(n);
    }

    public void save() {
        File file = new File(this.getFilename());
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(this._mruFileList);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int size() {
        return this._mruFileList.size();
    }

    public Object getFile(int n) {
        if (n < this.size()) {
            return this._mruFileList.get(n);
        }
        return null;
    }

    public InputStream getInputStream(int n) throws IOException, FileNotFoundException {
        if (n < this.size()) {
            Object object = this.getFile(n);
            if (object instanceof File) {
                return this.getInputStream((File)object);
            }
            return this.getInputStream((URL)object);
        }
        return null;
    }

    public void set(File file) {
        this.setMRU(file);
    }

    public void set(URL uRL) {
        this.setMRU(uRL);
    }

    public String[] getMRUFileList() {
        if (this.size() == 0) {
            return null;
        }
        String[] stringArray = new String[this.size()];
        int n = 0;
        while (n < this.size()) {
            Object object = this.getFile(n);
            stringArray[n] = object instanceof File ? ((File)object).getAbsolutePath() : object.toString();
            ++n;
        }
        return stringArray;
    }

    public void moveToTop(int n) {
        this._mruFileList.add(0, this._mruFileList.remove(n));
    }

    public static void createConfigurationDirectory() {
        String string = System.getProperty("user.home");
        String string2 = System.getProperty("file.separator");
        File file = new File(string + string2 + "lf5");
        if (!file.exists()) {
            try {
                file.mkdir();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
        }
    }

    protected InputStream getInputStream(File file) throws IOException, FileNotFoundException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        return bufferedInputStream;
    }

    protected InputStream getInputStream(URL uRL) throws IOException {
        return uRL.openStream();
    }

    protected void setMRU(Object object) {
        int n = this._mruFileList.indexOf(object);
        if (n == -1) {
            this._mruFileList.add(0, object);
            this.setMaxSize(this._maxSize);
        } else {
            this.moveToTop(n);
        }
    }

    protected void load() {
        MRUFileManager.createConfigurationDirectory();
        File file = new File(this.getFilename());
        if (file.exists()) {
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
                this._mruFileList = (LinkedList)objectInputStream.readObject();
                objectInputStream.close();
                Iterator iterator = this._mruFileList.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (e instanceof File || e instanceof URL) continue;
                    iterator.remove();
                }
            }
            catch (Exception exception) {
                this._mruFileList = new LinkedList();
            }
        } else {
            this._mruFileList = new LinkedList();
        }
    }

    protected String getFilename() {
        String string = System.getProperty("user.home");
        String string2 = System.getProperty("file.separator");
        return string + string2 + "lf5" + string2 + CONFIG_FILE_NAME;
    }

    protected void setMaxSize(int n) {
        if (n < this._mruFileList.size()) {
            int n2 = 0;
            while (n2 < this._mruFileList.size() - n) {
                this._mruFileList.removeLast();
                ++n2;
            }
        }
        this._maxSize = n;
    }
}

