/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.Canonicalizer;
import com.sun.org.apache.xml.internal.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.internal.security.utils.HelperNodeList;
import com.sun.org.apache.xml.internal.security.utils.I18n;
import com.sun.org.apache.xml.internal.security.utils.JavaUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLUtils {
    private static boolean ignoreLineBreaks = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("com.sun.org.apache.xml.internal.security.ignoreLineBreaks");
        }
    });
    private static volatile String dsPrefix = "ds";
    private static volatile String xencPrefix = "xenc";
    private static final Logger log = Logger.getLogger(XMLUtils.class.getName());
    static Map<String, String> namePrefixes = new HashMap<String, String>();

    private XMLUtils() {
    }

    public static void setDsPrefix(String string) {
        JavaUtils.checkRegisterPermission();
        dsPrefix = string;
    }

    public static void setXencPrefix(String string) {
        JavaUtils.checkRegisterPermission();
        xencPrefix = string;
    }

    public static Element getNextElement(Node node) {
        while (node != null && node.getNodeType() != 1) {
            node = node.getNextSibling();
        }
        return (Element)node;
    }

    public static void getSet(Node node, Set<Node> set, Node node2, boolean bl) {
        if (node2 != null && XMLUtils.isDescendantOrSelf(node2, node)) {
            return;
        }
        XMLUtils.getSetRec(node, set, node2, bl);
    }

    static final void getSetRec(Node node, Set<Node> set, Node node2, boolean bl) {
        if (node == node2) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: {
                Object object;
                set.add(node);
                Element element = (Element)node;
                if (element.hasAttributes()) {
                    object = ((Element)node).getAttributes();
                    for (int i = 0; i < object.getLength(); ++i) {
                        set.add(object.item(i));
                    }
                }
            }
            case 9: {
                Object object;
                for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
                    if (object.getNodeType() == 3) {
                        set.add((Node)object);
                        while (object != null && object.getNodeType() == 3) {
                            object = object.getNextSibling();
                        }
                        if (object == null) {
                            return;
                        }
                    }
                    XMLUtils.getSetRec((Node)object, set, node2, bl);
                }
                return;
            }
            case 8: {
                if (bl) {
                    set.add(node);
                }
                return;
            }
            case 10: {
                return;
            }
        }
        set.add(node);
    }

    public static void outputDOM(Node node, OutputStream outputStream) {
        XMLUtils.outputDOM(node, outputStream, false);
    }

    public static void outputDOM(Node node, OutputStream outputStream, boolean bl) {
        try {
            if (bl) {
                outputStream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes());
            }
            outputStream.write(Canonicalizer.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments").canonicalizeSubtree(node));
        }
        catch (IOException iOException) {
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            invalidCanonicalizerException.printStackTrace();
        }
        catch (CanonicalizationException canonicalizationException) {
            canonicalizationException.printStackTrace();
        }
    }

    public static void outputDOMc14nWithComments(Node node, OutputStream outputStream) {
        try {
            outputStream.write(Canonicalizer.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments").canonicalizeSubtree(node));
        }
        catch (IOException iOException) {
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
        }
        catch (CanonicalizationException canonicalizationException) {
            // empty catch block
        }
    }

    public static String getFullTextChildrenFromElement(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            stringBuffer.append(((Text)node).getData());
        }
        return stringBuffer.toString();
    }

    public static Element createElementInSignatureSpace(Document document, String string) {
        if (document == null) {
            throw new RuntimeException("Document is null");
        }
        if (dsPrefix == null || dsPrefix.length() == 0) {
            return document.createElementNS("http://www.w3.org/2000/09/xmldsig#", string);
        }
        String string2 = namePrefixes.get(string);
        if (string2 == null) {
            StringBuffer stringBuffer = new StringBuffer(dsPrefix);
            stringBuffer.append(':');
            stringBuffer.append(string);
            string2 = stringBuffer.toString();
            namePrefixes.put(string, string2);
        }
        return document.createElementNS("http://www.w3.org/2000/09/xmldsig#", string2);
    }

    public static boolean elementIsInSignatureSpace(Element element, String string) {
        if (element == null) {
            return false;
        }
        return "http://www.w3.org/2000/09/xmldsig#".equals(element.getNamespaceURI()) && element.getLocalName().equals(string);
    }

    public static boolean elementIsInEncryptionSpace(Element element, String string) {
        if (element == null) {
            return false;
        }
        return "http://www.w3.org/2001/04/xmlenc#".equals(element.getNamespaceURI()) && element.getLocalName().equals(string);
    }

    public static Document getOwnerDocument(Node node) {
        if (node.getNodeType() == 9) {
            return (Document)node;
        }
        try {
            return node.getOwnerDocument();
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException(I18n.translate("endorsed.jdk1.4.0") + " Original message was \"" + nullPointerException.getMessage() + "\"");
        }
    }

    public static Document getOwnerDocument(Set<Node> set) {
        Throwable throwable = null;
        for (Node node : set) {
            short s = node.getNodeType();
            if (s == 9) {
                return (Document)node;
            }
            try {
                if (s == 2) {
                    return ((Attr)node).getOwnerElement().getOwnerDocument();
                }
                return node.getOwnerDocument();
            }
            catch (NullPointerException nullPointerException) {
                throwable = nullPointerException;
            }
        }
        throw new NullPointerException(I18n.translate("endorsed.jdk1.4.0") + " Original message was \"" + (throwable == null ? "" : throwable.getMessage()) + "\"");
    }

    public static Element createDSctx(Document document, String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("You must supply a prefix");
        }
        Element element = document.createElementNS(null, "namespaceContext");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string.trim(), string2);
        return element;
    }

    public static void addReturnToElement(Element element) {
        if (!ignoreLineBreaks) {
            Document document = element.getOwnerDocument();
            element.appendChild(document.createTextNode("\n"));
        }
    }

    public static void addReturnToElement(Document document, HelperNodeList helperNodeList) {
        if (!ignoreLineBreaks) {
            helperNodeList.appendChild(document.createTextNode("\n"));
        }
    }

    public static void addReturnBeforeChild(Element element, Node node) {
        if (!ignoreLineBreaks) {
            Document document = element.getOwnerDocument();
            element.insertBefore(document.createTextNode("\n"), node);
        }
    }

    public static Set<Node> convertNodelistToSet(NodeList nodeList) {
        if (nodeList == null) {
            return new HashSet<Node>();
        }
        int n = nodeList.getLength();
        HashSet<Node> hashSet = new HashSet<Node>(n);
        for (int i = 0; i < n; ++i) {
            hashSet.add(nodeList.item(i));
        }
        return hashSet;
    }

    public static void circumventBug2650(Document document) {
        Element element = document.getDocumentElement();
        Attr attr = element.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", "xmlns");
        if (attr == null) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        }
        XMLUtils.circumventBug2650internal(document);
    }

    private static void circumventBug2650internal(Node node) {
        Node node2 = null;
        Node node3 = null;
        while (true) {
            switch (node.getNodeType()) {
                case 1: {
                    Element element = (Element)node;
                    if (!element.hasChildNodes()) break;
                    if (element.hasAttributes()) {
                        NamedNodeMap namedNodeMap = element.getAttributes();
                        int n = namedNodeMap.getLength();
                        for (Node node4 = element.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                            if (node4.getNodeType() != 1) continue;
                            Element element2 = (Element)node4;
                            for (int i = 0; i < n; ++i) {
                                Attr attr = (Attr)namedNodeMap.item(i);
                                if ("http://www.w3.org/2000/xmlns/" != attr.getNamespaceURI() || element2.hasAttributeNS("http://www.w3.org/2000/xmlns/", attr.getLocalName())) continue;
                                element2.setAttributeNS("http://www.w3.org/2000/xmlns/", attr.getName(), attr.getNodeValue());
                            }
                        }
                    }
                }
                case 5: 
                case 9: {
                    node2 = node;
                    node3 = node.getFirstChild();
                }
            }
            while (node3 == null && node2 != null) {
                node3 = node2.getNextSibling();
                node2 = node2.getParentNode();
            }
            if (node3 == null) {
                return;
            }
            node = node3;
            node3 = node.getNextSibling();
        }
    }

    public static Element selectDsNode(Node node, String string, int n) {
        while (node != null) {
            if ("http://www.w3.org/2000/09/xmldsig#".equals(node.getNamespaceURI()) && node.getLocalName().equals(string)) {
                if (n == 0) {
                    return (Element)node;
                }
                --n;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public static Element selectXencNode(Node node, String string, int n) {
        while (node != null) {
            if ("http://www.w3.org/2001/04/xmlenc#".equals(node.getNamespaceURI()) && node.getLocalName().equals(string)) {
                if (n == 0) {
                    return (Element)node;
                }
                --n;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public static Text selectDsNodeText(Node node, String string, int n) {
        Node node2 = XMLUtils.selectDsNode(node, string, n);
        if (node2 == null) {
            return null;
        }
        for (node2 = node2.getFirstChild(); node2 != null && node2.getNodeType() != 3; node2 = node2.getNextSibling()) {
        }
        return (Text)node2;
    }

    public static Text selectNodeText(Node node, String string, String string2, int n) {
        Node node2 = XMLUtils.selectNode(node, string, string2, n);
        if (node2 == null) {
            return null;
        }
        for (node2 = node2.getFirstChild(); node2 != null && node2.getNodeType() != 3; node2 = node2.getNextSibling()) {
        }
        return (Text)node2;
    }

    public static Element selectNode(Node node, String string, String string2, int n) {
        while (node != null) {
            if (node.getNamespaceURI() != null && node.getNamespaceURI().equals(string) && node.getLocalName().equals(string2)) {
                if (n == 0) {
                    return (Element)node;
                }
                --n;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public static Element[] selectDsNodes(Node node, String string) {
        return XMLUtils.selectNodes(node, "http://www.w3.org/2000/09/xmldsig#", string);
    }

    public static Element[] selectNodes(Node node, String string, String string2) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        while (node != null) {
            if (node.getNamespaceURI() != null && node.getNamespaceURI().equals(string) && node.getLocalName().equals(string2)) {
                arrayList.add((Element)node);
            }
            node = node.getNextSibling();
        }
        return arrayList.toArray(new Element[arrayList.size()]);
    }

    public static Set<Node> excludeNodeFromSet(Node node, Set<Node> set) {
        HashSet<Node> hashSet = new HashSet<Node>();
        for (Node node2 : set) {
            if (XMLUtils.isDescendantOrSelf(node, node2)) continue;
            hashSet.add(node2);
        }
        return hashSet;
    }

    public static boolean isDescendantOrSelf(Node node, Node node2) {
        if (node == node2) {
            return true;
        }
        Node node3 = node2;
        while (node3 != null) {
            if (node3 == node) {
                return true;
            }
            if (node3.getNodeType() == 2) {
                node3 = ((Attr)node3).getOwnerElement();
                continue;
            }
            node3 = node3.getParentNode();
        }
        return false;
    }

    public static boolean ignoreLineBreaks() {
        return ignoreLineBreaks;
    }

    public static boolean protectAgainstWrappingAttack(Node node, String string) {
        Node node2 = node.getParentNode();
        Node node3 = null;
        Element element = null;
        String string2 = string.trim();
        if (string2.charAt(0) == '#') {
            string2 = string2.substring(1);
        }
        while (node != null) {
            Element element2;
            NamedNodeMap namedNodeMap;
            if (node.getNodeType() == 1 && (namedNodeMap = (element2 = (Element)node).getAttributes()) != null) {
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Attr attr = (Attr)namedNodeMap.item(i);
                    if (!attr.isId() || !string2.equals(attr.getValue())) continue;
                    if (element == null) {
                        element = attr.getOwnerElement();
                        continue;
                    }
                    log.log(Level.FINE, "Multiple elements with the same 'Id' attribute value!");
                    return false;
                }
            }
            node3 = node;
            if ((node = node.getFirstChild()) == null) {
                node = node3.getNextSibling();
            }
            while (node == null) {
                if ((node3 = node3.getParentNode()) == node2) {
                    return true;
                }
                node = node3.getNextSibling();
            }
        }
        return true;
    }

    public static boolean protectAgainstWrappingAttack(Node node, Element element, String string) {
        Node node2 = node.getParentNode();
        Node node3 = null;
        String string2 = string.trim();
        if (string2.charAt(0) == '#') {
            string2 = string2.substring(1);
        }
        while (node != null) {
            Element element2;
            NamedNodeMap namedNodeMap;
            if (node.getNodeType() == 1 && (namedNodeMap = (element2 = (Element)node).getAttributes()) != null) {
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Attr attr = (Attr)namedNodeMap.item(i);
                    if (!attr.isId() || !string2.equals(attr.getValue()) || element2 == element) continue;
                    log.log(Level.FINE, "Multiple elements with the same 'Id' attribute value!");
                    return false;
                }
            }
            node3 = node;
            if ((node = node.getFirstChild()) == null) {
                node = node3.getNextSibling();
            }
            while (node == null) {
                if ((node3 = node3.getParentNode()) == node2) {
                    return true;
                }
                node = node3.getNextSibling();
            }
        }
        return true;
    }
}

