/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view.component;

import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.view.component.I18NListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class MyCalendarPanel
extends JDialog
implements I18NListener {
    private static final long serialVersionUID = -1329364976709789113L;
    private JComboBox comboBoxMonth;
    private JSpinner spinnerYear;
    private MyJTable table;
    private MyJTableModel tableModel;
    private Calendar calendar;
    private String[] days = new String[]{"SUN", "MON", "TUR", "WED", "THU", "FRI", "SAT"};
    private String[] months = new String[]{bd.getString("message.january"), bd.getString("message.february"), bd.getString("message.march"), bd.getString("message.april"), bd.getString("message.may"), bd.getString("message.june"), bd.getString("message.july"), bd.getString("message.august"), bd.getString("message.september"), bd.getString("message.october"), bd.getString("message.november"), bd.getString("message.december")};
    private int year = -1;
    private int month = -1;
    private int date = -1;
    private boolean flag = true;
    private JTextField textField;

    public MyCalendarPanel(JTextField textField) {
        this.setModal(true);
        this.textField = textField;
        this.calendar = Calendar.getInstance();
        this.initComponent();
        this.setIconImage(Constants.CONNECTEDIMG);
        this.setSize(300, 300);
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public String getCalendarByDate() {
        String format = GlobalVariables.globalConfig.getDateFormat();
        SimpleDateFormat dfmt = new SimpleDateFormat(format);
        String time = dfmt.format(this.calendar.getTime());
        return time;
    }

    private void initComponent() {
        this.setLayout(new BorderLayout());
        this.setNorthPanel();
        this.setCenterPanel();
        this.eventListenter();
        this.setData();
    }

    private void setData() {
        this.year = this.calendar.get(1);
        this.month = this.calendar.get(2);
        this.date = this.calendar.get(5);
        this.comboBoxMonth.setSelectedIndex(this.month);
        this.spinnerYear.setValue(new Integer(this.year));
    }

    private void eventListenter() {
        this.spinnerYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MyCalendarPanel.this.year = Integer.parseInt(String.valueOf(MyCalendarPanel.this.spinnerYear.getValue()));
                MyCalendarPanel.this.refreshTable();
            }
        });
        this.comboBoxMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyCalendarPanel.this.month = MyCalendarPanel.this.comboBoxMonth.getSelectedIndex();
                MyCalendarPanel.this.refreshTable();
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = MyCalendarPanel.this.table.rowAtPoint(e.getPoint());
                int col = MyCalendarPanel.this.table.columnAtPoint(e.getPoint());
                Object val = MyCalendarPanel.this.table.getValueAt(row, col);
                if (val != null && row != 0) {
                    if (MyCalendarPanel.this.table.getSelectedRow() > -1 && MyCalendarPanel.this.table.getSelectedColumn() > -1) {
                        MyCalendarPanel.this.date = Integer.parseInt(String.valueOf(MyCalendarPanel.this.table.getValueAt(MyCalendarPanel.this.table.getSelectedRow(), MyCalendarPanel.this.table.getSelectedColumn())));
                        MyCalendarPanel.this.calendar.set(1, MyCalendarPanel.this.year);
                        MyCalendarPanel.this.calendar.set(2, MyCalendarPanel.this.month);
                        MyCalendarPanel.this.calendar.set(5, MyCalendarPanel.this.date);
                    }
                    MyCalendarPanel.this.textField.setText(MyCalendarPanel.this.getCalendarByDate());
                    MyCalendarPanel.this.textField.requestFocus();
                    MyCalendarPanel.this.dispose();
                }
            }
        });
        AbstractAction right = new AbstractAction(){
            private static final long serialVersionUID = -3429888240127305492L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MyCalendarPanel.this.table.getColumnCount() == MyCalendarPanel.this.table.getSelectedColumn() + 1) {
                    MyCalendarPanel.this.table.changeSelection(MyCalendarPanel.this.table.getSelectedRow() + 1, 0, false, false);
                } else {
                    MyCalendarPanel.this.table.changeSelection(MyCalendarPanel.this.table.getSelectedRow(), MyCalendarPanel.this.table.getSelectedColumn() + 1, false, false);
                }
            }
        };
        AbstractAction left = new AbstractAction(){
            private static final long serialVersionUID = -2487040789339112435L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MyCalendarPanel.this.table.getSelectedColumn() - 1 < 0) {
                    MyCalendarPanel.this.table.changeSelection(MyCalendarPanel.this.table.getSelectedRow() - 1, MyCalendarPanel.this.table.getColumnCount() - 1, false, false);
                } else {
                    MyCalendarPanel.this.table.changeSelection(MyCalendarPanel.this.table.getSelectedRow(), MyCalendarPanel.this.table.getSelectedColumn() - 1, false, false);
                }
            }
        };
        InputMap inputMap = this.table.getInputMap(1);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(39, 0);
        this.table.getActionMap().put(inputMap.get(keyStroke), right);
        keyStroke = KeyStroke.getKeyStroke(37, 0);
        this.table.getActionMap().put(inputMap.get(keyStroke), left);
    }

    private void refreshTable() {
        int i = this.tableModel.getRowCount() - 1;
        while (i > 0) {
            this.tableModel.removeRow(i);
            --i;
        }
        this.calendar.set(1, this.year);
        this.calendar.set(2, this.month);
        int maxDate = this.calendar.getActualMaximum(5);
        this.calendar.set(5, 1);
        int startDay = this.calendar.get(7);
        int i2 = 0;
        while (i2 < 6) {
            this.tableModel.addRow(new Object[7]);
            ++i2;
        }
        int selectRow = -1;
        int selectColumn = -1;
        int i3 = 0;
        while (i3 < maxDate) {
            int m = (startDay - 1) / 7 + 1;
            int n = (startDay - 1) % 7;
            this.tableModel.setValueAt(String.valueOf(i3 + 1), m, n);
            ++startDay;
            if (this.date != -1 && this.date == i3 + 1) {
                selectRow = m;
                selectColumn = n;
            }
            ++i3;
        }
        this.table.changeSelection(selectRow, selectColumn, false, false);
    }

    private void setCenterPanel() {
        this.table = new MyJTable();
        this.tableModel = new MyJTableModel();
        this.tableModel.setColumnIdentifiers(this.days);
        this.tableModel.addRow(this.days);
        this.table.setModel(this.tableModel);
        int i = 0;
        while (i < 7) {
            this.table.getColumnModel().getColumn(i).setCellRenderer(new DefaultTableCellRenderer2());
            ++i;
        }
        this.add((Component)this.table, "Center");
    }

    private void setNorthPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        this.comboBoxMonth = new JComboBox();
        int i = 0;
        while (i < this.months.length) {
            this.comboBoxMonth.addItem(this.months[i]);
            ++i;
        }
        this.comboBoxMonth.setSelectedIndex(-1);
        panel.add(this.comboBoxMonth);
        RolloverSpinnerListModel numberModel = new RolloverSpinnerListModel(1980, 1980, 2099, 1);
        this.spinnerYear = new JSpinner(numberModel);
        JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor(this.spinnerYear, "####");
        this.spinnerYear.setEditor(numberEditor);
        panel.add(this.spinnerYear);
        this.add((Component)panel, "North");
    }

    public static void main(String[] args) {
        MyCalendarPanel calendarPanel = new MyCalendarPanel(null);
        calendarPanel.setSize(300, 300);
        calendarPanel.setLocationRelativeTo(null);
        calendarPanel.setVisible(true);
    }

    @Override
    protected void validateTree() {
        super.validateTree();
        if (this.flag) {
            this.table.requestFocus();
            this.flag = false;
        }
    }

    @Override
    public void changeLang() {
    }

    class DateBean
    implements Serializable {
        private static final long serialVersionUID = 3010787830585461136L;
        private String dt;
        private String view;

        public DateBean(String dt, String view) {
            this.dt = dt;
            this.view = view;
        }

        public String getDt() {
            return this.dt;
        }

        public void setDt(String dt) {
            this.dt = dt;
        }

        public String getView() {
            return this.view;
        }

        public void setView(String view) {
            this.view = view;
        }

        public String toString() {
            return this.view;
        }
    }

    class DefaultTableCellRenderer2
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -8779549993366848535L;

        DefaultTableCellRenderer2() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setHorizontalAlignment(0);
            if (row == 0) {
                component.setBackground(UIManager.getColor("Table.focusCellForeground"));
                component.setForeground(UIManager.getColor("Table.focusCellBackground"));
                return component;
            }
            if (isSelected) {
                component.setBackground(UIManager.getColor("Table.focusCellForeground"));
                component.setForeground(UIManager.getColor("Table.focusCellBackground"));
            } else {
                component.setBackground(UIManager.getColor("Table.focusCellBackground"));
                component.setForeground(UIManager.getColor("Table.focusCellForeground"));
            }
            if (column == 0 || column == 6) {
                component.setForeground(Color.red);
            }
            return component;
        }
    }

    class MyJTable
    extends JTable {
        private static final long serialVersionUID = 2092799354481792367L;

        public MyJTable() {
            this.getTableHeader().setReorderingAllowed(false);
            this.getTableHeader().setResizingAllowed(false);
            this.setSelectionMode(0);
            this.setCellSelectionEnabled(true);
            this.setGridColor(Color.white);
        }

        @Override
        public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
            if (this.getValueAt(rowIndex, columnIndex) == null) {
                return;
            }
            if (rowIndex == 0) {
                return;
            }
            super.changeSelection(rowIndex, columnIndex, toggle, extend);
        }

        @Override
        public void repaint(int x, int y, int width, int height) {
            super.repaint(x, y, width, height);
            if (height > 0) {
                this.makeTableRowHeight();
            }
        }

        @Override
        protected void validateTree() {
            super.validateTree();
            this.makeTableRowHeight();
        }

        private void makeTableRowHeight() {
            int rowHeight = (int)((double)(this.getHeight() / 7) * 0.6);
            if (rowHeight > 0) {
                this.setRowHeight(0, rowHeight);
            }
            if ((rowHeight = (this.getHeight() - rowHeight) / 6) > 0) {
                int i = 1;
                while (i < 8) {
                    this.setRowHeight(i, rowHeight);
                    ++i;
                }
            }
        }
    }

    class MyJTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 3655520869200784738L;

        MyJTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    class RolloverSpinnerListModel
    extends SpinnerNumberModel {
        private static final long serialVersionUID = 7366455425120197392L;

        public RolloverSpinnerListModel(int value, int minimum, int maximum, int stepSize) {
            super(value, minimum, maximum, stepSize);
        }

        @Override
        public Object getNextValue() {
            Comparable<?> returnValue = super.getNextValue();
            if (returnValue == null) {
                returnValue = super.getMinimum();
            }
            return returnValue;
        }

        @Override
        public Object getPreviousValue() {
            Comparable<?> returnValue = super.getPreviousValue();
            if (returnValue == null) {
                returnValue = super.getMaximum();
            }
            return returnValue;
        }
    }
}

