/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.work;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.SECSerialHandler;
import cn.com.voltronic.solar.communicate.SECUSBHandler;
import cn.com.voltronic.solar.communicate.SerialHandler;
import cn.com.voltronic.solar.communicate.SerialHandlerSolaris;
import cn.com.voltronic.solar.communicate.USBHandler;
import cn.com.voltronic.solar.configure.SystemEnv;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.socket.UdpClient;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.system.ProcessorCategories;
import gnu.io.CommPortIdentifier;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import usb.IUSBComm;
import usb.MacUSBRemote;
import usb.USBCommEx;

public class SearchDevice
extends Thread {
    protected static final Logger logger = Logger.getLogger(SearchDevice.class);
    private IUSBComm usbComm;
    private int currentLinkCount;
    private int oldLinkCount;
    private ArrayList<AbstractProcessor> templist = new ArrayList();

    public SearchDevice() {
        if (SystemUtils.IS_OS_MAC_OSX) {
            MacUSBRemote macusbdriver = new MacUSBRemote();
            this.usbComm = macusbdriver;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        } else if (SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_SOLARIS) {
            USBCommEx usbdriver = new USBCommEx();
            this.usbComm = usbdriver;
        } else {
            USBCommEx usbdriver = new USBCommEx();
            this.usbComm = usbdriver;
        }
    }

    @Override
    public void run() {
        SearchComDevice com = new SearchComDevice();
        com.start();
        SearchUsbDevice usb = new SearchUsbDevice();
        usb.start();
    }

    public synchronized void sendToTray() {
        int status = this.getLinkCount();
        UdpClient udpClient = null;
        if (status == 1) {
            try {
                try {
                    String port = "38694";
                    try {
                        port = GlobalVariables.globalConfig.getUdpPort();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (port != null && !"".equals(port)) {
                        udpClient = new UdpClient("localhost", port);
                        udpClient.send("(PVCount:" + this.currentLinkCount);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (udpClient != null) {
                        udpClient.disconnect();
                    }
                }
            }
            finally {
                if (udpClient != null) {
                    udpClient.disconnect();
                }
            }
        }
    }

    public int getLinkCount() {
        this.currentLinkCount = GlobalProcessors.getProcesserSize();
        if (this.oldLinkCount != this.currentLinkCount) {
            this.oldLinkCount = this.currentLinkCount;
            return 1;
        }
        return -1;
    }

    public void searchLocalComs() {
        Enumeration portEn = CommPortIdentifier.getPortIdentifiers();
        while (portEn.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)portEn.nextElement();
            if (portId.getPortType() != 1) continue;
            Object handler = GlobalProcessors.getUsedHandlerbyName(portId.getName());
            if (!GlobalVariables.globalConfig.isUseCOM() || GlobalProcessors.getSMSCom().equalsIgnoreCase(portId.getName().trim()) || GlobalProcessors.getExcludeComs().contains(portId.getName()) || handler != null) continue;
            try {
                this.searchSerialPort(portId);
                handler = GlobalProcessors.getUsedHandlerbyName(portId.getName());
                if (!GlobalVariables.globalConfig.isUseSEC()) continue;
                this.searchSerialPortSEC(portId);
                handler = GlobalProcessors.getUsedHandlerbyName(portId.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void searchSerialPortSEC(CommPortIdentifier portId) throws Exception {
        SECSerialHandler handler = null;
        handler = new SECSerialHandler(portId);
        AbstractProcessor processor = ProcessorCategories.getSerialSecMonitor(handler);
        if (processor != null) {
            processor.setDeviceName(handler.getDeviceName());
            this.doProcessor(processor);
        } else {
            handler.close();
        }
        try {
            for (AbstractProcessor process : this.templist) {
                try {
                    process.startMonitor();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
            }
            this.templist.clear();
            SearchDevice.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void searchSerialPort(CommPortIdentifier portId) throws Exception {
        IComUSBHandler handler = null;
        handler = SystemUtils.IS_OS_SOLARIS || SystemUtils.IS_OS_SUN_OS ? new SerialHandlerSolaris(portId) : new SerialHandler(portId);
        AbstractProcessor processor = ProcessorCategories.getSerialMonitor(handler);
        if (processor != null) {
            processor.setDeviceName(handler.getDeviceName());
            this.doProcessor(processor);
        } else {
            handler.close();
        }
        try {
            for (AbstractProcessor process : this.templist) {
                System.out.println(process.getDeviceName());
                try {
                    process.startMonitor();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.templist.clear();
            SearchDevice.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void searchUsb() {
        if (!GlobalVariables.globalConfig.isUseUSB()) {
            return;
        }
        this.searchLocalUsb();
        this.searchLocalSECUsb();
    }

    private void searchLocalSECUsb() {
        if (!GlobalVariables.globalConfig.isUseSEC()) {
            return;
        }
        String usbDevices = this.usbComm.findUSBDevices();
        if (StringUtils.isEmpty((String)usbDevices)) {
            return;
        }
        String[] devices = usbDevices.split("#");
        if (devices != null && devices.length > 0) {
            String[] stringArray = devices;
            int n = devices.length;
            int n2 = 0;
            while (n2 < n) {
                String usbId = stringArray[n2];
                Object existhandler = GlobalProcessors.getUsedHandlerbyName("USB" + usbId);
                if (existhandler == null) {
                    SECUSBHandler sechandler = new SECUSBHandler(this.usbComm, usbId);
                    AbstractProcessor processor = ProcessorCategories.getUsbSecMonitor(sechandler);
                    if (processor != null) {
                        processor.setDeviceName(sechandler.getDeviceName());
                        this.doProcessor(processor);
                    } else {
                        sechandler.close();
                    }
                    try {
                        for (AbstractProcessor process : this.templist) {
                            try {
                                process.startMonitor();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        this.templist.clear();
                        SearchDevice.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
    }

    public void searchLocalUsb() {
        String usbDevices = this.usbComm.findUSBDevices();
        if (StringUtils.isEmpty((String)usbDevices)) {
            return;
        }
        String[] devices = usbDevices.split("#");
        if (devices != null && devices.length > 0) {
            String[] stringArray = devices;
            int n = devices.length;
            int n2 = 0;
            while (n2 < n) {
                String usbId = stringArray[n2];
                Object existhandler = GlobalProcessors.getUsedHandlerbyName("USB" + usbId);
                if (existhandler == null) {
                    USBHandler handler = new USBHandler(this.usbComm, usbId);
                    AbstractProcessor processor = ProcessorCategories.getUsbMonitor(handler);
                    if (processor != null) {
                        processor.setDeviceName(handler.getDeviceName());
                        this.doProcessor(processor);
                    } else {
                        handler.close();
                    }
                    try {
                        for (AbstractProcessor process : this.templist) {
                            try {
                                process.startMonitor();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        this.templist.clear();
                        SearchDevice.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
    }

    private void doProcessor(AbstractProcessor processer) {
        if (GlobalProcessors.findProcessor(processer.processorKey()) == null) {
            GlobalProcessors.addProcessor(processer.processorKey(), processer);
            this.templist.add(processer);
        }
    }

    private class SearchComDevice
    extends Thread {
        private SearchComDevice() {
        }

        @Override
        public void run() {
            int time_i = 0;
            while (!SystemEnv.stopping) {
                if (time_i >= GlobalVariables.globalConfig.getDeviceSacanInterval()) {
                    SearchDevice.this.searchLocalComs();
                    time_i = 0;
                    SearchDevice.this.sendToTray();
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ++time_i;
            }
            ++SystemEnv.stoped;
            logger.debug((Object)" out of search thread ");
        }
    }

    private class SearchUsbDevice
    extends Thread {
        private SearchUsbDevice() {
        }

        @Override
        public void run() {
            int time_i = 0;
            while (!SystemEnv.stopping) {
                if (time_i >= GlobalVariables.globalConfig.getDeviceSacanInterval()) {
                    SearchDevice.this.searchUsb();
                    time_i = 0;
                    SearchDevice.this.sendToTray();
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ++time_i;
            }
            ++SystemEnv.stoped;
            logger.debug((Object)" out of search thread ");
        }
    }
}

