/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.j2d;

import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.prism.MediaFrame;
import com.sun.prism.PixelFormat;
import com.sun.prism.Presentable;
import com.sun.prism.RTTexture;
import com.sun.prism.RenderingContext;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.impl.BaseRenderingContext;
import com.sun.prism.impl.BaseResourceFactory;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.impl.shape.BasicShapeRep;
import com.sun.prism.j2d.J2DPresentable;
import com.sun.prism.j2d.J2DRTTexture;
import com.sun.prism.j2d.J2DTexture;
import com.sun.prism.shape.ShapeRep;

public class J2DResourceFactory
extends BaseResourceFactory
implements ResourceFactory {
    private Screen screen;
    private static ShapeRep theRep = new BasicShapeRep();

    public J2DResourceFactory(Screen screen) {
        this.screen = screen;
    }

    public Screen getScreen() {
        return this.screen;
    }

    @Override
    public ShapeRep createArcRep(boolean bl) {
        return theRep;
    }

    @Override
    public ShapeRep createEllipseRep(boolean bl) {
        return theRep;
    }

    @Override
    public ShapeRep createRoundRectRep(boolean bl) {
        return theRep;
    }

    @Override
    public ShapeRep createPathRep(boolean bl) {
        return theRep;
    }

    @Override
    public Presentable createPresentable(View view) {
        return J2DPresentable.create(view, this);
    }

    @Override
    public RTTexture createRTTexture(int n, int n2) {
        return new J2DRTTexture(n, n2, this);
    }

    @Override
    public Texture createTexture(PixelFormat pixelFormat, Texture.Usage usage, int n, int n2, boolean bl) {
        return new J2DTexture(pixelFormat, n, n2);
    }

    @Override
    public Texture createTexture(MediaFrame mediaFrame) {
        mediaFrame.holdFrame();
        if (mediaFrame.getPixelFormat() != PixelFormat.INT_ARGB_PRE) {
            MediaFrame mediaFrame2 = mediaFrame.convertToFormat(PixelFormat.INT_ARGB_PRE);
            mediaFrame.releaseFrame();
            mediaFrame = mediaFrame2;
            if (null == mediaFrame) {
                return null;
            }
        }
        J2DTexture j2DTexture = new J2DTexture(mediaFrame.getPixelFormat(), mediaFrame.getWidth(), mediaFrame.getHeight());
        mediaFrame.releaseFrame();
        return j2DTexture;
    }

    @Override
    public int getMaximumTextureSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isFormatSupported(PixelFormat pixelFormat) {
        switch (pixelFormat) {
            case BYTE_RGB: 
            case BYTE_GRAY: 
            case INT_ARGB_PRE: 
            case BYTE_BGRA_PRE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public VertexBuffer createVertexBuffer(int n) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public RenderingContext createRenderingContext(View view) {
        return new BaseRenderingContext();
    }

    @Override
    public void dispose() {
    }
}

