/*
 * Decompiled with CFR 0.152.
 */
package javafx.util.converter;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javafx.util.StringConverter;

public class DateTimeStringConverter
extends StringConverter<Date> {
    protected final Locale locale;
    protected final String pattern;
    protected final DateFormat dateFormat;

    public DateTimeStringConverter() {
        this(Locale.getDefault());
    }

    public DateTimeStringConverter(Locale locale) {
        this(locale, null);
    }

    public DateTimeStringConverter(String string) {
        this(Locale.getDefault(), string, null);
    }

    public DateTimeStringConverter(Locale locale, String string) {
        this(locale, string, null);
    }

    public DateTimeStringConverter(DateFormat dateFormat) {
        this(null, null, dateFormat);
    }

    DateTimeStringConverter(Locale locale, String string, DateFormat dateFormat) {
        this.locale = locale;
        this.pattern = string;
        this.dateFormat = dateFormat;
    }

    @Override
    public Date fromString(String string) {
        try {
            if (string == null) {
                return null;
            }
            if ((string = string.trim()).length() < 1) {
                return null;
            }
            DateFormat dateFormat = this.getDateFormat();
            return dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }

    @Override
    public String toString(Date date) {
        if (date == null) {
            return "";
        }
        DateFormat dateFormat = this.getDateFormat();
        return dateFormat.format(date);
    }

    protected DateFormat getDateFormat() {
        Locale locale = this.locale == null ? Locale.getDefault() : this.locale;
        DateFormat dateFormat = null;
        if (this.dateFormat != null) {
            return this.dateFormat;
        }
        dateFormat = this.pattern != null ? new SimpleDateFormat(this.pattern, locale) : DateFormat.getDateTimeInstance();
        dateFormat.setLenient(false);
        return dateFormat;
    }
}

