/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ClassEditor
extends PropertyEditorSupport {
    private final ClassLoader classLoader;

    public ClassEditor() {
        this(null);
    }

    public ClassEditor(ClassLoader classLoader) {
        this.classLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (StringUtils.hasText((String)string)) {
            this.setValue(ClassUtils.resolveClassName((String)string.trim(), (ClassLoader)this.classLoader));
        } else {
            this.setValue(null);
        }
    }

    public String getAsText() {
        Class clazz = (Class)this.getValue();
        if (clazz != null) {
            return ClassUtils.getQualifiedName((Class)clazz);
        }
        return "";
    }
}

