/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.ConnectionContext;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.impl.sql.execute.NoRowsResultSetImpl;

class CallStatementResultSet
extends NoRowsResultSetImpl {
    private final GeneratedMethod methodCall;

    CallStatementResultSet(GeneratedMethod generatedMethod, Activation activation) throws StandardException {
        super(activation);
        this.methodCall = generatedMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws StandardException {
        this.setup();
        LanguageConnectionContext languageConnectionContext = this.activation.getLanguageConnectionContext();
        languageConnectionContext.pushCaller(this.activation);
        this.activation.setNestedCurrentRole(languageConnectionContext.getCurrentRoleId(this.activation));
        try {
            this.methodCall.invoke(this.activation);
        }
        finally {
            this.activation.getLanguageConnectionContext().popCaller();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws StandardException {
        super.close();
        ResultSet[][] resultSetArray = this.getActivation().getDynamicResults();
        if (resultSetArray != null) {
            StandardException standardException = null;
            ConnectionContext connectionContext = null;
            for (int i = 0; i < resultSetArray.length; ++i) {
                ResultSet[] resultSetArray2 = resultSetArray[i];
                ResultSet resultSet = resultSetArray2[0];
                if (resultSet == null) continue;
                if (connectionContext == null) {
                    connectionContext = (ConnectionContext)((Object)this.lcc.getContextManager().getContext("JDBC_ConnectionContext"));
                }
                try {
                    if (!connectionContext.processInaccessibleDynamicResult(resultSet)) continue;
                    resultSet.close();
                    continue;
                }
                catch (SQLException sQLException) {
                    StandardException standardException2;
                    if (standardException != null) continue;
                    standardException = standardException2 = StandardException.plainWrapException(sQLException);
                    continue;
                }
                finally {
                    resultSetArray2[0] = null;
                }
            }
            if (standardException != null) {
                throw standardException;
            }
        }
    }

    public void cleanUp() throws StandardException {
        this.close();
    }
}

