/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import org.apache.commons.lang.SystemUtils;

public class WordUtils {
    public static String wrap(String string, int n) {
        return WordUtils.wrap(string, n, null, false);
    }

    public static String wrap(String string, int n, String string2, boolean bl) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = SystemUtils.LINE_SEPARATOR;
        }
        if (n < 1) {
            n = 1;
        }
        int n2 = string.length();
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer(n2 + 32);
        while (n2 - n3 > n) {
            if (string.charAt(n3) == ' ') {
                ++n3;
                continue;
            }
            int n4 = string.lastIndexOf(32, n + n3);
            if (n4 >= n3) {
                stringBuffer.append(string.substring(n3, n4));
                stringBuffer.append(string2);
                n3 = n4 + 1;
                continue;
            }
            if (bl) {
                stringBuffer.append(string.substring(n3, n + n3));
                stringBuffer.append(string2);
                n3 += n;
                continue;
            }
            n4 = string.indexOf(32, n + n3);
            if (n4 >= 0) {
                stringBuffer.append(string.substring(n3, n4));
                stringBuffer.append(string2);
                n3 = n4 + 1;
                continue;
            }
            stringBuffer.append(string.substring(n3));
            n3 = n2;
        }
        stringBuffer.append(string.substring(n3));
        return stringBuffer.toString();
    }

    public static String capitalize(String string) {
        return WordUtils.capitalize(string, null);
    }

    public static String capitalize(String string, char[] cArray) {
        int n;
        int n2 = n = cArray == null ? -1 : cArray.length;
        if (string == null || string.length() == 0 || n == 0) {
            return string;
        }
        int n3 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n3);
        boolean bl = true;
        int n4 = 0;
        while (n4 < n3) {
            char c = string.charAt(n4);
            if (WordUtils.isDelimiter(c, cArray)) {
                stringBuffer.append(c);
                bl = true;
            } else if (bl) {
                stringBuffer.append(Character.toTitleCase(c));
                bl = false;
            } else {
                stringBuffer.append(c);
            }
            ++n4;
        }
        return stringBuffer.toString();
    }

    public static String capitalizeFully(String string) {
        return WordUtils.capitalizeFully(string, null);
    }

    public static String capitalizeFully(String string, char[] cArray) {
        int n;
        int n2 = n = cArray == null ? -1 : cArray.length;
        if (string == null || string.length() == 0 || n == 0) {
            return string;
        }
        string = string.toLowerCase();
        return WordUtils.capitalize(string, cArray);
    }

    public static String uncapitalize(String string) {
        return WordUtils.uncapitalize(string, null);
    }

    public static String uncapitalize(String string, char[] cArray) {
        int n;
        int n2 = n = cArray == null ? -1 : cArray.length;
        if (string == null || string.length() == 0 || n == 0) {
            return string;
        }
        int n3 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n3);
        boolean bl = true;
        int n4 = 0;
        while (n4 < n3) {
            char c = string.charAt(n4);
            if (WordUtils.isDelimiter(c, cArray)) {
                stringBuffer.append(c);
                bl = true;
            } else if (bl) {
                stringBuffer.append(Character.toLowerCase(c));
                bl = false;
            } else {
                stringBuffer.append(c);
            }
            ++n4;
        }
        return stringBuffer.toString();
    }

    public static String swapCase(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        boolean bl = true;
        char c = '\u0000';
        char c2 = '\u0000';
        int n2 = 0;
        while (n2 < n) {
            c = string.charAt(n2);
            c2 = Character.isUpperCase(c) ? Character.toLowerCase(c) : (Character.isTitleCase(c) ? Character.toLowerCase(c) : (Character.isLowerCase(c) ? (bl ? Character.toTitleCase(c) : Character.toUpperCase(c)) : c));
            stringBuffer.append(c2);
            bl = Character.isWhitespace(c);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String initials(String string) {
        return WordUtils.initials(string, null);
    }

    public static String initials(String string, char[] cArray) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (cArray != null && cArray.length == 0) {
            return "";
        }
        int n = string.length();
        char[] cArray2 = new char[n / 2 + 1];
        int n2 = 0;
        boolean bl = true;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (WordUtils.isDelimiter(c, cArray)) {
                bl = true;
            } else if (bl) {
                cArray2[n2++] = c;
                bl = false;
            }
            ++n3;
        }
        return new String(cArray2, 0, n2);
    }

    private static boolean isDelimiter(char c, char[] cArray) {
        if (cArray == null) {
            return Character.isWhitespace(c);
        }
        int n = 0;
        int n2 = cArray.length;
        while (n < n2) {
            if (c == cArray[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

