/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.RoleDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class DropRoleConstantAction
extends DDLConstantAction {
    private final String roleName;

    DropRoleConstantAction(String string) {
        this.roleName = string;
    }

    public String toString() {
        return "DROP ROLE " + this.roleName;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        dataDictionary.startWriting(languageConnectionContext);
        RoleDescriptor roleDescriptor = dataDictionary.getRoleDefinitionDescriptor(this.roleName);
        if (roleDescriptor == null) {
            throw StandardException.newException("0P000", this.roleName);
        }
        roleDescriptor.drop(languageConnectionContext);
        dataDictionary.dropRoleGrantsByGrantee(this.roleName, transactionController);
        dataDictionary.dropRoleGrantsByName(this.roleName, transactionController);
        dataDictionary.dropAllPermsByGrantee(this.roleName, transactionController);
    }
}

