/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.mbeanserver.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.management.relation.InvalidRelationTypeException;
import javax.management.relation.RelationType;
import javax.management.relation.RoleInfo;
import javax.management.relation.RoleInfoNotFoundException;

public class RelationTypeSupport
implements RelationType {
    private static final long oldSerialVersionUID = -8179019472410837190L;
    private static final long newSerialVersionUID = 4611072955724144607L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("myTypeName", String.class), new ObjectStreamField("myRoleName2InfoMap", HashMap.class), new ObjectStreamField("myIsInRelServFlg", Boolean.TYPE)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("typeName", String.class), new ObjectStreamField("roleName2InfoMap", Map.class), new ObjectStreamField("isInRelationService", Boolean.TYPE)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    private String typeName = null;
    private Map<String, RoleInfo> roleName2InfoMap = new HashMap<String, RoleInfo>();
    private boolean isInRelationService = false;

    public RelationTypeSupport(String string, RoleInfo[] roleInfoArray) throws IllegalArgumentException, InvalidRelationTypeException {
        if (string == null || roleInfoArray == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationTypeSupport.class.getName(), "RelationTypeSupport", string);
        this.initMembers(string, roleInfoArray);
        JmxProperties.RELATION_LOGGER.exiting(RelationTypeSupport.class.getName(), "RelationTypeSupport");
    }

    protected RelationTypeSupport(String string) {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationTypeSupport.class.getName(), "RelationTypeSupport", string);
        this.typeName = string;
        JmxProperties.RELATION_LOGGER.exiting(RelationTypeSupport.class.getName(), "RelationTypeSupport");
    }

    @Override
    public String getRelationTypeName() {
        return this.typeName;
    }

    @Override
    public List<RoleInfo> getRoleInfos() {
        return new ArrayList<RoleInfo>(this.roleName2InfoMap.values());
    }

    @Override
    public RoleInfo getRoleInfo(String string) throws IllegalArgumentException, RoleInfoNotFoundException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationTypeSupport.class.getName(), "getRoleInfo", string);
        RoleInfo roleInfo = this.roleName2InfoMap.get(string);
        if (roleInfo == null) {
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = "No role info for role ";
            stringBuilder.append(string3);
            stringBuilder.append(string);
            throw new RoleInfoNotFoundException(stringBuilder.toString());
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationTypeSupport.class.getName(), "getRoleInfo");
        return roleInfo;
    }

    protected void addRoleInfo(RoleInfo roleInfo) throws IllegalArgumentException, InvalidRelationTypeException {
        if (roleInfo == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationTypeSupport.class.getName(), "addRoleInfo", roleInfo);
        if (this.isInRelationService) {
            String string = "Relation type cannot be updated as it is declared in the Relation Service.";
            throw new RuntimeException(string);
        }
        String string = roleInfo.getName();
        if (this.roleName2InfoMap.containsKey(string)) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = "Two role infos provided for role ";
            stringBuilder.append(string2);
            stringBuilder.append(string);
            throw new InvalidRelationTypeException(stringBuilder.toString());
        }
        this.roleName2InfoMap.put(string, new RoleInfo(roleInfo));
        JmxProperties.RELATION_LOGGER.exiting(RelationTypeSupport.class.getName(), "addRoleInfo");
    }

    void setRelationServiceFlag(boolean bl) {
        this.isInRelationService = bl;
    }

    private void initMembers(String string, RoleInfo[] roleInfoArray) throws IllegalArgumentException, InvalidRelationTypeException {
        if (string == null || roleInfoArray == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationTypeSupport.class.getName(), "initMembers", string);
        this.typeName = string;
        RelationTypeSupport.checkRoleInfos(roleInfoArray);
        for (int i = 0; i < roleInfoArray.length; ++i) {
            RoleInfo roleInfo = roleInfoArray[i];
            this.roleName2InfoMap.put(roleInfo.getName(), new RoleInfo(roleInfo));
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationTypeSupport.class.getName(), "initMembers");
    }

    static void checkRoleInfos(RoleInfo[] roleInfoArray) throws IllegalArgumentException, InvalidRelationTypeException {
        if (roleInfoArray == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        if (roleInfoArray.length == 0) {
            String string = "No role info provided.";
            throw new InvalidRelationTypeException(string);
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < roleInfoArray.length; ++i) {
            String string;
            RoleInfo roleInfo = roleInfoArray[i];
            if (roleInfo == null) {
                string = "Null role info provided.";
                throw new InvalidRelationTypeException(string);
            }
            string = roleInfo.getName();
            if (hashSet.contains(string)) {
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = "Two role infos provided for role ";
                stringBuilder.append(string2);
                stringBuilder.append(string);
                throw new InvalidRelationTypeException(stringBuilder.toString());
            }
            hashSet.add(string);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (compat) {
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            this.typeName = (String)getField.get("myTypeName", null);
            if (getField.defaulted("myTypeName")) {
                throw new NullPointerException("myTypeName");
            }
            this.roleName2InfoMap = (Map)Util.cast(getField.get("myRoleName2InfoMap", null));
            if (getField.defaulted("myRoleName2InfoMap")) {
                throw new NullPointerException("myRoleName2InfoMap");
            }
            this.isInRelationService = getField.get("myIsInRelServFlg", false);
            if (getField.defaulted("myIsInRelServFlg")) {
                throw new NullPointerException("myIsInRelServFlg");
            }
        } else {
            objectInputStream.defaultReadObject();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField putField = objectOutputStream.putFields();
            putField.put("myTypeName", this.typeName);
            putField.put("myRoleName2InfoMap", this.roleName2InfoMap);
            putField.put("myIsInRelServFlg", this.isInRelationService);
            objectOutputStream.writeFields();
        } else {
            objectOutputStream.defaultWriteObject();
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction getPropertyAction = new GetPropertyAction("jmx.serial.form");
            String string = AccessController.doPrivileged(getPropertyAction);
            compat = string != null && string.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = -8179019472410837190L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = 4611072955724144607L;
        }
    }
}

