/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.communicate;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ICommunicateDevice;
import cn.com.voltronic.solar.communicate.ISECProtocolHandler;
import cn.com.voltronic.solar.communicate.SECFormat;
import cn.com.voltronic.solar.communicate.SerialHandler;
import cn.com.voltronic.solar.debug.Debug;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.util.CRCUtil;
import cn.com.voltronic.solar.util.VolUtil;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SECSerialHandler
implements IComUSBHandler,
ICommunicateDevice,
ISECProtocolHandler {
    private Logger logger = Logger.getLogger(SECSerialHandler.class);
    private CommPortIdentifier portId;
    private InputStream input = null;
    private OutputStream output = null;
    private SerialPort serialPort;
    private int _errorcount = 0;
    private boolean isUseCRC = false;
    protected AbstractProcessor notifyProcesser;

    private void clearbuffer() {
        try {
            if (this.input == null) {
                return;
            }
            int buflen = this.input.available();
            while (buflen > 0) {
                this.input.read();
                --buflen;
            }
        }
        catch (Exception e) {
            this.logger.info((Object)e.getMessage());
        }
    }

    public SECSerialHandler(CommPortIdentifier portId) throws Exception {
        this.portId = portId;
        int baudRate = 2400;
        try {
            this.serialPort = (SerialPort)portId.open("Arista", baudRate);
            this.serialPort.enableReceiveTimeout(1200);
            this.serialPort.setSerialPortParams(baudRate, 8, 1, 0);
            this.input = this.serialPort.getInputStream();
            this.output = this.serialPort.getOutputStream();
        }
        catch (UnsupportedCommOperationException e) {
            this.logger.error((Object)e.getMessage());
        }
        catch (PortInUseException e) {
            this.logger.error((Object)e.getMessage());
        }
        catch (NullPointerException e) {
            this.logger.error((Object)e.getMessage());
        }
    }

    @Override
    public synchronized String excuteSimpleCommand(String command) {
        String returnValue;
        block11: {
            boolean result = true;
            int time = 0;
            returnValue = "";
            String senddata = SECFormat.addPollHeader(command);
            if (this.isUseCRC()) {
                senddata = SECFormat.addPollHeader(command, 2);
            }
            try {
                try {
                    while ((StringUtils.isEmpty((String)returnValue) || returnValue.startsWith("(NAK")) && time < 3) {
                        this.clearbuffer();
                        byte[] crc = CRCUtil.getCRCByte(senddata);
                        byte[] bytes = senddata.getBytes();
                        this.output.write(bytes);
                        if (this.isUseCRC()) {
                            this.output.write(crc);
                        }
                        this.output.write(13);
                        this.output.flush();
                        long end = System.currentTimeMillis() + 3000L;
                        StringBuilder sb = new StringBuilder();
                        boolean flag = false;
                        while (System.currentTimeMillis() < end) {
                            int ch = this.input.read();
                            if (ch < 0) continue;
                            if (ch != 13) {
                                sb.append((char)ch);
                                continue;
                            }
                            flag = true;
                            break;
                        }
                        if (!flag) {
                            result = false;
                        }
                        returnValue = SECFormat.getNodeData(sb.toString());
                        ++time;
                    }
                }
                catch (Exception ex) {
                    result = false;
                    this.countErrorandNotifyProcesser(result);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                this.countErrorandNotifyProcesser(result);
                throw throwable;
            }
            this.countErrorandNotifyProcesser(result);
        }
        Debug.debug(command, returnValue);
        return returnValue;
    }

    public void setBaudRate1200() {
        try {
            this.serialPort.setSerialPortParams(1200, 8, 1, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized String excuteCommand(String command, boolean isResponse) {
        String returnValue;
        block12: {
            boolean result = true;
            returnValue = "";
            String senddata = SECFormat.addPollHeader(command);
            if (this.isUseCRC()) {
                senddata = SECFormat.addPollHeader(command, 2);
            }
            int time = 0;
            try {
                try {
                    while ((StringUtils.isEmpty((String)returnValue) || returnValue.startsWith("(NAK")) && time < 3) {
                        this.clearbuffer();
                        byte[] crc = CRCUtil.getCRCByte(senddata);
                        byte[] bytes = senddata.getBytes();
                        this.output.write(bytes);
                        if (this.isUseCRC()) {
                            this.output.write(crc);
                        }
                        this.output.write(13);
                        this.output.flush();
                        if (!isResponse) {
                            returnValue = null;
                            break;
                        }
                        long end = System.currentTimeMillis() + 3000L;
                        StringBuilder sb = new StringBuilder();
                        boolean flag = false;
                        while (System.currentTimeMillis() < end) {
                            int ch = this.input.read();
                            if (ch < 0) continue;
                            if (ch != 13) {
                                sb.append((char)ch);
                                continue;
                            }
                            flag = true;
                            break;
                        }
                        if (!flag) {
                            result = false;
                        }
                        returnValue = sb.toString();
                        returnValue = SECFormat.getNodeData(returnValue);
                        ++time;
                    }
                }
                catch (Exception ex) {
                    result = false;
                    this.countErrorandNotifyProcesser(result);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                this.countErrorandNotifyProcesser(result);
                throw throwable;
            }
            this.countErrorandNotifyProcesser(result);
        }
        Debug.debug(command, returnValue);
        return returnValue;
    }

    private void countErrorandNotifyProcesser(boolean success) {
        this._errorcount = success ? 0 : ++this._errorcount;
        if (this._errorcount >= 3 && this.notifyProcesser != null) {
            System.out.println("---------communication exception---------" + this._errorcount);
            this.notifyProcesser.close();
        }
    }

    @Override
    public void close() {
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.serialPort != null) {
            try {
                this.serialPort.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public String getDeviceName() {
        String portName = this.portId.getName();
        int index = portName.lastIndexOf("/");
        if (index > 0) {
            portName = portName.substring(index + 1, portName.length());
        }
        return portName;
    }

    @Override
    public void setNotifyProcess(AbstractProcessor process) {
        this.notifyProcesser = process;
    }

    @Override
    public int getMpptTrackNumber() {
        int mpptTrackNumber = 2;
        String qpigsStr = this.excuteCommand("GS", true);
        if (!"".equals(qpigsStr) && !qpigsStr.equals("(NAK")) {
            String[] qpigsArr = qpigsStr.split(",");
            mpptTrackNumber = VolUtil.parseInt(qpigsArr[7]);
        }
        return mpptTrackNumber;
    }

    @Override
    public String getSerialNo() {
        String serialno = "";
        String serialnoStr = "";
        try {
            int i = 0;
            while (i < 3) {
                serialnoStr = this.excuteCommand("ID", true);
                if (!(StringUtils.isEmpty((String)serialnoStr) || serialnoStr.equalsIgnoreCase("(NAK") || serialnoStr.equalsIgnoreCase("(ACK"))) {
                    String validLen = serialnoStr.substring(0, 2);
                    serialno = serialnoStr.substring(2, 2 + Integer.valueOf(validLen));
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serialno;
    }

    @Override
    public String getModeType() {
        String machineTypeStr = "";
        try {
            String qpiriStr = this.excuteCommand("PIRI", true);
            if (!StringUtils.isEmpty((String)qpiriStr) && !qpiriStr.equals("(NAK")) {
                String[] ratingInfo = qpiriStr.split(",");
                machineTypeStr = ratingInfo[8];
                return machineTypeStr;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return machineTypeStr;
    }

    @Override
    public String getDeviceModel() {
        String _deviceModel = "";
        try {
            String qdmStr = this.excuteCommand("DM", true);
            if (!StringUtils.isEmpty((String)qdmStr) && !qdmStr.equals("(NAK")) {
                _deviceModel = qdmStr;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return _deviceModel;
    }

    @Override
    public void setCrcCheck(boolean isCrcCheck) {
    }

    public static void main(String[] args) {
        long curtime = 0L;
        String[] commands = new String[]{"QEH2013081409218"};
        Enumeration en = CommPortIdentifier.getPortIdentifiers();
        while (en.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)en.nextElement();
            try {
                SerialHandler comm = new SerialHandler(portId);
                comm.setCrcCheck(true);
                curtime = System.currentTimeMillis();
                String[] stringArray = commands;
                int n = commands.length;
                int n2 = 0;
                while (n2 < n) {
                    String cmd = stringArray[n2];
                    String result = comm.excuteCommand(cmd, true);
                    System.out.println("cmd:" + cmd + "=" + result + " length=" + result.length());
                    ++n2;
                }
                System.out.println(System.currentTimeMillis() - curtime);
                System.exit(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized String excuteSetCommand(String command, boolean isResponse) {
        boolean result = true;
        String returnValue = "";
        String senddata = SECFormat.addSetHeader(command);
        if (this.isUseCRC()) {
            senddata = SECFormat.addSetHeader(command, 2);
        }
        int time = 0;
        try {
            try {
                while (true) {
                    if (!StringUtils.isEmpty((String)returnValue)) {
                        if (!returnValue.startsWith("(NAK")) return returnValue;
                    }
                    if (time >= 3) {
                        return returnValue;
                    }
                    this.clearbuffer();
                    byte[] crc = CRCUtil.getCRCByte(senddata);
                    byte[] bytes = senddata.getBytes();
                    this.output.write(bytes);
                    if (this.isUseCRC()) {
                        this.output.write(crc);
                    }
                    this.output.write(13);
                    this.output.flush();
                    if (!isResponse) {
                        returnValue = null;
                        return returnValue;
                    }
                    long end = System.currentTimeMillis() + 3000L;
                    StringBuilder sb = new StringBuilder();
                    boolean flag = false;
                    while (System.currentTimeMillis() < end) {
                        int ch = this.input.read();
                        if (ch < 0) continue;
                        if (ch != 13) {
                            sb.append((char)ch);
                            continue;
                        }
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        result = false;
                    }
                    returnValue = sb.toString();
                    returnValue = SECFormat.getNodeData(returnValue);
                    ++time;
                }
            }
            catch (Exception ex) {
                result = false;
                this.countErrorandNotifyProcesser(result);
                return returnValue;
            }
        }
        finally {
            this.countErrorandNotifyProcesser(result);
        }
    }

    @Override
    public boolean isUseCRC() {
        return this.isUseCRC;
    }

    @Override
    public void setUseCRC(boolean isUseCRC) {
        this.isUseCRC = isUseCRC;
    }

    @Override
    public String getModelName() {
        return null;
    }
}

