/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.NullValueInNestedPathException;
import org.springframework.beans.PropertyAccessException;
import org.springframework.beans.PropertyBatchUpdateException;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;

public abstract class AbstractPropertyAccessor
extends PropertyEditorRegistrySupport
implements ConfigurablePropertyAccessor {
    private boolean extractOldValueForEditor = false;

    public void setExtractOldValueForEditor(boolean bl) {
        this.extractOldValueForEditor = bl;
    }

    public boolean isExtractOldValueForEditor() {
        return this.extractOldValueForEditor;
    }

    public void setPropertyValue(PropertyValue propertyValue) throws BeansException {
        this.setPropertyValue(propertyValue.getName(), propertyValue.getValue());
    }

    public void setPropertyValues(Map map) throws BeansException {
        this.setPropertyValues(new MutablePropertyValues(map));
    }

    public void setPropertyValues(PropertyValues propertyValues) throws BeansException {
        this.setPropertyValues(propertyValues, false, false);
    }

    public void setPropertyValues(PropertyValues propertyValues, boolean bl) throws BeansException {
        this.setPropertyValues(propertyValues, bl, false);
    }

    public void setPropertyValues(PropertyValues propertyValues, boolean bl, boolean bl2) throws BeansException {
        LinkedList<PropertyAccessException> linkedList = null;
        List<PropertyValue> list = propertyValues instanceof MutablePropertyValues ? ((MutablePropertyValues)propertyValues).getPropertyValueList() : Arrays.asList(propertyValues.getPropertyValues());
        PropertyAccessException[] propertyAccessExceptionArray = list.iterator();
        while (propertyAccessExceptionArray.hasNext()) {
            PropertyValue propertyValue = propertyAccessExceptionArray.next();
            try {
                this.setPropertyValue(propertyValue);
            }
            catch (NotWritablePropertyException notWritablePropertyException) {
                if (bl) continue;
                throw notWritablePropertyException;
            }
            catch (NullValueInNestedPathException nullValueInNestedPathException) {
                if (bl2) continue;
                throw nullValueInNestedPathException;
            }
            catch (PropertyAccessException propertyAccessException) {
                if (linkedList == null) {
                    linkedList = new LinkedList<PropertyAccessException>();
                }
                linkedList.add(propertyAccessException);
            }
        }
        if (linkedList != null) {
            propertyAccessExceptionArray = linkedList.toArray(new PropertyAccessException[linkedList.size()]);
            throw new PropertyBatchUpdateException(propertyAccessExceptionArray);
        }
    }

    public Class getPropertyType(String string) {
        return null;
    }

    public abstract Object getPropertyValue(String var1) throws BeansException;

    public abstract void setPropertyValue(String var1, Object var2) throws BeansException;
}

