/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.EventDetails;
import org.apache.log4j.chainsaw.MyTableModel;
import org.apache.log4j.spi.LoggingEvent;

class LoggingReceiver
extends Thread {
    private static final Logger LOG = Logger.getLogger(class$org$apache$log4j$chainsaw$LoggingReceiver == null ? (class$org$apache$log4j$chainsaw$LoggingReceiver = LoggingReceiver.class$("org.apache.log4j.chainsaw.LoggingReceiver")) : class$org$apache$log4j$chainsaw$LoggingReceiver);
    private MyTableModel mModel;
    private ServerSocket mSvrSock;
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$LoggingReceiver;

    LoggingReceiver(MyTableModel myTableModel, int n) throws IOException {
        this.setDaemon(true);
        this.mModel = myTableModel;
        this.mSvrSock = new ServerSocket(n);
    }

    public void run() {
        LOG.info("Thread started");
        try {
            while (true) {
                LOG.debug("Waiting for a connection");
                Socket socket = this.mSvrSock.accept();
                LOG.debug("Got a connection from " + socket.getInetAddress().getHostName());
                Thread thread = new Thread(new Slurper(socket));
                thread.setDaemon(true);
                thread.start();
            }
        }
        catch (IOException iOException) {
            LOG.error("Error in accepting connections, stopping.", iOException);
            return;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Slurper
    implements Runnable {
        private final Socket mClient;

        Slurper(Socket socket) {
            this.mClient = socket;
        }

        public void run() {
            LOG.debug("Starting to get data");
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(this.mClient.getInputStream());
                while (true) {
                    LoggingEvent loggingEvent = (LoggingEvent)objectInputStream.readObject();
                    LoggingReceiver.this.mModel.addEvent(new EventDetails(loggingEvent));
                }
            }
            catch (EOFException eOFException) {
                LOG.info("Reached EOF, closing connection");
            }
            catch (SocketException socketException) {
                LOG.info("Caught SocketException, closing connection");
            }
            catch (IOException iOException) {
                LOG.warn("Got IOException, closing connection", iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.warn("Got ClassNotFoundException, closing connection", classNotFoundException);
            }
            try {
                this.mClient.close();
            }
            catch (IOException iOException) {
                LOG.warn("Error closing connection", iOException);
            }
        }
    }
}

