/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.collections.map.IdentityMap;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.JdkVersion;
import org.springframework.util.ClassUtils;

public abstract class CollectionFactory {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$core$CollectionFactory == null ? (class$org$springframework$core$CollectionFactory = CollectionFactory.class$("org.springframework.core.CollectionFactory")) : class$org$springframework$core$CollectionFactory));
    private static final boolean commonsCollections3Available = ClassUtils.isPresent("org.apache.commons.collections.map.LinkedMap", (class$org$springframework$core$CollectionFactory == null ? (class$org$springframework$core$CollectionFactory = CollectionFactory.class$("org.springframework.core.CollectionFactory")) : class$org$springframework$core$CollectionFactory).getClassLoader());
    private static final boolean backportConcurrentAvailable = ClassUtils.isPresent("edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap", (class$org$springframework$core$CollectionFactory == null ? (class$org$springframework$core$CollectionFactory = CollectionFactory.class$("org.springframework.core.CollectionFactory")) : class$org$springframework$core$CollectionFactory).getClassLoader());
    static /* synthetic */ Class class$org$springframework$core$CollectionFactory;

    public static Set createLinkedSetIfPossible(int n) {
        if (JdkVersion.isAtLeastJava14()) {
            logger.trace((Object)"Creating [java.util.LinkedHashSet]");
            return JdkCollectionFactory.createLinkedHashSet(n);
        }
        if (commonsCollections3Available) {
            logger.trace((Object)"Creating [org.apache.commons.collections.set.ListOrderedSet]");
            return CommonsCollectionFactory.createListOrderedSet(n);
        }
        logger.debug((Object)"Falling back to plain [java.util.HashSet] for linked set");
        return new HashSet(n);
    }

    public static Map createLinkedMapIfPossible(int n) {
        if (JdkVersion.isAtLeastJava14()) {
            logger.trace((Object)"Creating [java.util.LinkedHashMap]");
            return JdkCollectionFactory.createLinkedHashMap(n);
        }
        if (commonsCollections3Available) {
            logger.trace((Object)"Creating [org.apache.commons.collections.map.LinkedMap]");
            return CommonsCollectionFactory.createLinkedMap(n);
        }
        logger.debug((Object)"Falling back to plain[java.util.HashMap] for linked map");
        return new HashMap(n);
    }

    public static Map createLinkedCaseInsensitiveMapIfPossible(int n) {
        if (commonsCollections3Available) {
            logger.trace((Object)"Creating [org.apache.commons.collections.map.ListOrderedMap/CaseInsensitiveMap]");
            return CommonsCollectionFactory.createListOrderedCaseInsensitiveMap(n);
        }
        if (JdkVersion.isAtLeastJava14()) {
            logger.debug((Object)"Falling back to [java.util.LinkedHashMap] for linked case-insensitive map");
            return JdkCollectionFactory.createLinkedHashMap(n);
        }
        logger.debug((Object)"Falling back to plain [java.util.HashMap] for linked case-insensitive map");
        return new HashMap(n);
    }

    public static Map createIdentityMapIfPossible(int n) {
        if (JdkVersion.isAtLeastJava14()) {
            logger.trace((Object)"Creating [java.util.IdentityHashMap]");
            return JdkCollectionFactory.createIdentityHashMap(n);
        }
        if (commonsCollections3Available) {
            logger.trace((Object)"Creating [org.apache.commons.collections.map.IdentityMap]");
            return CommonsCollectionFactory.createIdentityMap(n);
        }
        logger.debug((Object)"Falling back to plain [java.util.HashMap] for identity map");
        return new HashMap(n);
    }

    public static Map createConcurrentMapIfPossible(int n) {
        if (JdkVersion.isAtLeastJava15()) {
            logger.trace((Object)"Creating [java.util.concurrent.ConcurrentHashMap]");
            return JdkCollectionFactory.createConcurrentHashMap(n);
        }
        if (backportConcurrentAvailable) {
            logger.trace((Object)"Creating [edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap]");
            return BackportConcurrentCollectionFactory.createConcurrentHashMap(n);
        }
        logger.debug((Object)"Falling back to plain synchronized [java.util.HashMap] for concurrent map");
        return Collections.synchronizedMap(new HashMap(n));
    }

    public static Collection createApproximateCollection(Object object, int n) {
        if (object instanceof List) {
            return new ArrayList(n);
        }
        if (object instanceof SortedSet) {
            return new TreeSet(((SortedSet)object).comparator());
        }
        return CollectionFactory.createLinkedSetIfPossible(n);
    }

    public static Map createApproximateMap(Object object, int n) {
        if (object instanceof SortedMap) {
            return new TreeMap(((SortedMap)object).comparator());
        }
        return CollectionFactory.createLinkedMapIfPossible(n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static abstract class BackportConcurrentCollectionFactory {
        private BackportConcurrentCollectionFactory() {
        }

        private static Map createConcurrentHashMap(int n) {
            return new ConcurrentHashMap(n);
        }
    }

    private static abstract class CommonsCollectionFactory {
        private CommonsCollectionFactory() {
        }

        private static Set createListOrderedSet(int n) {
            return ListOrderedSet.decorate(new HashSet(n));
        }

        private static Map createLinkedMap(int n) {
            return new LinkedMap(n == 0 ? 1 : n);
        }

        private static Map createListOrderedCaseInsensitiveMap(int n) {
            return ListOrderedMap.decorate((Map)new CaseInsensitiveMap(n == 0 ? 1 : n));
        }

        private static Map createIdentityMap(int n) {
            return new IdentityMap(n == 0 ? 1 : n);
        }
    }

    private static abstract class JdkCollectionFactory {
        private JdkCollectionFactory() {
        }

        private static Set createLinkedHashSet(int n) {
            return new LinkedHashSet(n);
        }

        private static Map createLinkedHashMap(int n) {
            return new LinkedHashMap(n);
        }

        private static Map createIdentityHashMap(int n) {
            return new IdentityHashMap(n);
        }

        private static Map createConcurrentHashMap(int n) {
            return new java.util.concurrent.ConcurrentHashMap(n);
        }
    }
}

