/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.io.File;
import java.security.AccessControlException;
import java.util.Objects;
import javax.security.auth.kerberos.JavaxSecurityAuthKerberosAccessImpl;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import sun.misc.SharedSecrets;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;

public final class KeyTab {
    private final File file;

    private KeyTab(File file) {
        this.file = file;
    }

    public static KeyTab getInstance(File file) {
        if (file == null) {
            throw new NullPointerException("file must be non null");
        }
        return new KeyTab(file);
    }

    public static KeyTab getInstance() {
        return new KeyTab(null);
    }

    private sun.security.krb5.internal.ktab.KeyTab takeSnapshot() {
        try {
            return sun.security.krb5.internal.ktab.KeyTab.getInstance(this.file);
        }
        catch (AccessControlException accessControlException) {
            if (this.file != null) {
                throw accessControlException;
            }
            AccessControlException accessControlException2 = new AccessControlException("Access to default keytab denied (modified exception)");
            accessControlException2.setStackTrace(accessControlException.getStackTrace());
            throw accessControlException2;
        }
    }

    public KerberosKey[] getKeys(KerberosPrincipal kerberosPrincipal) {
        try {
            EncryptionKey[] encryptionKeyArray = this.takeSnapshot().readServiceKeys(new PrincipalName(kerberosPrincipal.getName()));
            KerberosKey[] kerberosKeyArray = new KerberosKey[encryptionKeyArray.length];
            for (int i = 0; i < kerberosKeyArray.length; ++i) {
                Integer n = encryptionKeyArray[i].getKeyVersionNumber();
                kerberosKeyArray[i] = new KerberosKey(kerberosPrincipal, encryptionKeyArray[i].getBytes(), encryptionKeyArray[i].getEType(), n == null ? 0 : n);
                encryptionKeyArray[i].destroy();
            }
            return kerberosKeyArray;
        }
        catch (RealmException realmException) {
            return new KerberosKey[0];
        }
    }

    EncryptionKey[] getEncryptionKeys(PrincipalName principalName) {
        return this.takeSnapshot().readServiceKeys(principalName);
    }

    public boolean exists() {
        return !this.takeSnapshot().isMissing();
    }

    public String toString() {
        return this.file == null ? "Default keytab" : this.file.toString();
    }

    public int hashCode() {
        return Objects.hash(this.file);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KeyTab)) {
            return false;
        }
        KeyTab keyTab = (KeyTab)object;
        return Objects.equals(keyTab.file, this.file);
    }

    static {
        SharedSecrets.setJavaxSecurityAuthKerberosAccess(new JavaxSecurityAuthKerberosAccessImpl());
    }
}

