/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import sun.org.mozilla.javascript.internal.Node;
import sun.org.mozilla.javascript.internal.ast.AstNode;
import sun.org.mozilla.javascript.internal.ast.Jump;
import sun.org.mozilla.javascript.internal.ast.NodeVisitor;
import sun.org.mozilla.javascript.internal.ast.ScriptNode;
import sun.org.mozilla.javascript.internal.ast.Symbol;

public class Scope
extends Jump {
    protected Map<String, Symbol> symbolTable;
    protected Scope parentScope;
    protected ScriptNode top;
    private List<Scope> childScopes;

    public Scope() {
        this.type = 129;
    }

    public Scope(int n) {
        this.type = 129;
        this.position = n;
    }

    public Scope(int n, int n2) {
        this(n);
        this.length = n2;
    }

    public Scope getParentScope() {
        return this.parentScope;
    }

    public void setParentScope(Scope scope) {
        this.parentScope = scope;
        this.top = scope == null ? (ScriptNode)this : scope.top;
    }

    public void clearParentScope() {
        this.parentScope = null;
    }

    public List<Scope> getChildScopes() {
        return this.childScopes;
    }

    public void addChildScope(Scope scope) {
        if (this.childScopes == null) {
            this.childScopes = new ArrayList<Scope>();
        }
        this.childScopes.add(scope);
        scope.setParentScope(this);
    }

    public void replaceWith(Scope scope) {
        if (this.childScopes != null) {
            for (Scope scope2 : this.childScopes) {
                scope.addChildScope(scope2);
            }
            this.childScopes.clear();
            this.childScopes = null;
        }
        if (this.symbolTable != null && !this.symbolTable.isEmpty()) {
            Scope.joinScopes(this, scope);
        }
    }

    public ScriptNode getTop() {
        return this.top;
    }

    public void setTop(ScriptNode scriptNode) {
        this.top = scriptNode;
    }

    public static Scope splitScope(Scope scope) {
        Scope scope2 = new Scope(scope.getType());
        scope2.symbolTable = scope.symbolTable;
        scope.symbolTable = null;
        scope2.parent = scope.parent;
        scope2.setParentScope(scope.getParentScope());
        scope2.setParentScope(scope2);
        scope.parent = scope2;
        scope2.top = scope.top;
        return scope2;
    }

    public static void joinScopes(Scope scope, Scope scope2) {
        Map<String, Symbol> map = scope.ensureSymbolTable();
        Map<String, Symbol> map2 = scope2.ensureSymbolTable();
        if (!Collections.disjoint(map.keySet(), map2.keySet())) {
            Scope.codeBug();
        }
        for (Map.Entry<String, Symbol> entry : map.entrySet()) {
            Symbol symbol = entry.getValue();
            symbol.setContainingTable(scope2);
            map2.put(entry.getKey(), symbol);
        }
    }

    public Scope getDefiningScope(String string) {
        Scope scope = this;
        while (scope != null) {
            Map<String, Symbol> map = scope.getSymbolTable();
            if (map != null && map.containsKey(string)) {
                return scope;
            }
            scope = scope.parentScope;
        }
        return null;
    }

    public Symbol getSymbol(String string) {
        return this.symbolTable == null ? null : this.symbolTable.get(string);
    }

    public void putSymbol(Symbol symbol) {
        if (symbol.getName() == null) {
            throw new IllegalArgumentException("null symbol name");
        }
        this.ensureSymbolTable();
        this.symbolTable.put(symbol.getName(), symbol);
        symbol.setContainingTable(this);
        this.top.addSymbol(symbol);
    }

    public Map<String, Symbol> getSymbolTable() {
        return this.symbolTable;
    }

    public void setSymbolTable(Map<String, Symbol> map) {
        this.symbolTable = map;
    }

    private Map<String, Symbol> ensureSymbolTable() {
        if (this.symbolTable == null) {
            this.symbolTable = new LinkedHashMap<String, Symbol>(5);
        }
        return this.symbolTable;
    }

    public List<AstNode> getStatements() {
        ArrayList<AstNode> arrayList = new ArrayList<AstNode>();
        for (Node node = this.getFirstChild(); node != null; node = node.getNext()) {
            arrayList.add((AstNode)node);
        }
        return arrayList;
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append("{\n");
        for (Node node : this) {
            stringBuilder.append(((AstNode)node).toSource(n + 1));
        }
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            for (Node node : this) {
                ((AstNode)node).visit(nodeVisitor);
            }
        }
    }
}

