/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.net.MalformedURLException;
import java.net.URL;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class DefaultResourceLoader
implements ResourceLoader {
    private ClassLoader classLoader;

    public DefaultResourceLoader() {
        this.classLoader = ClassUtils.getDefaultClassLoader();
    }

    public DefaultResourceLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Resource getResource(String string) {
        Assert.notNull(string, "Location must not be null");
        if (string.startsWith("classpath:")) {
            return new ClassPathResource(string.substring("classpath:".length()), this.getClassLoader());
        }
        try {
            URL uRL = new URL(string);
            return new UrlResource(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            return this.getResourceByPath(string);
        }
    }

    protected Resource getResourceByPath(String string) {
        return new ClassPathResource(string, this.getClassLoader());
    }
}

