/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.plugins.communicate.tool;

import cn.com.voltronic.plugins.communicate.tool.CommunicateException;
import cn.com.voltronic.plugins.communicate.tool.CommunicateHandler;
import cn.com.voltronic.plugins.communicate.tool.StringUtils;
import java.io.IOException;
import usb.IUSBComm;

public class USBHandler
extends CommunicateHandler {
    private String usbId;
    private IUSBComm usbComm;

    public USBHandler(IUSBComm usbComm, String usbId) {
        this.usbComm = usbComm;
        this.usbId = usbId;
    }

    @Override
    public String excuteSimpleCommand(String command, boolean isCRC) throws IOException {
        String returnValue = "";
        int time = 0;
        while (StringUtils.isEmpty(returnValue) && time < 3) {
            returnValue = this.sendCommand(this.usbId, String.valueOf(command) + "\r");
            ++time;
        }
        if (StringUtils.isEmpty(returnValue)) {
            throw new IOException();
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String excuteCommand(String command, boolean isResponse, boolean isCRC) throws CommunicateException {
        IUSBComm iUSBComm = this.usbComm;
        synchronized (iUSBComm) {
            if (isCRC) {
                this.usbComm.setUseCRC(1);
            } else {
                this.usbComm.setUseCRC(0);
            }
            String returnValue = this.sendCommand(this.usbId, String.valueOf(command) + "\r");
            if (isResponse) {
                int time = 0;
                while (StringUtils.isEmpty(returnValue) && time < 2) {
                    returnValue = this.sendCommand(this.usbId, String.valueOf(command) + "\r");
                    ++time;
                }
                if (StringUtils.isEmpty(returnValue)) {
                    throw new CommunicateException("Communication exception");
                }
            }
            return returnValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendCommand(String usbID, String command) {
        IUSBComm iUSBComm = this.usbComm;
        synchronized (iUSBComm) {
            return this.usbComm.sendCommand(usbID, command);
        }
    }

    @Override
    public void close() {
        if (this.usbComm != null) {
            try {
                this.usbComm.closeUSBPort(this.usbId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public String getDeviceName() {
        return "USB" + this.usbId;
    }
}

