/*
 * Decompiled with CFR 0.152.
 */
package usb;

import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.system.ShutdownInterface;
import cn.com.voltronic.solar.util.CRCUtil;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import usb.IUSBComm;
import usb.USBComm;

public class USBCommEx
implements IUSBComm,
ShutdownInterface {
    private Lock lock = new ReentrantLock();
    private USBComm usbNative = new USBComm();

    @Override
    public void shutdownOS() {
        this.lock.lock();
        try {
            this.waitforSolaris();
            this.usbNative.poweroffOS();
        }
        finally {
            this.lock.unlock();
        }
    }

    public static void main(String[] args) {
        USBCommEx usb = new USBCommEx();
        String dd = usb.findUSBDevices();
        String[] usbs = dd.split("#");
        System.out.println(usbs[0]);
        String qs = "GNTM0\r";
        String value = usb.sendCommand(usbs[0], qs);
        System.out.println(value);
        boolean re = CRCUtil.checkCRC(value);
        System.out.println(re);
    }

    @Override
    public String findUSBDevices() {
        this.lock.lock();
        try {
            this.waitforSolaris();
            String string = this.usbNative.findUSBDevices(1637, 20833);
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void beep(int time) {
    }

    @Override
    public void closeUSBPort(String usbID) {
        this.lock.lock();
        try {
            this.waitforSolaris();
            this.usbNative.closeUSBPort(usbID);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String sendCommand(String usbID, String command) {
        this.lock.lock();
        try {
            String xx;
            this.waitforSolaris();
            StringBuilder sb = new StringBuilder();
            byte[] bytes = this.usbNative.sendCommand(usbID, command);
            int i = 0;
            while (i < bytes.length - 1) {
                byte ch = bytes[i];
                sb.append((char)ch);
                ++i;
            }
            String string = xx = sb.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public synchronized void suspendOS() {
        this.lock.lock();
        try {
            this.waitforSolaris();
            this.usbNative.suspendOS();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void waitforSolaris() {
        if (!Constants.IS_OS_SOLARIS) {
            return;
        }
        try {
            Thread.sleep(10L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exitMacServ() {
    }

    @Override
    public boolean setUseCRC(int paramInt) {
        if (paramInt == 1) {
            this.usbNative.setUseCRC(1);
        } else {
            this.usbNative.setUseCRC(0);
        }
        return true;
    }

    public USBComm getUsbNative() {
        return this.usbNative;
    }

    public void setUsbNative(USBComm usbNative) {
        this.usbNative = usbNative;
    }
}

