/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.core.Conventions;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public abstract class AbstractSimpleBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected final void doParse(Element element, BeanDefinitionBuilder beanDefinitionBuilder) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            String string = attr.getLocalName();
            if (!this.isEligibleAttribute(string)) continue;
            String string2 = this.extractPropertyName(string);
            Assert.state((boolean)StringUtils.hasText((String)string2), (String)"Illegal property name returned from 'extractPropertyName(String)': cannot be null or empty.");
            beanDefinitionBuilder.addPropertyValue(string2, attr.getValue());
        }
        this.postProcess(beanDefinitionBuilder, element);
    }

    protected boolean isEligibleAttribute(String string) {
        return !"id".equals(string);
    }

    protected String extractPropertyName(String string) {
        return Conventions.attributeNameToPropertyName((String)string);
    }

    protected void postProcess(BeanDefinitionBuilder beanDefinitionBuilder, Element element) {
    }
}

