/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack.internal.logging;

import com.sun.istack.internal.NotNull;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class Logger {
    private static final String WS_LOGGING_SUBSYSTEM_NAME_ROOT = "com.sun.metro";
    private static final String ROOT_WS_PACKAGE = "com.sun.xml.internal.ws.";
    private static final Level METHOD_CALL_LEVEL_VALUE = Level.FINEST;
    private final String componentClassName;
    private final java.util.logging.Logger logger;

    protected Logger(String string, String string2) {
        this.componentClassName = "[" + string2 + "] ";
        this.logger = java.util.logging.Logger.getLogger(string);
    }

    @NotNull
    public static Logger getLogger(@NotNull Class<?> clazz) {
        return new Logger(Logger.getSystemLoggerName(clazz), clazz.getName());
    }

    @NotNull
    public static Logger getLogger(@NotNull String string, @NotNull Class<?> clazz) {
        return new Logger(string, clazz.getName());
    }

    static final String getSystemLoggerName(@NotNull Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder(clazz.getPackage().getName());
        int n = stringBuilder.lastIndexOf(ROOT_WS_PACKAGE);
        if (n > -1) {
            stringBuilder.replace(0, n + ROOT_WS_PACKAGE.length(), "");
            StringTokenizer stringTokenizer = new StringTokenizer(stringBuilder.toString(), ".");
            stringBuilder = new StringBuilder(WS_LOGGING_SUBSYSTEM_NAME_ROOT).append(".");
            if (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if ("api".equals(string)) {
                    string = stringTokenizer.nextToken();
                }
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    public void log(Level level, String string) {
        if (!this.logger.isLoggable(level)) {
            return;
        }
        this.logger.logp(level, this.componentClassName, Logger.getCallerMethodName(), string);
    }

    public void log(Level level, String string, Throwable throwable) {
        if (!this.logger.isLoggable(level)) {
            return;
        }
        this.logger.logp(level, this.componentClassName, Logger.getCallerMethodName(), string, throwable);
    }

    public void finest(String string) {
        if (!this.logger.isLoggable(Level.FINEST)) {
            return;
        }
        this.logger.logp(Level.FINEST, this.componentClassName, Logger.getCallerMethodName(), string);
    }

    public void finest(String string, Throwable throwable) {
        if (!this.logger.isLoggable(Level.FINEST)) {
            return;
        }
        this.logger.logp(Level.FINEST, this.componentClassName, Logger.getCallerMethodName(), string, throwable);
    }

    public void finer(String string) {
        if (!this.logger.isLoggable(Level.FINER)) {
            return;
        }
        this.logger.logp(Level.FINER, this.componentClassName, Logger.getCallerMethodName(), string);
    }

    public void finer(String string, Throwable throwable) {
        if (!this.logger.isLoggable(Level.FINER)) {
            return;
        }
        this.logger.logp(Level.FINER, this.componentClassName, Logger.getCallerMethodName(), string, throwable);
    }

    public void fine(String string) {
        if (!this.logger.isLoggable(Level.FINE)) {
            return;
        }
        this.logger.logp(Level.FINE, this.componentClassName, Logger.getCallerMethodName(), string);
    }

    public void fine(String string, Throwable throwable) {
        if (!this.logger.isLoggable(Level.FINE)) {
            return;
        }
        this.logger.logp(Level.FINE, this.componentClassName, Logger.getCallerMethodName(), string, throwable);
    }

    public void info(String string) {
        if (!this.logger.isLoggable(Level.INFO)) {
            return;
        }
        this.logger.logp(Level.INFO, this.componentClassName, Logger.getCallerMethodName(), string);
    }

    public void info(String string, Throwable throwable) {
        if (!this.logger.isLoggable(Level.INFO)) {
            return;
        }
        this.logger.logp(Level.INFO, this.componentClassName, Logger.getCallerMethodName(), string, throwable);
    }

    public void config(String string) {
        if (!this.logger.isLoggable(Level.CONFIG)) {
            return;
        }
        this.logger.logp(Level.CONFIG, this.componentClassName, Logger.getCallerMethodName(), string);
    }

    public void config(String string, Throwable throwable) {
        if (!this.logger.isLoggable(Level.CONFIG)) {
            return;
        }
        this.logger.logp(Level.CONFIG, this.componentClassName, Logger.getCallerMethodName(), string, throwable);
    }

    public void warning(String string) {
        if (!this.logger.isLoggable(Level.WARNING)) {
            return;
        }
        this.logger.logp(Level.WARNING, this.componentClassName, Logger.getCallerMethodName(), string);
    }

    public void warning(String string, Throwable throwable) {
        if (!this.logger.isLoggable(Level.WARNING)) {
            return;
        }
        this.logger.logp(Level.WARNING, this.componentClassName, Logger.getCallerMethodName(), string, throwable);
    }

    public void severe(String string) {
        if (!this.logger.isLoggable(Level.SEVERE)) {
            return;
        }
        this.logger.logp(Level.SEVERE, this.componentClassName, Logger.getCallerMethodName(), string);
    }

    public void severe(String string, Throwable throwable) {
        if (!this.logger.isLoggable(Level.SEVERE)) {
            return;
        }
        this.logger.logp(Level.SEVERE, this.componentClassName, Logger.getCallerMethodName(), string, throwable);
    }

    public boolean isMethodCallLoggable() {
        return this.logger.isLoggable(METHOD_CALL_LEVEL_VALUE);
    }

    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    public void setLevel(Level level) {
        this.logger.setLevel(level);
    }

    public void entering() {
        if (!this.logger.isLoggable(METHOD_CALL_LEVEL_VALUE)) {
            return;
        }
        this.logger.entering(this.componentClassName, Logger.getCallerMethodName());
    }

    public void entering(Object ... objectArray) {
        if (!this.logger.isLoggable(METHOD_CALL_LEVEL_VALUE)) {
            return;
        }
        this.logger.entering(this.componentClassName, Logger.getCallerMethodName(), objectArray);
    }

    public void exiting() {
        if (!this.logger.isLoggable(METHOD_CALL_LEVEL_VALUE)) {
            return;
        }
        this.logger.exiting(this.componentClassName, Logger.getCallerMethodName());
    }

    public void exiting(Object object) {
        if (!this.logger.isLoggable(METHOD_CALL_LEVEL_VALUE)) {
            return;
        }
        this.logger.exiting(this.componentClassName, Logger.getCallerMethodName(), object);
    }

    public <T extends Throwable> T logSevereException(T t, Throwable throwable) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            if (throwable == null) {
                this.logger.logp(Level.SEVERE, this.componentClassName, Logger.getCallerMethodName(), t.getMessage());
            } else {
                t.initCause(throwable);
                this.logger.logp(Level.SEVERE, this.componentClassName, Logger.getCallerMethodName(), t.getMessage(), throwable);
            }
        }
        return t;
    }

    public <T extends Throwable> T logSevereException(T t, boolean bl) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            if (bl && t.getCause() != null) {
                this.logger.logp(Level.SEVERE, this.componentClassName, Logger.getCallerMethodName(), t.getMessage(), t.getCause());
            } else {
                this.logger.logp(Level.SEVERE, this.componentClassName, Logger.getCallerMethodName(), t.getMessage());
            }
        }
        return t;
    }

    public <T extends Throwable> T logSevereException(T t) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            if (t.getCause() == null) {
                this.logger.logp(Level.SEVERE, this.componentClassName, Logger.getCallerMethodName(), t.getMessage());
            } else {
                this.logger.logp(Level.SEVERE, this.componentClassName, Logger.getCallerMethodName(), t.getMessage(), t.getCause());
            }
        }
        return t;
    }

    public <T extends Throwable> T logException(T t, Throwable throwable, Level level) {
        if (this.logger.isLoggable(level)) {
            if (throwable == null) {
                this.logger.logp(level, this.componentClassName, Logger.getCallerMethodName(), t.getMessage());
            } else {
                t.initCause(throwable);
                this.logger.logp(level, this.componentClassName, Logger.getCallerMethodName(), t.getMessage(), throwable);
            }
        }
        return t;
    }

    public <T extends Throwable> T logException(T t, boolean bl, Level level) {
        if (this.logger.isLoggable(level)) {
            if (bl && t.getCause() != null) {
                this.logger.logp(level, this.componentClassName, Logger.getCallerMethodName(), t.getMessage(), t.getCause());
            } else {
                this.logger.logp(level, this.componentClassName, Logger.getCallerMethodName(), t.getMessage());
            }
        }
        return t;
    }

    public <T extends Throwable> T logException(T t, Level level) {
        if (this.logger.isLoggable(level)) {
            if (t.getCause() == null) {
                this.logger.logp(level, this.componentClassName, Logger.getCallerMethodName(), t.getMessage());
            } else {
                this.logger.logp(level, this.componentClassName, Logger.getCallerMethodName(), t.getMessage(), t.getCause());
            }
        }
        return t;
    }

    private static String getCallerMethodName() {
        return Logger.getStackMethodName(5);
    }

    private static String getStackMethodName(int n) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        String string = stackTraceElementArray.length > n + 1 ? stackTraceElementArray[n].getMethodName() : "UNKNOWN METHOD";
        return string;
    }
}

