/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs12;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import sun.security.pkcs.ParsingException;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

class MacData {
    private String digestAlgorithmName;
    private AlgorithmParameters digestAlgorithmParams;
    private byte[] digest;
    private byte[] macSalt;
    private int iterations;
    private byte[] encoded = null;

    MacData(DerInputStream derInputStream) throws IOException, ParsingException {
        DerValue[] derValueArray = derInputStream.getSequence(2);
        DerInputStream derInputStream2 = new DerInputStream(derValueArray[0].toByteArray());
        DerValue[] derValueArray2 = derInputStream2.getSequence(2);
        AlgorithmId algorithmId = AlgorithmId.parse(derValueArray2[0]);
        this.digestAlgorithmName = algorithmId.getName();
        this.digestAlgorithmParams = algorithmId.getParameters();
        this.digest = derValueArray2[1].getOctetString();
        this.macSalt = derValueArray[1].getOctetString();
        this.iterations = derValueArray.length > 2 ? derValueArray[2].getInteger() : 1;
    }

    MacData(String string, byte[] byArray, byte[] byArray2, int n) throws NoSuchAlgorithmException {
        if (string == null) {
            throw new NullPointerException("the algName parameter must be non-null");
        }
        AlgorithmId algorithmId = AlgorithmId.get(string);
        this.digestAlgorithmName = algorithmId.getName();
        this.digestAlgorithmParams = algorithmId.getParameters();
        if (byArray == null) {
            throw new NullPointerException("the digest parameter must be non-null");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("the digest parameter must not be empty");
        }
        this.digest = (byte[])byArray.clone();
        this.macSalt = byArray2;
        this.iterations = n;
        this.encoded = null;
    }

    MacData(AlgorithmParameters algorithmParameters, byte[] byArray, byte[] byArray2, int n) throws NoSuchAlgorithmException {
        if (algorithmParameters == null) {
            throw new NullPointerException("the algParams parameter must be non-null");
        }
        AlgorithmId algorithmId = AlgorithmId.get(algorithmParameters);
        this.digestAlgorithmName = algorithmId.getName();
        this.digestAlgorithmParams = algorithmId.getParameters();
        if (byArray == null) {
            throw new NullPointerException("the digest parameter must be non-null");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("the digest parameter must not be empty");
        }
        this.digest = (byte[])byArray.clone();
        this.macSalt = byArray2;
        this.iterations = n;
        this.encoded = null;
    }

    String getDigestAlgName() {
        return this.digestAlgorithmName;
    }

    byte[] getSalt() {
        return this.macSalt;
    }

    int getIterations() {
        return this.iterations;
    }

    byte[] getDigest() {
        return this.digest;
    }

    public byte[] getEncoded() throws NoSuchAlgorithmException, IOException {
        if (this.encoded != null) {
            return (byte[])this.encoded.clone();
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        AlgorithmId algorithmId = AlgorithmId.get(this.digestAlgorithmName);
        algorithmId.encode(derOutputStream3);
        derOutputStream3.putOctetString(this.digest);
        derOutputStream2.write((byte)48, derOutputStream3);
        derOutputStream2.putOctetString(this.macSalt);
        derOutputStream2.putInteger(this.iterations);
        derOutputStream.write((byte)48, derOutputStream2);
        this.encoded = derOutputStream.toByteArray();
        return (byte[])this.encoded.clone();
    }
}

