/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.impl.load.ColumnInfo;
import org.apache.derby.impl.load.ControlInfo;
import org.apache.derby.impl.load.ImportAbstract;
import org.apache.derby.impl.load.ImportReadData;
import org.apache.derby.impl.load.LoadError;

public class Import
extends ImportAbstract {
    private static int _importCounter;
    private static Hashtable _importers;
    private String inputFileName;

    public Import(String string, String string2, String string3, String string4, int n, String string5, boolean bl, int n2) throws SQLException {
        try {
            this.inputFileName = string;
            this.noOfColumnsExpected = n;
            this.tableColumnTypesStr = string5;
            this.controlFileReader = new ControlInfo();
            this.controlFileReader.setControlProperties(string3, string2, string4);
            this.lobsInExtFile = bl;
            _importers.put(new Integer(n2), this);
            this.doImport();
        }
        catch (Exception exception) {
            throw this.importError(exception);
        }
    }

    private void doImport() throws Exception {
        if (this.inputFileName == null) {
            throw LoadError.dataFileNull();
        }
        this.doAllTheWork();
    }

    public static void importTable(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, short s, boolean bl) throws SQLException {
        Import.performImport(connection, string, null, null, string2, string3, string4, string5, string6, s, bl);
    }

    public static void importData(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, short s, boolean bl) throws SQLException {
        Import.performImport(connection, string, string3, string4, string2, string5, string6, string7, string8, s, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performImport(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, short s, boolean bl) throws SQLException {
        Integer n = new Integer(Import.bumpImportCounter());
        try {
            if (connection == null) {
                throw LoadError.connectionNull();
            }
            if (string4 == null) {
                throw LoadError.entityNameMissing();
            }
            ColumnInfo columnInfo = new ColumnInfo(connection, string, string4, string2, string3, "COLUMN");
            if (string7 != null && string7.equals("'")) {
                string7 = "''";
            }
            if (string6 != null && string6.equals("'")) {
                string6 = "''";
            }
            StringBuffer stringBuffer = new StringBuffer("new ");
            stringBuffer.append("org.apache.derby.impl.load.Import");
            stringBuffer.append("(");
            stringBuffer.append(string5 != null ? "'" + string5 + "'" : null);
            stringBuffer.append(",");
            stringBuffer.append(string6 != null ? "'" + string6 + "'" : null);
            stringBuffer.append(",");
            stringBuffer.append(string7 != null ? "'" + string7 + "'" : null);
            stringBuffer.append(",");
            stringBuffer.append(string8 != null ? "'" + string8 + "'" : null);
            stringBuffer.append(", ");
            stringBuffer.append(columnInfo.getExpectedNumberOfColumnsInFile());
            stringBuffer.append(", ");
            stringBuffer.append("'" + columnInfo.getExpectedVtiColumnTypesAsString() + "'");
            stringBuffer.append(", ");
            stringBuffer.append(bl);
            stringBuffer.append(", ");
            stringBuffer.append(n);
            stringBuffer.append(" )");
            String string9 = stringBuffer.toString();
            String string10 = string == null ? "\"" + string4 + "\"" : "\"" + string + "\"" + "." + "\"" + string4 + "\"";
            String string11 = s > 0 ? "replace" : "bulkInsert";
            String string12 = columnInfo.getColumnNamesWithCasts();
            String string13 = columnInfo.getInsertColumnNames();
            string13 = string13 != null ? "(" + string13 + ") " : "";
            String string14 = "INSERT INTO " + string10 + string13 + " --DERBY-PROPERTIES insertMode=" + string11 + "\n" + " SELECT " + string12 + " from " + string9 + " AS importvti";
            PreparedStatement preparedStatement = connection.prepareStatement(string14);
            Statement statement = connection.createStatement();
            String string15 = "LOCK TABLE " + string10 + " IN EXCLUSIVE MODE";
            statement.executeUpdate(string15);
            try {
                preparedStatement.executeUpdate();
            }
            catch (Throwable throwable) {
                throw Import.formatImportError((Import)_importers.get(n), string5, throwable);
            }
            statement.close();
            preparedStatement.close();
        }
        finally {
            _importers.remove(n);
        }
    }

    ImportReadData getImportReadData() throws Exception {
        return new ImportReadData(this.inputFileName, this.controlFileReader);
    }

    private static synchronized int bumpImportCounter() {
        return ++_importCounter;
    }

    private static SQLException formatImportError(Import import_, String string, Throwable throwable) {
        int n = -1;
        if (import_ != null) {
            n = import_.getCurrentLineNumber();
        }
        StandardException standardException = StandardException.newException("XIE0R.S", (Object)new Integer(n), (Object)string, (Object)throwable.getMessage());
        standardException.initCause(throwable);
        return PublicAPI.wrapStandardException(standardException);
    }

    static {
        _importers = new Hashtable();
    }
}

