/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.mac;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pen;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.View;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;

final class MacView
extends View {
    private static final long multiClickTime;
    private static final int multiClickMaxX;
    private static final int multiClickMaxY;

    protected MacView(Pen pen) {
        super(pen);
    }

    private static native void _initIDs();

    private static native long _getMultiClickTime_impl();

    private static native int _getMultiClickMaxX_impl();

    private static native int _getMultiClickMaxY_impl();

    static long getMultiClickTime_impl() {
        return multiClickTime;
    }

    static int getMultiClickMaxX_impl() {
        return multiClickMaxX;
    }

    static int getMultiClickMaxY_impl() {
        return multiClickMaxY;
    }

    protected native long _create(Map var1);

    protected native int _getX(long var1);

    protected native int _getY(long var1);

    protected native void _setParent(long var1, long var3);

    protected native boolean _close(long var1);

    protected native void _repaint(long var1);

    protected native boolean _begin(long var1, boolean var3);

    protected native void _end(long var1, boolean var3, boolean var4);

    protected native boolean _enterFullscreen(long var1, boolean var3, boolean var4, boolean var5);

    protected native void _exitFullscreen(long var1, boolean var3);

    protected native void _enableInputMethodEvents(long var1, boolean var3);

    protected void _uploadPixels(long l, Pixels pixels) {
        Buffer buffer = pixels.getPixels();
        if (buffer.isDirect()) {
            this._uploadPixelsDirect(l, buffer, pixels.getWidth(), pixels.getHeight());
        } else if (buffer.hasArray()) {
            if (pixels.getBytesPerComponent() == 1) {
                ByteBuffer byteBuffer = (ByteBuffer)buffer;
                this._uploadPixelsByteArray(l, byteBuffer.array(), byteBuffer.arrayOffset(), pixels.getWidth(), pixels.getHeight());
            } else {
                IntBuffer intBuffer = (IntBuffer)buffer;
                this._uploadPixelsIntArray(l, intBuffer.array(), intBuffer.arrayOffset(), pixels.getWidth(), pixels.getHeight());
            }
        } else {
            this._uploadPixelsDirect(l, pixels.asByteBuffer(), pixels.getWidth(), pixels.getHeight());
        }
    }

    native void _uploadPixelsDirect(long var1, Buffer var3, int var4, int var5);

    native void _uploadPixelsByteArray(long var1, byte[] var3, int var4, int var5, int var6);

    native void _uploadPixelsIntArray(long var1, int[] var3, int var4, int var5, int var6);

    protected long _getNativeView(long l) {
        return l;
    }

    protected native long _getNativeLayer(long var1);

    public long getNativeLayer() {
        return this._getNativeLayer(this.getNativeView());
    }

    protected native int _getNativeRemoteLayerId(long var1, String var3);

    public int getNativeRemoteLayerId(String string) {
        return this._getNativeRemoteLayerId(this.getNativeLayer(), string);
    }

    protected native void _hostRemoteLayerId(long var1, int var3);

    public void hostRemoteLayerId(int n) {
        this._hostRemoteLayerId(this.getNativeLayer(), n);
    }

    protected void notifyInputMethodMac(String string, int n, int n2, int n3) {
        byte[] byArray = new byte[]{(byte)n};
        int[] nArray = new int[]{0, n2};
        if (n == 4) {
            this.notifyInputMethod(string, null, nArray, byArray, n2, n3, 0);
        } else {
            this.notifyInputMethod(string, null, nArray, byArray, 0, n3, 0);
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Application.loadNativeLibrary();
                return null;
            }
        });
        MacView._initIDs();
        multiClickTime = MacView._getMultiClickTime_impl();
        multiClickMaxX = MacView._getMultiClickMaxX_impl();
        multiClickMaxY = MacView._getMultiClickMaxY_impl();
    }
}

