/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableDoubleProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RoundRectangle2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.sg.PGNode;
import com.sun.javafx.sg.PGRectangle;
import com.sun.javafx.sg.PGShape;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.value.WritableValue;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;

public class Rectangle
extends Shape {
    private final RoundRectangle2D shape = new RoundRectangle2D();
    private static final int NON_RECTILINEAR_TYPE_MASK = -72;
    private DoubleProperty x;
    private DoubleProperty y;
    private DoubleProperty width = new DoublePropertyBase(){

        @Override
        public void invalidated() {
            Rectangle.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
            Rectangle.this.impl_geomChanged();
        }

        @Override
        public Object getBean() {
            return Rectangle.this;
        }

        @Override
        public String getName() {
            return "width";
        }
    };
    private DoubleProperty height = new DoublePropertyBase(){

        @Override
        public void invalidated() {
            Rectangle.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
            Rectangle.this.impl_geomChanged();
        }

        @Override
        public Object getBean() {
            return Rectangle.this;
        }

        @Override
        public String getName() {
            return "height";
        }
    };
    private DoubleProperty arcWidth;
    private DoubleProperty arcHeight;

    public Rectangle() {
    }

    public Rectangle(double d, double d2) {
        this.setWidth(d);
        this.setHeight(d2);
    }

    public Rectangle(double d, double d2, Paint paint) {
        this.setWidth(d);
        this.setHeight(d2);
        this.setFill(paint);
    }

    public Rectangle(double d, double d2, double d3, double d4) {
        this(d3, d4);
        this.setX(d);
        this.setY(d2);
    }

    public final void setX(double d) {
        if (this.x != null || d != 0.0) {
            this.xProperty().set(d);
        }
    }

    public final double getX() {
        return this.x == null ? 0.0 : this.x.get();
    }

    public final DoubleProperty xProperty() {
        if (this.x == null) {
            this.x = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Rectangle.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Rectangle.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Rectangle.this;
                }

                @Override
                public String getName() {
                    return "x";
                }
            };
        }
        return this.x;
    }

    public final void setY(double d) {
        if (this.y != null || d != 0.0) {
            this.yProperty().set(d);
        }
    }

    public final double getY() {
        return this.y == null ? 0.0 : this.y.get();
    }

    public final DoubleProperty yProperty() {
        if (this.y == null) {
            this.y = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Rectangle.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Rectangle.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Rectangle.this;
                }

                @Override
                public String getName() {
                    return "y";
                }
            };
        }
        return this.y;
    }

    public final void setWidth(double d) {
        this.width.set(d);
    }

    public final double getWidth() {
        return this.width.get();
    }

    public final DoubleProperty widthProperty() {
        return this.width;
    }

    public final void setHeight(double d) {
        this.height.set(d);
    }

    public final double getHeight() {
        return this.height.get();
    }

    public final DoubleProperty heightProperty() {
        return this.height;
    }

    public final void setArcWidth(double d) {
        if (this.arcWidth != null || d != 0.0) {
            this.arcWidthProperty().set(d);
        }
    }

    public final double getArcWidth() {
        return this.arcWidth == null ? 0.0 : this.arcWidth.get();
    }

    public final DoubleProperty arcWidthProperty() {
        if (this.arcWidth == null) {
            this.arcWidth = new StyleableDoubleProperty(){

                @Override
                public void invalidated() {
                    Rectangle.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.ARC_WIDTH;
                }

                @Override
                public Object getBean() {
                    return Rectangle.this;
                }

                @Override
                public String getName() {
                    return "arcWidth";
                }
            };
        }
        return this.arcWidth;
    }

    public final void setArcHeight(double d) {
        if (this.arcHeight != null || d != 0.0) {
            this.arcHeightProperty().set(d);
        }
    }

    public final double getArcHeight() {
        return this.arcHeight == null ? 0.0 : this.arcHeight.get();
    }

    public final DoubleProperty arcHeightProperty() {
        if (this.arcHeight == null) {
            this.arcHeight = new StyleableDoubleProperty(){

                @Override
                public void invalidated() {
                    Rectangle.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.ARC_HEIGHT;
                }

                @Override
                public Object getBean() {
                    return Rectangle.this;
                }

                @Override
                public String getName() {
                    return "arcHeight";
                }
            };
        }
        return this.arcHeight;
    }

    @Override
    @Deprecated
    protected PGNode impl_createPGNode() {
        return Toolkit.getToolkit().createPGRectangle();
    }

    PGRectangle getPGRect() {
        return (PGRectangle)this.impl_getPGNode();
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return Rectangle.impl_CSS_STYLEABLES();
    }

    @Override
    @Deprecated
    protected PGShape.StrokeLineJoin toPGLineJoin(StrokeLineJoin strokeLineJoin) {
        if (this.getArcWidth() > 0.0 && this.getArcHeight() > 0.0) {
            return PGShape.StrokeLineJoin.BEVEL;
        }
        return super.toPGLineJoin(strokeLineJoin);
    }

    @Override
    @Deprecated
    public BaseBounds impl_computeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        double d;
        double d2;
        if (this.impl_mode == PGShape.Mode.EMPTY) {
            return baseBounds.makeEmpty();
        }
        if (this.getArcWidth() > 0.0 && this.getArcHeight() > 0.0 && (baseTransform.getType() & 0xFFFFFFB8) != 0) {
            return this.computeShapeBounds(baseBounds, baseTransform, this.impl_configShape());
        }
        if (this.impl_mode == PGShape.Mode.FILL || this.getStrokeType() == StrokeType.INSIDE) {
            d2 = 0.0;
            d = 0.0;
        } else {
            d = this.getStrokeWidth();
            if (this.getStrokeType() == StrokeType.CENTERED) {
                d /= 2.0;
            }
            d2 = 0.0;
        }
        return this.computeBounds(baseBounds, baseTransform, d, d2, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    @Deprecated
    public RoundRectangle2D impl_configShape() {
        if (this.getArcWidth() > 0.0 && this.getArcHeight() > 0.0) {
            this.shape.setRoundRect((float)this.getX(), (float)this.getY(), (float)this.getWidth(), (float)this.getHeight(), (float)this.getArcWidth(), (float)this.getArcHeight());
        } else {
            this.shape.setRoundRect((float)this.getX(), (float)this.getY(), (float)this.getWidth(), (float)this.getHeight(), 0.0f, 0.0f);
        }
        return this.shape;
    }

    @Override
    @Deprecated
    public void impl_updatePG() {
        super.impl_updatePG();
        if (this.impl_isDirty(DirtyBits.NODE_GEOMETRY)) {
            PGRectangle pGRectangle = this.getPGRect();
            pGRectangle.updateRectangle((float)this.getX(), (float)this.getY(), (float)this.getWidth(), (float)this.getHeight(), (float)this.getArcWidth(), (float)this.getArcHeight());
        }
    }

    private static class StyleableProperties {
        private static final StyleableProperty<Rectangle, Number> ARC_HEIGHT = new StyleableProperty<Rectangle, Number>("-fx-arc-height", (StyleConverter)SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(Rectangle rectangle) {
                return rectangle.arcHeight == null || !rectangle.arcHeight.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(Rectangle rectangle) {
                return rectangle.arcHeightProperty();
            }
        };
        private static final StyleableProperty<Rectangle, Number> ARC_WIDTH = new StyleableProperty<Rectangle, Number>("-fx-arc-width", (StyleConverter)SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(Rectangle rectangle) {
                return rectangle.arcWidth == null || !rectangle.arcWidth.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(Rectangle rectangle) {
                return rectangle.arcWidthProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Shape.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, ARC_HEIGHT, ARC_WIDTH);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

