/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util.exception;

import com.sun.xml.internal.ws.util.localization.Localizable;
import com.sun.xml.internal.ws.util.localization.LocalizableImpl;
import com.sun.xml.internal.ws.util.localization.LocalizableMessageFactory;
import com.sun.xml.internal.ws.util.localization.Localizer;
import com.sun.xml.internal.ws.util.localization.NullLocalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.xml.ws.WebServiceException;

public abstract class JAXWSExceptionBase
extends WebServiceException
implements Localizable {
    private static final long serialVersionUID = 1L;
    private transient Localizable msg;

    protected JAXWSExceptionBase(String string, Object ... objectArray) {
        super(JAXWSExceptionBase.findNestedException(objectArray));
        this.msg = new LocalizableImpl(string, JAXWSExceptionBase.fixNull(objectArray), this.getDefaultResourceBundleName());
    }

    protected JAXWSExceptionBase(String string) {
        this(new NullLocalizable(string));
    }

    private static Object[] fixNull(Object[] objectArray) {
        if (objectArray == null) {
            return new Object[0];
        }
        return objectArray;
    }

    protected JAXWSExceptionBase(Throwable throwable) {
        this(new NullLocalizable(throwable.toString()), throwable);
    }

    protected JAXWSExceptionBase(Localizable localizable) {
        this.msg = localizable;
    }

    protected JAXWSExceptionBase(Localizable localizable, Throwable throwable) {
        super(throwable);
        this.msg = localizable;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.msg.getResourceBundleName());
        objectOutputStream.writeObject(this.msg.getKey());
        Object[] objectArray = this.msg.getArguments();
        if (objectArray == null) {
            objectOutputStream.writeInt(-1);
            return;
        }
        objectOutputStream.writeInt(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null || objectArray[i] instanceof Serializable) {
                objectOutputStream.writeObject(objectArray[i]);
                continue;
            }
            objectOutputStream.writeObject(objectArray[i].toString());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object[] objectArray;
        objectInputStream.defaultReadObject();
        String string = (String)objectInputStream.readObject();
        String string2 = (String)objectInputStream.readObject();
        int n = objectInputStream.readInt();
        if (n == -1) {
            objectArray = null;
        } else {
            objectArray = new Object[n];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = objectInputStream.readObject();
            }
        }
        this.msg = new LocalizableMessageFactory(string).getMessage(string2, objectArray);
    }

    private static Throwable findNestedException(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        for (Object object : objectArray) {
            if (!(object instanceof Throwable)) continue;
            return (Throwable)object;
        }
        return null;
    }

    @Override
    public String getMessage() {
        Localizer localizer = new Localizer();
        return localizer.localize(this);
    }

    protected abstract String getDefaultResourceBundleName();

    @Override
    public final String getKey() {
        return this.msg.getKey();
    }

    @Override
    public final Object[] getArguments() {
        return this.msg.getArguments();
    }

    @Override
    public final String getResourceBundleName() {
        return this.msg.getResourceBundleName();
    }
}

