/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.io;

import com.sun.corba.se.impl.io.ObjectStreamField;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.portable.ValueOutputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public abstract class OutputStreamHook
extends ObjectOutputStream {
    private HookPutFields putFields = null;
    protected byte streamFormatVersion = 1;
    protected WriteObjectState writeObjectState = NOT_IN_WRITE_OBJECT;
    protected static final WriteObjectState NOT_IN_WRITE_OBJECT = new DefaultState();
    protected static final WriteObjectState IN_WRITE_OBJECT = new InWriteObjectState();
    protected static final WriteObjectState WROTE_DEFAULT_DATA = new WroteDefaultDataState();
    protected static final WriteObjectState WROTE_CUSTOM_DATA = new WroteCustomDataState();

    abstract void writeField(ObjectStreamField var1, Object var2) throws IOException;

    @Override
    public void defaultWriteObject() throws IOException {
        this.writeObjectState.defaultWriteObject(this);
        this.defaultWriteObjectDelegate();
    }

    public abstract void defaultWriteObjectDelegate();

    @Override
    public ObjectOutputStream.PutField putFields() throws IOException {
        this.putFields = new HookPutFields();
        return this.putFields;
    }

    public byte getStreamFormatVersion() {
        return this.streamFormatVersion;
    }

    abstract ObjectStreamField[] getFieldsNoCopy();

    @Override
    public void writeFields() throws IOException {
        this.writeObjectState.defaultWriteObject(this);
        this.putFields.write(this);
    }

    abstract OutputStream getOrbStream();

    protected abstract void beginOptionalCustomData();

    protected void setState(WriteObjectState writeObjectState) {
        this.writeObjectState = writeObjectState;
    }

    protected static class DefaultState
    extends WriteObjectState {
        protected DefaultState() {
        }

        @Override
        public void enterWriteObject(OutputStreamHook outputStreamHook) throws IOException {
            outputStreamHook.setState(IN_WRITE_OBJECT);
        }
    }

    private class HookPutFields
    extends ObjectOutputStream.PutField {
        private Map<String, Object> fields = new HashMap<String, Object>();

        private HookPutFields() {
        }

        @Override
        public void put(String string, boolean bl) {
            this.fields.put(string, new Boolean(bl));
        }

        @Override
        public void put(String string, char c) {
            this.fields.put(string, new Character(c));
        }

        @Override
        public void put(String string, byte by) {
            this.fields.put(string, new Byte(by));
        }

        @Override
        public void put(String string, short s) {
            this.fields.put(string, new Short(s));
        }

        @Override
        public void put(String string, int n) {
            this.fields.put(string, new Integer(n));
        }

        @Override
        public void put(String string, long l) {
            this.fields.put(string, new Long(l));
        }

        @Override
        public void put(String string, float f) {
            this.fields.put(string, new Float(f));
        }

        @Override
        public void put(String string, double d) {
            this.fields.put(string, new Double(d));
        }

        @Override
        public void put(String string, Object object) {
            this.fields.put(string, object);
        }

        @Override
        public void write(ObjectOutput objectOutput) throws IOException {
            OutputStreamHook outputStreamHook = (OutputStreamHook)objectOutput;
            ObjectStreamField[] objectStreamFieldArray = outputStreamHook.getFieldsNoCopy();
            for (int i = 0; i < objectStreamFieldArray.length; ++i) {
                Object object = this.fields.get(objectStreamFieldArray[i].getName());
                outputStreamHook.writeField(objectStreamFieldArray[i], object);
            }
        }
    }

    protected static class InWriteObjectState
    extends WriteObjectState {
        protected InWriteObjectState() {
        }

        @Override
        public void enterWriteObject(OutputStreamHook outputStreamHook) throws IOException {
            throw new IOException("Internal state failure: Entered writeObject twice");
        }

        @Override
        public void exitWriteObject(OutputStreamHook outputStreamHook) throws IOException {
            outputStreamHook.getOrbStream().write_boolean(false);
            if (outputStreamHook.getStreamFormatVersion() == 2) {
                outputStreamHook.getOrbStream().write_long(0);
            }
            outputStreamHook.setState(NOT_IN_WRITE_OBJECT);
        }

        @Override
        public void defaultWriteObject(OutputStreamHook outputStreamHook) throws IOException {
            outputStreamHook.getOrbStream().write_boolean(true);
            outputStreamHook.setState(WROTE_DEFAULT_DATA);
        }

        @Override
        public void writeData(OutputStreamHook outputStreamHook) throws IOException {
            outputStreamHook.getOrbStream().write_boolean(false);
            outputStreamHook.beginOptionalCustomData();
            outputStreamHook.setState(WROTE_CUSTOM_DATA);
        }
    }

    protected static class WriteObjectState {
        protected WriteObjectState() {
        }

        public void enterWriteObject(OutputStreamHook outputStreamHook) throws IOException {
        }

        public void exitWriteObject(OutputStreamHook outputStreamHook) throws IOException {
        }

        public void defaultWriteObject(OutputStreamHook outputStreamHook) throws IOException {
        }

        public void writeData(OutputStreamHook outputStreamHook) throws IOException {
        }
    }

    protected static class WroteCustomDataState
    extends InWriteObjectState {
        protected WroteCustomDataState() {
        }

        @Override
        public void exitWriteObject(OutputStreamHook outputStreamHook) throws IOException {
            if (outputStreamHook.getStreamFormatVersion() == 2) {
                ((ValueOutputStream)((Object)outputStreamHook.getOrbStream())).end_value();
            }
            outputStreamHook.setState(NOT_IN_WRITE_OBJECT);
        }

        @Override
        public void defaultWriteObject(OutputStreamHook outputStreamHook) throws IOException {
            throw new IOException("Cannot call defaultWriteObject/writeFields after writing custom data in RMI-IIOP");
        }

        @Override
        public void writeData(OutputStreamHook outputStreamHook) throws IOException {
        }
    }

    protected static class WroteDefaultDataState
    extends InWriteObjectState {
        protected WroteDefaultDataState() {
        }

        @Override
        public void exitWriteObject(OutputStreamHook outputStreamHook) throws IOException {
            if (outputStreamHook.getStreamFormatVersion() == 2) {
                outputStreamHook.getOrbStream().write_long(0);
            }
            outputStreamHook.setState(NOT_IN_WRITE_OBJECT);
        }

        @Override
        public void defaultWriteObject(OutputStreamHook outputStreamHook) throws IOException {
            throw new IOException("Called defaultWriteObject/writeFields twice");
        }

        @Override
        public void writeData(OutputStreamHook outputStreamHook) throws IOException {
            outputStreamHook.beginOptionalCustomData();
            outputStreamHook.setState(WROTE_CUSTOM_DATA);
        }
    }
}

