/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.algorithm;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.fastinfoset.algorithm.BuiltInEncodingAlgorithm;
import com.sun.xml.internal.fastinfoset.algorithm.LongEncodingAlgorithm;
import com.sun.xml.internal.org.jvnet.fastinfoset.EncodingAlgorithmException;
import java.nio.CharBuffer;
import java.util.ArrayList;

public class UUIDEncodingAlgorithm
extends LongEncodingAlgorithm {
    private long _msb;
    private long _lsb;

    @Override
    public final int getPrimtiveLengthFromOctetLength(int n) throws EncodingAlgorithmException {
        if (n % 16 != 0) {
            throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.lengthNotMultipleOfUUID", new Object[]{16}));
        }
        return n / 8;
    }

    @Override
    public final Object convertFromCharacters(char[] cArray, int n, int n2) {
        final CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
        final ArrayList arrayList = new ArrayList();
        this.matchWhiteSpaceDelimnatedWords(charBuffer, new BuiltInEncodingAlgorithm.WordListener(){

            @Override
            public void word(int n, int n2) {
                String string = charBuffer.subSequence(n, n2).toString();
                UUIDEncodingAlgorithm.this.fromUUIDString(string);
                arrayList.add(UUIDEncodingAlgorithm.this._msb);
                arrayList.add(UUIDEncodingAlgorithm.this._lsb);
            }
        });
        return this.generateArrayFromList(arrayList);
    }

    @Override
    public final void convertToCharacters(Object object, StringBuffer stringBuffer) {
        if (!(object instanceof long[])) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.dataNotLongArray"));
        }
        long[] lArray = (long[])object;
        int n = lArray.length - 2;
        for (int i = 0; i <= n; i += 2) {
            stringBuffer.append(this.toUUIDString(lArray[i], lArray[i + 1]));
            if (i == n) continue;
            stringBuffer.append(' ');
        }
    }

    final void fromUUIDString(String string) {
        String[] stringArray = string.split("-");
        if (stringArray.length != 5) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.invalidUUID", new Object[]{string}));
        }
        for (int i = 0; i < 5; ++i) {
            stringArray[i] = "0x" + stringArray[i];
        }
        this._msb = Long.parseLong(stringArray[0], 16);
        this._msb <<= 16;
        this._msb |= Long.parseLong(stringArray[1], 16);
        this._msb <<= 16;
        this._msb |= Long.parseLong(stringArray[2], 16);
        this._lsb = Long.parseLong(stringArray[3], 16);
        this._lsb <<= 48;
        this._lsb |= Long.parseLong(stringArray[4], 16);
    }

    final String toUUIDString(long l, long l2) {
        return this.digits(l >> 32, 8) + "-" + this.digits(l >> 16, 4) + "-" + this.digits(l, 4) + "-" + this.digits(l2 >> 48, 4) + "-" + this.digits(l2, 12);
    }

    final String digits(long l, int n) {
        long l2 = 1L << n * 4;
        return Long.toHexString(l2 | l & l2 - 1L).substring(1);
    }
}

