/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.socket;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SystemTrayUDPClient {
    private static Lock lock = new ReentrantLock();
    private DatagramSocket ds = null;
    private InetAddress inetAddress;
    private static int REV_SIZE = 256;
    private int port;

    public SystemTrayUDPClient(String serverIp, int port) {
        try {
            this.ds = new DatagramSocket();
            this.inetAddress = InetAddress.getByName(serverIp);
            this.port = port;
            this.ds.setSoTimeout(5000);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void displayMessage(String caption, String text) {
        try {
            String message = String.valueOf(caption) + "###" + text + "###INFO";
            this.send(message.getBytes("UTF-8"));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public final void send(byte[] bytes) throws IOException {
        DatagramPacket dp = new DatagramPacket(bytes, bytes.length, this.inetAddress, this.port);
        this.ds.send(dp);
    }

    public byte[] receive() throws IOException {
        byte[] buffer = new byte[REV_SIZE];
        DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
        this.ds.receive(dp);
        return buffer;
    }

    public String receiveString() throws IOException {
        byte[] buffer = new byte[REV_SIZE];
        DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
        this.ds.receive(dp);
        String info = new String(dp.getData(), 0, dp.getLength());
        return info;
    }

    public Map sendAndReceive(byte[] bytes) throws IOException {
        lock.lock();
        byte[] buffer = new byte[REV_SIZE];
        String info = "";
        try {
            DatagramPacket dp = new DatagramPacket(bytes, bytes.length, this.inetAddress, this.port);
            this.ds.send(dp);
            DatagramPacket recdp = new DatagramPacket(buffer, buffer.length);
            this.ds.receive(recdp);
            info = new String(recdp.getData(), 0, recdp.getLength());
        }
        finally {
            lock.unlock();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BUFFER_TYPE", buffer);
        map.put("STRIN_GTYPE", info.trim());
        return map;
    }

    public void close() {
        if (this.ds != null) {
            this.ds.close();
        }
    }

    public void setUpdatedImage(boolean isConnected) {
    }
}

