/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view;

import cn.com.voltronic.solar.console.SolarPowerTray;
import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.dao.PriceDao;
import cn.com.voltronic.solar.data.bean.Electrovalence;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.DateUtils;
import cn.com.voltronic.solar.view.LoginJDialog;
import cn.com.voltronic.solar.view.component.AAButton;
import cn.com.voltronic.solar.view.component.AADefaultTableModel;
import cn.com.voltronic.solar.view.component.AADialog;
import cn.com.voltronic.solar.view.component.AALabel;
import cn.com.voltronic.solar.view.component.DisplayMessage;
import cn.com.voltronic.solar.view.component.I18NListener;
import cn.com.voltronic.solar.view.component.MyCalendarPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class PriceJDialog
extends AADialog {
    private static final long serialVersionUID = -2110412845255459296L;
    private AAButton addButton;
    private AAButton cancelButton;
    private JTextField dateTextField;
    private AAButton deleteButton;
    private AALabel jLabel1;
    private AALabel jLabel2;
    private AALabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JTable priceTable;
    private JTextField priceTextField;
    private PriceDao priceDao = null;
    private final int MAX_SIZE = 12;
    private final int MAX_COLUMN = 3;
    private AADefaultTableModel tableModel = null;
    private List<Electrovalence> pricelist = new ArrayList<Electrovalence>();
    private String[] tableTitle = new String[]{"message.effectdate", "message.electrovalence", "message.trandate"};

    public PriceJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.priceDao = new PriceDao();
        this.initComponents();
        this.setTitle("message.electrovalenceSet");
        this.setSize(this.getWidth(), 422);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new AALabel();
        this.dateTextField = new JTextField();
        this.jLabel2 = new AALabel();
        this.jLabel3 = new AALabel();
        this.priceTextField = new JTextField();
        this.addButton = new AAButton();
        this.deleteButton = new AAButton();
        this.jPanel2 = new JPanel();
        this.cancelButton = new AAButton();
        this.priceTable = new JTable(){
            private static final long serialVersionUID = -2097364819095589911L;

            @Override
            public boolean isCellSelected(int row, int column) {
                if (row >= PriceJDialog.this.pricelist.size()) {
                    return false;
                }
                return super.isCellSelected(row, column);
            }
        };
        this.priceTable.getTableHeader().setReorderingAllowed(false);
        this.priceTable.getTableHeader().setForeground(Color.white);
        this.priceTable.setSelectionMode(0);
        this.tableModel = new AADefaultTableModel(new Object[12][3], this.tableTitle){
            private static final long serialVersionUID = -4444769250474742659L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.priceTable.setModel(this.tableModel);
        this.setTableValues();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.priceTable);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jLabel1.setText("message.effectdate[:]");
        this.dateTextField.setEditable(false);
        this.dateTextField.setBackground(I18NListener.bgColor);
        this.dateTextField.setText(DateUtils.getNowDate());
        this.dateTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MyCalendarPanel calendarPanel = new MyCalendarPanel(PriceJDialog.this.dateTextField);
                calendarPanel.setBounds(PriceJDialog.this.getX() + PriceJDialog.this.jLabel2.getX() + 30, PriceJDialog.this.getY() + PriceJDialog.this.jLabel2.getY() + 10, calendarPanel.getWidth(), calendarPanel.getHeight());
                calendarPanel.setVisible(true);
            }
        });
        this.jLabel2.setIcon(new ImageIcon(Constants.DATE));
        this.jLabel2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MyCalendarPanel calendarPanel = new MyCalendarPanel(PriceJDialog.this.dateTextField);
                calendarPanel.setBounds(PriceJDialog.this.getX() + PriceJDialog.this.jLabel2.getX() + 30, PriceJDialog.this.getY() + PriceJDialog.this.jLabel2.getY() + 10, calendarPanel.getWidth(), calendarPanel.getHeight());
                calendarPanel.setVisible(true);
            }
        });
        this.jLabel3.setText("message.electrovalence[:]");
        this.priceTextField.setText("0.0");
        this.priceTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (c == '.' && PriceJDialog.this.priceTextField.getText().toString().indexOf(46) != -1) {
                    e.consume();
                }
                if (Character.isDigit(c) || c == '.' || c == '\b' || c == '\u007f') {
                    return;
                }
                e.consume();
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isControlDown()) {
                    e.consume();
                }
            }
        });
        this.addButton.setText("message.add");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SolarPowerTray.isLogin) {
                    new LoginJDialog(new Frame(), true);
                    return;
                }
                PriceJDialog.this.addPrice();
            }
        });
        this.deleteButton.setText("message.del");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SolarPowerTray.isLogin) {
                    new LoginJDialog(new Frame(), true);
                    return;
                }
                PriceJDialog.this.deletePrice();
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.priceTextField).addComponent(this.dateTextField, -1, 111, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton))).addContainerGap(42, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.dateTextField, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.priceTextField, -2, -1, -2).addComponent(this.addButton).addComponent(this.deleteButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel1.add((Component)this.jPanel3, "Last");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.cancelButton.setText("message.close");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PriceJDialog.this.dispose();
            }
        });
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(241, Short.MAX_VALUE).addComponent(this.cancelButton).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
    }

    private void addPrice() {
        int message = DisplayMessage.showConfirmDialog("message.confirmAdd", "message.confirm");
        if (message == 1) {
            return;
        }
        String dateStr = this.dateTextField.getText().trim();
        String price = this.priceTextField.getText().trim();
        if (price == null || "".equals(price)) {
            this.priceTextField.requestFocus(true);
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat(GlobalVariables.globalConfig.getDateFormat());
        Date effectiveDate = new Date();
        double priceDouble = 0.0;
        try {
            effectiveDate = format.parse(dateStr);
            priceDouble = Double.parseDouble(price);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (priceDouble <= 0.0) {
            this.priceTextField.requestFocus(true);
            return;
        }
        if (!this.priceDao.isExist(effectiveDate)) {
            Date inputDate = new Date();
            Electrovalence data = new Electrovalence();
            data.setEffectdate(effectiveDate);
            data.setPrice(priceDouble);
            data.setTrandate(inputDate);
            boolean result = this.priceDao.addElectrovalence(data);
            if (result) {
                this.setTableValues();
            } else {
                DisplayMessage.showErrorDialog("message.addfailure");
            }
        } else {
            DisplayMessage.showErrorDialog("message.adderror");
        }
    }

    private void deletePrice() {
        int message = DisplayMessage.showConfirmDialog("message.confirmDelete", "message.confirm");
        if (message == 1) {
            return;
        }
        int index = this.priceTable.getSelectedRow();
        if (index == -1) {
            DisplayMessage.showErrorDialog("message.pleaseselect");
            return;
        }
        try {
            Object object = this.tableModel.getValueAt(index, 0);
            if (object == null) {
                DisplayMessage.showErrorDialog("message.pleaseselect");
                return;
            }
            String effectStr = this.tableModel.getValueAt(index, 0).toString().trim();
            String price = this.tableModel.getValueAt(index, 1).toString().trim();
            String tranStr = this.tableModel.getValueAt(index, 2).toString().trim();
            SimpleDateFormat format = new SimpleDateFormat(GlobalVariables.globalConfig.getDateFormat());
            Date effectdate = new Date();
            Date trandate = new Date();
            try {
                effectdate = format.parse(effectStr);
                trandate = format.parse(tranStr);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            Electrovalence electrovalence = new Electrovalence();
            electrovalence.setEffectdate(effectdate);
            electrovalence.setPrice(Double.parseDouble(price));
            electrovalence.setTrandate(trandate);
            boolean result = this.priceDao.removeElectrovalence(electrovalence);
            if (result) {
                this.setTableValues();
            } else {
                DisplayMessage.showErrorDialog("message.delfailure");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setTableValues() {
        this.pricelist = this.priceDao.queryElectrovalence();
        int size = this.pricelist.size();
        if (size < 12) {
            size = 12;
        }
        Object[][] obj = new Object[size][3];
        int i = 0;
        while (i < this.pricelist.size()) {
            obj[i][0] = DateUtils.getFormatDate(this.pricelist.get(i).getEffectdate());
            obj[i][1] = this.pricelist.get(i).getPrice();
            obj[i][2] = DateUtils.getFormatTimestamp(this.pricelist.get(i).getTrandate());
            ++i;
        }
        if (this.pricelist.size() < 12) {
            i = this.pricelist.size();
            while (i < 12) {
                int j = 0;
                while (j < 3) {
                    obj[i][j] = null;
                    ++j;
                }
                ++i;
            }
        }
        this.tableModel.setDataVector(obj, this.tableTitle);
    }
}

