/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.Mergeable;
import org.springframework.core.CollectionFactory;

public class ManagedMap
implements Map,
Mergeable,
BeanMetadataElement {
    private final Map targetMap;
    private Object source;
    private boolean mergeEnabled;

    public ManagedMap() {
        this(16);
    }

    public ManagedMap(int n) {
        this.targetMap = CollectionFactory.createLinkedMapIfPossible((int)n);
    }

    public ManagedMap(Map map) {
        this.targetMap = map;
    }

    public void setSource(Object object) {
        this.source = object;
    }

    public Object getSource() {
        return this.source;
    }

    public void setMergeEnabled(boolean bl) {
        this.mergeEnabled = bl;
    }

    public boolean isMergeEnabled() {
        return this.mergeEnabled;
    }

    public Object merge(Object object) {
        if (!this.mergeEnabled) {
            throw new IllegalStateException("Not allowed to merge when the 'mergeEnabled' property is set to 'false'");
        }
        if (object == null) {
            return this;
        }
        if (!(object instanceof Map)) {
            throw new IllegalArgumentException("Cannot merge with object of type [" + object.getClass() + "]");
        }
        ManagedMap managedMap = new ManagedMap();
        managedMap.putAll((Map)object);
        managedMap.putAll(this);
        return managedMap;
    }

    public int size() {
        return this.targetMap.size();
    }

    public boolean isEmpty() {
        return this.targetMap.isEmpty();
    }

    public boolean containsKey(Object object) {
        return this.targetMap.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.targetMap.containsValue(object);
    }

    public Object get(Object object) {
        return this.targetMap.get(object);
    }

    public Object put(Object object, Object object2) {
        return this.targetMap.put(object, object2);
    }

    public Object remove(Object object) {
        return this.targetMap.remove(object);
    }

    public void putAll(Map map) {
        this.targetMap.putAll(map);
    }

    public void clear() {
        this.targetMap.clear();
    }

    public Set keySet() {
        return this.targetMap.keySet();
    }

    public Collection values() {
        return this.targetMap.values();
    }

    public Set entrySet() {
        return this.targetMap.entrySet();
    }

    public int hashCode() {
        return ((Object)this.targetMap).hashCode();
    }

    public boolean equals(Object object) {
        return ((Object)this.targetMap).equals(object);
    }

    public String toString() {
        return this.targetMap.toString();
    }
}

