/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.support.MutableSortDefinition;
import org.springframework.beans.support.PropertyComparator;
import org.springframework.beans.support.SortDefinition;

public class PagedListHolder
implements Serializable {
    public static final int DEFAULT_PAGE_SIZE = 10;
    public static final int DEFAULT_MAX_LINKED_PAGES = 10;
    private List source;
    private Date refreshDate;
    private SortDefinition sort;
    private SortDefinition sortUsed;
    private int pageSize = 10;
    private int page = 0;
    private boolean newPageSet;
    private int maxLinkedPages = 10;

    public PagedListHolder() {
        this(new ArrayList(0));
    }

    public PagedListHolder(List list) {
        this(list, new MutableSortDefinition(true));
    }

    public PagedListHolder(List list, SortDefinition sortDefinition) {
        this.setSource(list);
        this.setSort(sortDefinition);
    }

    public void setSource(List list) {
        this.source = list;
        this.refreshDate = new Date();
        this.sortUsed = null;
    }

    public List getSource() {
        return this.source;
    }

    public Date getRefreshDate() {
        return this.refreshDate;
    }

    public void setSort(SortDefinition sortDefinition) {
        this.sort = sortDefinition;
    }

    public SortDefinition getSort() {
        return this.sort;
    }

    public void setPageSize(int n) {
        if (n != this.pageSize) {
            this.pageSize = n;
            if (!this.newPageSet) {
                this.page = 0;
            }
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPage(int n) {
        this.page = n;
        this.newPageSet = true;
    }

    public int getPage() {
        this.newPageSet = false;
        if (this.page >= this.getPageCount()) {
            this.page = this.getPageCount() - 1;
        }
        return this.page;
    }

    public void setMaxLinkedPages(int n) {
        this.maxLinkedPages = n;
    }

    public int getMaxLinkedPages() {
        return this.maxLinkedPages;
    }

    public int getPageCount() {
        float f = (float)this.getSource().size() / (float)this.getPageSize();
        return (int)(f > (float)((int)f) || (double)f == 0.0 ? f + 1.0f : f);
    }

    public boolean isFirstPage() {
        return this.getPage() == 0;
    }

    public boolean isLastPage() {
        return this.getPage() == this.getPageCount() - 1;
    }

    public void previousPage() {
        if (!this.isFirstPage()) {
            --this.page;
        }
    }

    public void nextPage() {
        if (!this.isLastPage()) {
            ++this.page;
        }
    }

    public int getNrOfElements() {
        return this.getSource().size();
    }

    public int getFirstElementOnPage() {
        return this.getPageSize() * this.getPage();
    }

    public int getLastElementOnPage() {
        int n = this.getPageSize() * (this.getPage() + 1);
        return (n > this.getSource().size() ? this.getSource().size() : n) - 1;
    }

    public List getPageList() {
        return this.getSource().subList(this.getFirstElementOnPage(), this.getLastElementOnPage() + 1);
    }

    public int getFirstLinkedPage() {
        return Math.max(0, this.getPage() - this.getMaxLinkedPages() / 2);
    }

    public int getLastLinkedPage() {
        return Math.min(this.getFirstLinkedPage() + this.getMaxLinkedPages() - 1, this.getPageCount() - 1);
    }

    public void resort() {
        SortDefinition sortDefinition = this.getSort();
        if (sortDefinition != null && !sortDefinition.equals(this.sortUsed)) {
            this.sortUsed = this.copySortDefinition(sortDefinition);
            this.doSort(this.getSource(), sortDefinition);
            this.setPage(0);
        }
    }

    protected SortDefinition copySortDefinition(SortDefinition sortDefinition) {
        return new MutableSortDefinition(sortDefinition);
    }

    protected void doSort(List list, SortDefinition sortDefinition) {
        PropertyComparator.sort(list, sortDefinition);
    }
}

