/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.springframework.util.PropertiesPersister;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class DefaultPropertiesPersister
implements PropertiesPersister {
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$io$OutputStream;
    static /* synthetic */ Class class$java$lang$String;

    public void load(Properties properties, InputStream inputStream) throws IOException {
        properties.load(inputStream);
    }

    public void load(Properties properties, Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            char c;
            if ((string = StringUtils.trimLeadingWhitespace(string)).length() <= 0 || (c = string.charAt(0)) == '#' || c == '!') continue;
            while (this.endsWithContinuationMarker(string)) {
                String string2 = bufferedReader.readLine();
                string = string.substring(0, string.length() - 1);
                if (string2 == null) continue;
                string = string + StringUtils.trimLeadingWhitespace(string2);
            }
            int n = string.indexOf("=");
            if (n == -1) {
                n = string.indexOf(":");
            }
            String string3 = n != -1 ? string.substring(0, n) : string;
            String string4 = n != -1 ? string.substring(n + 1) : "";
            string3 = StringUtils.trimTrailingWhitespace(string3);
            string4 = StringUtils.trimLeadingWhitespace(string4);
            properties.put(this.unescape(string3), this.unescape(string4));
        }
        return;
    }

    protected boolean endsWithContinuationMarker(String string) {
        boolean bl = true;
        for (int i = string.length() - 1; i >= 0 && string.charAt(i) == '\\'; --i) {
            bl = !bl;
        }
        return !bl;
    }

    protected String unescape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            int n2;
            if ((n2 = string.charAt(n++)) == 92) {
                if ((n2 = string.charAt(n++)) == 116) {
                    n2 = 9;
                } else if (n2 == 114) {
                    n2 = 13;
                } else if (n2 == 110) {
                    n2 = 10;
                } else if (n2 == 102) {
                    n2 = 12;
                }
            }
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    public void store(Properties properties, OutputStream outputStream, String string) throws IOException {
        properties.store(outputStream, string);
    }

    public void store(Properties properties, Writer writer, String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        if (string != null) {
            bufferedWriter.write("#" + string);
            bufferedWriter.newLine();
        }
        bufferedWriter.write("#" + new Date());
        bufferedWriter.newLine();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            bufferedWriter.write(this.escape(string2, true) + "=" + this.escape(string3, false));
            bufferedWriter.newLine();
        }
        bufferedWriter.flush();
    }

    protected String escape(String string, boolean bl) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    if (i == 0 || bl) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block8;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block8;
                }
                default: {
                    if ("=: \t\r\n\f#!".indexOf(c) != -1) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public void loadFromXml(Properties properties, InputStream inputStream) throws IOException {
        try {
            Method method = properties.getClass().getMethod("loadFromXML", class$java$io$InputStream == null ? (class$java$io$InputStream = DefaultPropertiesPersister.class$("java.io.InputStream")) : class$java$io$InputStream);
            method.invoke((Object)properties, inputStream);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException("Cannot load properties XML file - not running on JDK 1.5+: " + noSuchMethodException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof IOException) {
                throw (IOException)invocationTargetException.getTargetException();
            }
            ReflectionUtils.handleInvocationTargetException(invocationTargetException);
        }
        catch (Exception exception) {
            ReflectionUtils.handleReflectionException(exception);
        }
    }

    public void storeToXml(Properties properties, OutputStream outputStream, String string) throws IOException {
        try {
            Method method = properties.getClass().getMethod("storeToXML", class$java$io$OutputStream == null ? (class$java$io$OutputStream = DefaultPropertiesPersister.class$("java.io.OutputStream")) : class$java$io$OutputStream, class$java$lang$String == null ? (class$java$lang$String = DefaultPropertiesPersister.class$("java.lang.String")) : class$java$lang$String);
            method.invoke((Object)properties, outputStream, string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException("Cannot store properties XML file - not running on JDK 1.5+: " + noSuchMethodException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof IOException) {
                throw (IOException)invocationTargetException.getTargetException();
            }
            ReflectionUtils.handleInvocationTargetException(invocationTargetException);
        }
        catch (Exception exception) {
            ReflectionUtils.handleReflectionException(exception);
        }
    }

    public void storeToXml(Properties properties, OutputStream outputStream, String string, String string2) throws IOException {
        try {
            Method method = properties.getClass().getMethod("storeToXML", class$java$io$OutputStream == null ? (class$java$io$OutputStream = DefaultPropertiesPersister.class$("java.io.OutputStream")) : class$java$io$OutputStream, class$java$lang$String == null ? (class$java$lang$String = DefaultPropertiesPersister.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = DefaultPropertiesPersister.class$("java.lang.String")) : class$java$lang$String);
            method.invoke((Object)properties, outputStream, string, string2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException("Cannot store properties XML file - not running on JDK 1.5+: " + noSuchMethodException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof IOException) {
                throw (IOException)invocationTargetException.getTargetException();
            }
            ReflectionUtils.handleInvocationTargetException(invocationTargetException);
        }
        catch (Exception exception) {
            ReflectionUtils.handleReflectionException(exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

