/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view.panel;

import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.data.bean.ColumnChartItem;
import cn.com.voltronic.solar.data.bean.EnergyData;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.view.component.AATabbedPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.TextAnchor;

public class PowerChartsPanel
extends AATabbedPane {
    private static final long serialVersionUID = 618814205935656976L;
    private CategoryAxis hourCategoryAxis = null;
    private CategoryAxis dayCategoryAxis = null;
    private CategoryAxis monthCategoryAxis = null;
    private CategoryAxis yearCategoryAxis = null;
    private DefaultCategoryDataset hourdataset = new DefaultCategoryDataset();
    private DefaultCategoryDataset daydataset = new DefaultCategoryDataset();
    private DefaultCategoryDataset monthdataset = new DefaultCategoryDataset();
    private DefaultCategoryDataset yeardataset = new DefaultCategoryDataset();
    private CategoryPlot hourPlot = null;
    private CategoryPlot dayPlot = null;
    private CategoryPlot monthPlot = null;
    private CategoryPlot yearPlot = null;
    private ValueAxis hourRangeAxis = null;
    private ValueAxis dayRangeAxis = null;
    private ValueAxis monthRangeAxis = null;
    private ValueAxis yearRangeAxis = null;
    private double oldMaxH = 100.0;
    private double oldMaxD = 100.0;
    private double oldMaxM = 100.0;
    private double oldMaxY = 100.0;
    private JPanel hourPanel = null;
    private JPanel dayPanel = null;
    private JPanel monthPanel = null;
    private JPanel yearPanel = null;

    public PowerChartsPanel() {
        this.initComponents();
        this.setTabPlacement(4);
    }

    public void refreshWork(EnergyData data) {
        try {
            double maxY;
            double maxM;
            double maxD;
            double maxH;
            AbstractProcessor processer = GlobalProcessors.getCurrentProcessor();
            if (processer != null) {
                String prodid = processer.getProtocol().getProtocolID();
                if (prodid.equals("P18") || prodid.equals("P1834K") || prodid.equals("P1812K") || prodid.equals("P1730K")) {
                    if (this.getTabCount() == 4) {
                        this.removeAll();
                        this.addTab("message.perDay", this.dayPanel);
                        this.addTab("message.perMonth", this.monthPanel);
                        this.addTab("message.perYear", this.yearPanel);
                    }
                } else if (this.getTabCount() == 3) {
                    this.removeAll();
                    this.addTab("message.perHour", this.hourPanel);
                    this.addTab("message.perDay", this.dayPanel);
                    this.addTab("message.perMonth", this.monthPanel);
                    this.addTab("message.perYear", this.yearPanel);
                }
            }
            if (this.hourPlot != null && this.hourCategoryAxis != null) {
                this.hourPlot.setDataset((CategoryDataset)this.createHourDataset(data));
                this.hourCategoryAxis.setLabel(data.getHorizontalTitleH());
            }
            if (this.dayPlot != null && this.dayCategoryAxis != null) {
                this.dayPlot.setDataset((CategoryDataset)this.createDayDataset(data));
                this.dayCategoryAxis.setLabel(data.getHorizontalTitleD());
            }
            if (this.monthPlot != null && this.monthCategoryAxis != null) {
                this.monthPlot.setDataset((CategoryDataset)this.createMonthDataset(data));
                this.monthCategoryAxis.setLabel(data.getHorizontalTitleM());
            }
            if (this.yearPlot != null && this.yearCategoryAxis != null) {
                this.yearPlot.setDataset((CategoryDataset)this.createYearDataset(data));
                this.yearCategoryAxis.setLabel(data.getHorizontalTitleY());
            }
            if (this.hourRangeAxis != null && this.oldMaxH != (maxH = data.getMaxH())) {
                this.hourRangeAxis.setRange(0.0, maxH);
                this.oldMaxH = maxH;
            }
            if (this.dayRangeAxis != null && this.oldMaxD != (maxD = data.getMaxD())) {
                this.dayRangeAxis.setRange(0.0, data.getMaxD());
                this.oldMaxD = maxD;
            }
            if (this.monthRangeAxis != null && this.oldMaxM != (maxM = data.getMaxM())) {
                this.monthRangeAxis.setRange(0.0, data.getMaxM());
                this.oldMaxM = maxM;
            }
            if (this.yearRangeAxis != null && this.oldMaxY != (maxY = data.getMaxY())) {
                this.yearRangeAxis.setRange(0.0, data.getMaxY());
                this.oldMaxY = maxY;
            }
        }
        catch (Exception ex) {
            System.out.println("chart error");
            ex.printStackTrace();
        }
    }

    private DefaultCategoryDataset createHourDataset(EnergyData data) throws Exception {
        if (this.hourdataset != null) {
            this.hourdataset.clear();
        } else {
            this.hourdataset = new DefaultCategoryDataset();
        }
        List<ColumnChartItem> hourList = data.getEnergyHours();
        int i = 0;
        while (i < hourList.size()) {
            this.hourdataset.addValue(VolUtil.parseDouble(hourList.get(i).getVerticalValue()), (Comparable)((Object)hourList.get(i).getShowName()), (Comparable)((Object)hourList.get(i).getHorizontalValue()));
            ++i;
        }
        return this.hourdataset;
    }

    private DefaultCategoryDataset createDayDataset(EnergyData data) throws Exception {
        if (this.daydataset != null) {
            this.daydataset.clear();
        } else {
            this.daydataset = new DefaultCategoryDataset();
        }
        List<ColumnChartItem> dayList = data.getEnergyDays();
        int i = 0;
        while (i < dayList.size()) {
            this.daydataset.addValue(VolUtil.parseDouble(dayList.get(i).getVerticalValue()), (Comparable)((Object)dayList.get(i).getShowName()), (Comparable)((Object)dayList.get(i).getHorizontalValue()));
            ++i;
        }
        return this.daydataset;
    }

    private DefaultCategoryDataset createMonthDataset(EnergyData data) throws Exception {
        if (this.monthdataset != null) {
            this.monthdataset.clear();
        } else {
            this.monthdataset = new DefaultCategoryDataset();
        }
        List<ColumnChartItem> monthList = data.getEnergyMonths();
        int i = 0;
        while (i < monthList.size()) {
            this.monthdataset.addValue(VolUtil.parseDouble(monthList.get(i).getVerticalValue()), (Comparable)((Object)monthList.get(i).getShowName()), (Comparable)((Object)monthList.get(i).getHorizontalValue()));
            ++i;
        }
        return this.monthdataset;
    }

    private DefaultCategoryDataset createYearDataset(EnergyData data) throws Exception {
        if (this.yeardataset != null) {
            this.yeardataset.clear();
        } else {
            this.yeardataset = new DefaultCategoryDataset();
        }
        List<ColumnChartItem> yearList = data.getEnergyYears();
        int i = 0;
        while (i < yearList.size()) {
            this.yeardataset.addValue(VolUtil.parseDouble(yearList.get(i).getVerticalValue()), (Comparable)((Object)yearList.get(i).getShowName()), (Comparable)((Object)yearList.get(i).getHorizontalValue()));
            ++i;
        }
        return this.yeardataset;
    }

    private ChartPanel createHourChart(String title, String unit) {
        JFreeChart hourChart = ChartFactory.createBarChart((String)"", (String)title, (String)unit, (CategoryDataset)this.hourdataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        hourChart.setBackgroundPaint((Paint)Constants.BG_COLOR);
        this.hourPlot = hourChart.getCategoryPlot();
        this.hourPlot.setBackgroundPaint((Paint)Constants.BG_COLOR);
        this.hourPlot.setDomainGridlinePaint((Paint)Constants.BG_COLOR);
        this.hourPlot.setDomainGridlinesVisible(true);
        this.hourPlot.setRangeGridlinePaint((Paint)Color.white);
        this.hourCategoryAxis = this.hourPlot.getDomainAxis();
        this.hourCategoryAxis.setLabelPaint((Paint)Color.white);
        this.hourCategoryAxis.setTickLabelPaint((Paint)Color.white);
        this.hourRangeAxis = this.hourPlot.getRangeAxis();
        this.hourRangeAxis.setUpperMargin(0.1);
        this.hourRangeAxis.setLabelPaint((Paint)Color.white);
        this.hourRangeAxis.setTickLabelPaint((Paint)Color.white);
        this.hourRangeAxis.setRange(0.0, this.oldMaxH);
        BarRenderer barRenderer = (BarRenderer)this.hourPlot.getRenderer();
        barRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        barRenderer.setBaseItemLabelsVisible(true);
        barRenderer.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BASELINE_CENTER));
        barRenderer.setItemLabelsVisible(true);
        barRenderer.setPaint((Paint)new Color(232, 107, 30));
        barRenderer.setMinimumBarLength(0.02);
        barRenderer.setMaxBarWidth(0.07);
        barRenderer.setItemLabelPaint((Paint)Color.white);
        ChartPanel chartPanel = new ChartPanel(hourChart);
        chartPanel.setPreferredSize(new Dimension(620, 312));
        return chartPanel;
    }

    private ChartPanel createDayChart(String title, String unit) {
        JFreeChart dayChart = ChartFactory.createBarChart((String)"", (String)title, (String)unit, (CategoryDataset)this.daydataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        dayChart.setBackgroundPaint((Paint)Constants.BG_COLOR);
        this.dayPlot = dayChart.getCategoryPlot();
        this.dayPlot.setBackgroundPaint((Paint)Constants.BG_COLOR);
        this.dayPlot.setDomainGridlinePaint((Paint)Constants.BG_COLOR);
        this.dayPlot.setDomainGridlinesVisible(true);
        this.dayPlot.setRangeGridlinePaint((Paint)Color.white);
        this.dayCategoryAxis = this.dayPlot.getDomainAxis();
        this.dayCategoryAxis.setLabelPaint((Paint)Color.white);
        this.dayCategoryAxis.setTickLabelPaint((Paint)Color.white);
        this.dayCategoryAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
        this.dayRangeAxis = this.dayPlot.getRangeAxis();
        this.dayRangeAxis.setUpperMargin(0.1);
        this.dayRangeAxis.setLabelPaint((Paint)Color.white);
        this.dayRangeAxis.setTickLabelPaint((Paint)Color.white);
        this.dayRangeAxis.setRange(0.0, this.oldMaxD);
        BarRenderer barRenderer = (BarRenderer)this.dayPlot.getRenderer();
        barRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        barRenderer.setBaseItemLabelsVisible(true);
        barRenderer.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BASELINE_CENTER));
        barRenderer.setItemLabelsVisible(true);
        barRenderer.setPaint((Paint)new Color(232, 107, 30));
        barRenderer.setMinimumBarLength(0.02);
        barRenderer.setMaxBarWidth(0.07);
        barRenderer.setItemLabelPaint((Paint)Color.white);
        ChartPanel chartPanel = new ChartPanel(dayChart);
        chartPanel.setPreferredSize(new Dimension(620, 312));
        return chartPanel;
    }

    private ChartPanel createMonthChart(String title, String unit) {
        JFreeChart monthChart = ChartFactory.createBarChart((String)"", (String)title, (String)unit, (CategoryDataset)this.monthdataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        monthChart.setBackgroundPaint((Paint)Constants.BG_COLOR);
        this.monthPlot = monthChart.getCategoryPlot();
        this.monthPlot.setBackgroundPaint((Paint)Constants.BG_COLOR);
        this.monthPlot.setDomainGridlinePaint((Paint)Constants.BG_COLOR);
        this.monthPlot.setDomainGridlinesVisible(true);
        this.monthPlot.setRangeGridlinePaint((Paint)Color.white);
        this.monthCategoryAxis = this.monthPlot.getDomainAxis();
        this.monthCategoryAxis.setLabelPaint((Paint)Color.white);
        this.monthCategoryAxis.setTickLabelPaint((Paint)Color.white);
        this.monthRangeAxis = this.monthPlot.getRangeAxis();
        this.monthRangeAxis.setUpperMargin(0.1);
        this.monthRangeAxis.setLabelPaint((Paint)Color.white);
        this.monthRangeAxis.setTickLabelPaint((Paint)Color.white);
        this.monthRangeAxis.setRange(0.0, this.oldMaxM);
        BarRenderer barRenderer = (BarRenderer)this.monthPlot.getRenderer();
        barRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        barRenderer.setBaseItemLabelsVisible(true);
        barRenderer.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BASELINE_CENTER));
        barRenderer.setItemLabelsVisible(true);
        barRenderer.setPaint((Paint)new Color(232, 107, 30));
        barRenderer.setMinimumBarLength(0.02);
        barRenderer.setMaxBarWidth(0.07);
        barRenderer.setItemLabelPaint((Paint)Color.white);
        ChartPanel chartPanel = new ChartPanel(monthChart);
        chartPanel.setPreferredSize(new Dimension(620, 312));
        return chartPanel;
    }

    private ChartPanel createYearChart(String title, String unit) {
        JFreeChart yearChart = ChartFactory.createBarChart((String)"", (String)title, (String)unit, (CategoryDataset)this.yeardataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        yearChart.setBackgroundPaint((Paint)Constants.BG_COLOR);
        this.yearPlot = yearChart.getCategoryPlot();
        this.yearPlot.setBackgroundPaint((Paint)Constants.BG_COLOR);
        this.yearPlot.setDomainGridlinePaint((Paint)Constants.BG_COLOR);
        this.yearPlot.setDomainGridlinesVisible(true);
        this.yearPlot.setRangeGridlinePaint((Paint)Color.white);
        this.yearCategoryAxis = this.yearPlot.getDomainAxis();
        this.yearCategoryAxis.setLabelPaint((Paint)Color.white);
        this.yearCategoryAxis.setTickLabelPaint((Paint)Color.white);
        this.yearRangeAxis = this.yearPlot.getRangeAxis();
        this.yearRangeAxis.setUpperMargin(0.1);
        this.yearRangeAxis.setLabelPaint((Paint)Color.white);
        this.yearRangeAxis.setTickLabelPaint((Paint)Color.white);
        this.yearRangeAxis.setRange(0.0, this.oldMaxY);
        BarRenderer barRenderer = (BarRenderer)this.yearPlot.getRenderer();
        barRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        barRenderer.setBaseItemLabelsVisible(true);
        barRenderer.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BASELINE_CENTER));
        barRenderer.setItemLabelsVisible(true);
        barRenderer.setPaint((Paint)new Color(232, 107, 30));
        barRenderer.setMinimumBarLength(0.02);
        barRenderer.setMaxBarWidth(0.07);
        barRenderer.setItemLabelPaint((Paint)Color.white);
        ChartPanel chartPanel = new ChartPanel(yearChart);
        chartPanel.setPreferredSize(new Dimension(620, 312));
        return chartPanel;
    }

    public void initComponents() {
        this.hourPanel = new JPanel(new BorderLayout());
        this.dayPanel = new JPanel(new BorderLayout());
        this.monthPanel = new JPanel(new BorderLayout());
        this.yearPanel = new JPanel(new BorderLayout());
        this.hourPanel.add((Component)this.createHourChart("", "kWh"));
        this.dayPanel.add((Component)this.createDayChart("", "kWh"));
        this.monthPanel.add((Component)this.createMonthChart("", "kWh"));
        this.yearPanel.add((Component)this.createYearChart("", "kWh"));
        this.addTab("message.perHour", this.hourPanel);
        this.addTab("message.perDay", this.dayPanel);
        this.addTab("message.perMonth", this.monthPanel);
        this.addTab("message.perYear", this.yearPanel);
    }
}

