/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.tools;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.security.auth.kerberos.KeyTab;
import sun.security.krb5.Config;
import sun.security.krb5.KrbAsReqBuilder;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.ccache.Credentials;
import sun.security.krb5.internal.ccache.CredentialsCache;
import sun.security.krb5.internal.tools.KinitOptions;
import sun.security.util.Password;

public class Kinit {
    private KinitOptions options;
    private static final boolean DEBUG = Krb5.DEBUG;

    public static void main(String[] stringArray) {
        try {
            Kinit kinit = new Kinit(stringArray);
        }
        catch (Exception exception) {
            String string = null;
            string = exception instanceof KrbException ? ((KrbException)exception).krbErrorMessage() + " " + ((KrbException)exception).returnCodeMessage() : exception.getMessage();
            if (string != null) {
                System.err.println("Exception: " + string);
            } else {
                System.out.println("Exception: " + exception);
            }
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    private Kinit(String[] stringArray) throws IOException, RealmException, KrbException {
        Object object;
        KrbAsReqBuilder krbAsReqBuilder;
        this.options = stringArray == null || stringArray.length == 0 ? new KinitOptions() : new KinitOptions(stringArray);
        String string = null;
        PrincipalName principalName = this.options.getPrincipal();
        if (principalName != null) {
            string = principalName.toString();
        }
        if (DEBUG) {
            System.out.println("Principal is " + principalName);
        }
        char[] cArray = this.options.password;
        boolean bl = this.options.useKeytabFile();
        if (!bl) {
            if (string == null) {
                throw new IllegalArgumentException(" Can not obtain principal name");
            }
            if (cArray == null) {
                System.out.print("Password for " + string + ":");
                System.out.flush();
                cArray = Password.readPassword(System.in);
                if (DEBUG) {
                    System.out.println(">>> Kinit console input " + new String(cArray));
                }
            }
            krbAsReqBuilder = new KrbAsReqBuilder(principalName, cArray);
        } else {
            if (DEBUG) {
                System.out.println(">>> Kinit using keytab");
            }
            if (string == null) {
                throw new IllegalArgumentException("Principal name must be specified.");
            }
            object = this.options.keytabFileName();
            if (object != null && DEBUG) {
                System.out.println(">>> Kinit keytab file name: " + (String)object);
            }
            krbAsReqBuilder = new KrbAsReqBuilder(principalName, object == null ? KeyTab.getInstance() : KeyTab.getInstance(new File((String)object)));
        }
        object = new KDCOptions();
        Kinit.setOptions(1, this.options.forwardable, (KDCOptions)object);
        Kinit.setOptions(3, this.options.proxiable, (KDCOptions)object);
        krbAsReqBuilder.setOptions((KDCOptions)object);
        String string2 = this.options.getKDCRealm();
        if (string2 == null) {
            string2 = Config.getInstance().getDefaultRealm();
        }
        if (DEBUG) {
            System.out.println(">>> Kinit realm name is " + string2);
        }
        PrincipalName principalName2 = new PrincipalName("krbtgt/" + string2, 2);
        principalName2.setRealm(string2);
        krbAsReqBuilder.setTarget(principalName2);
        if (DEBUG) {
            System.out.println(">>> Creating KrbAsReq");
        }
        if (this.options.getAddressOption()) {
            krbAsReqBuilder.setAddresses(HostAddresses.getLocalAddresses());
        }
        krbAsReqBuilder.action();
        Credentials credentials = krbAsReqBuilder.getCCreds();
        krbAsReqBuilder.destroy();
        CredentialsCache credentialsCache = CredentialsCache.create(principalName, this.options.cachename);
        if (credentialsCache == null) {
            throw new IOException("Unable to create the cache file " + this.options.cachename);
        }
        credentialsCache.update(credentials);
        credentialsCache.save();
        if (this.options.password == null) {
            System.out.println("New ticket is stored in cache file " + this.options.cachename);
        } else {
            Arrays.fill(this.options.password, '0');
        }
        if (cArray != null) {
            Arrays.fill(cArray, '0');
        }
        this.options = null;
    }

    private static void setOptions(int n, int n2, KDCOptions kDCOptions) {
        switch (n2) {
            case 0: {
                break;
            }
            case -1: {
                kDCOptions.set(n, false);
                break;
            }
            case 1: {
                kDCOptions.set(n, true);
            }
        }
    }
}

