/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.smart;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.smart.SmartLookAndFeel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class SmartBorders
extends BaseBorders {
    private static Border buttonBorder = null;
    private static Border toggleButtonBorder = null;
    private static Border rolloverToolButtonBorder = null;
    private static Border internalFrameBorder = null;
    private static Border paletteBorder = null;

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        if (toggleButtonBorder == null) {
            toggleButtonBorder = new ToggleButtonBorder();
        }
        return toggleButtonBorder;
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static Border getPaletteBorder() {
        if (paletteBorder == null) {
            paletteBorder = new PaletteBorder();
        }
        return paletteBorder;
    }

    public static class PaletteBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (JTattooUtilities.isFrameActive((JComponent)component)) {
                graphics.setColor(AbstractLookAndFeel.getFrameColor());
            } else {
                graphics.setColor(ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 40.0));
            }
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color;
            ColorUIResource colorUIResource;
            Graphics2D graphics2D = (Graphics2D)graphics;
            boolean bl = this.isActive(component);
            boolean bl2 = this.isResizable(component);
            int n5 = this.getTitleHeight(component);
            ColorUIResource colorUIResource2 = SmartLookAndFeel.getWindowInactiveBorderColor();
            ColorUIResource colorUIResource3 = SmartLookAndFeel.getWindowInactiveTitleColorLight();
            if (bl) {
                colorUIResource3 = SmartLookAndFeel.getWindowTitleColorLight();
                colorUIResource2 = SmartLookAndFeel.getWindowBorderColor();
            }
            if (!bl2) {
                Insets insets = this.getBorderInsets(component);
                graphics.setColor(colorUIResource2);
                graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                if (bl) {
                    graphics.setColor(SmartLookAndFeel.getWindowTitleColorDark());
                } else {
                    graphics.setColor(SmartLookAndFeel.getWindowInactiveTitleColorDark());
                }
                for (int i = 1; i < insets.left; ++i) {
                    graphics.drawRect(i, i, n3 - 2 * i - 1, n4 - 2 * i - 1);
                }
                graphics.setColor(colorUIResource2);
                graphics.drawLine(insets.left - 1, n2 + n5 + insets.top, insets.left - 1, n2 + n4 - insets.bottom);
                graphics.drawLine(n3 - insets.right, n2 + n5 + insets.top, n3 - insets.right, n2 + n4 - insets.bottom);
                graphics.drawLine(insets.left - 1, n2 + n4 - insets.bottom, n3 - insets.right, n2 + n4 - insets.bottom);
                return;
            }
            graphics.setColor(colorUIResource3);
            graphics.fillRect(n, n2 + 1, n3, 4);
            graphics.fillRect(n + 1, n2 + n4 - 5, n3 - 2, 4);
            Color color2 = ColorHelper.brighter(SmartLookAndFeel.getWindowTitleColorDark(), 30.0);
            if (bl) {
                JTattooUtilities.fillHorGradient(graphics, SmartLookAndFeel.getTheme().getWindowTitleColors(), 1, 5, 5, n5 + 1);
                JTattooUtilities.fillHorGradient(graphics, SmartLookAndFeel.getTheme().getWindowTitleColors(), n3 - 5, 5, 5, n5 + 1);
                colorUIResource = AbstractLookAndFeel.getTheme().getWindowTitleColorDark();
                color = AbstractLookAndFeel.getTheme().getWindowTitleColorLight();
                graphics2D.setPaint(new GradientPaint(0.0f, 5 + n5 + 1, colorUIResource, 0.0f, n4 - n5 - 10, color));
                graphics.fillRect(1, 5 + n5 + 1, 4, n4 - n5 - 10);
                graphics.fillRect(n3 - 5, 5 + n5 + 1, 4, n4 - n5 - 10);
                graphics2D.setPaint(null);
            } else {
                JTattooUtilities.fillHorGradient(graphics, SmartLookAndFeel.getTheme().getWindowInactiveTitleColors(), 1, 5, 5, n5 + 1);
                JTattooUtilities.fillHorGradient(graphics, SmartLookAndFeel.getTheme().getWindowInactiveTitleColors(), n3 - 5, 5, 5, n5 + 1);
                colorUIResource = AbstractLookAndFeel.getTheme().getWindowInactiveTitleColorDark();
                color = AbstractLookAndFeel.getTheme().getWindowInactiveTitleColorLight();
                graphics2D.setPaint(new GradientPaint(0.0f, 5 + n5 + 1, colorUIResource, 0.0f, n4 - n5 - 10, color));
                graphics.fillRect(1, 5 + n5 + 1, 4, n4 - n5 - 10);
                graphics.fillRect(n3 - 5, 5 + n5 + 1, 4, n4 - n5 - 10);
                graphics2D.setPaint(null);
            }
            if (bl && bl2) {
                int n6 = 17;
                color2 = SmartLookAndFeel.getWindowTitleColorDark();
                color = ColorHelper.brighter(color2, 30.0);
                Color color3 = ColorHelper.darker(color2, 20.0);
                graphics.setColor(color2);
                graphics.fillRect(n + 1, n2 + n4 - n6, 4, n6 - 1);
                graphics.fillRect(n + 5, n2 + n4 - 5, n6 - 5 - 1, n6 - 5 - 1);
                graphics.setColor(color3);
                graphics.drawLine(n + 1, n2 + n4 - n6 - 2, n + 5 - 2, n2 + n4 - n6 - 2);
                graphics.drawLine(n + 5 - 2, n2 + n4 - n6 - 2, n + 5 - 2, n2 + n4 - 5);
                graphics.drawLine(n + 5 - 2, n2 + n4 - 5, n + n6 - 1, n2 + n4 - 5);
                graphics.drawLine(n + n6 - 1, n2 + n4 - 5, n + n6 - 1, n2 + n4 - 1);
                graphics.setColor(color);
                graphics.drawLine(n + 1, n2 + n4 - n6 - 1, n + 5 - 3, n2 + n4 - n6 - 1);
                graphics.drawLine(n + 5 - 1, n2 + n4 - n6 - 1, n + 5 - 1, n2 + n4 - 5 - 1);
                graphics.drawLine(n + 5 - 1, n2 + n4 - 5 + 1, n + n6 - 2, n2 + n4 - 5 + 1);
                graphics.drawLine(n + n6 - 2, n2 + n4 - 5 + 1, n + n6 - 2, n2 + n4 - 1);
                graphics.setColor(color2);
                graphics.fillRect(n + n3 - n6 - 1, n2 + n4 - 5, n6, 4);
                graphics.fillRect(n + n3 - 5, n2 + n4 - n6 - 1, 4, n6);
                graphics.setColor(color3);
                graphics.drawLine(n + n3 - 5 - 1, n2 + n4 - n6 - 2, n + n3 - 1, n2 + n4 - n6 - 2);
                graphics.drawLine(n + n3 - 5, n2 + n4 - n6 - 2, n + n3 - 5, n2 + n4 - 5);
                graphics.drawLine(n + n3 - n6 - 1, n2 + n4 - 5, n + n3 - 5, n2 + n4 - 5);
                graphics.drawLine(n + n3 - n6 - 1, n2 + n4 - 5, n + n3 - n6 - 1, n2 + n4 - 1);
                graphics.setColor(color);
                graphics.drawLine(n + n3 - 5 + 1, n2 + n4 - n6 - 1, n + n3 - 1, n2 + n4 - n6 - 1);
                graphics.drawLine(n + n3 - 5 + 1, n2 + n4 - n6 - 1, n + n3 - 5 + 1, n2 + n4 - 5);
                graphics.drawLine(n + n3 - n6, n2 + n4 - 5 + 1, n + n3 - 5 + 1, n2 + n4 - 5 + 1);
                graphics.drawLine(n + n3 - n6, n2 + n4 - 5 + 1, n + n3 - n6, n2 + n4 - 1);
            }
            graphics.setColor(colorUIResource2);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            graphics.drawLine(n + 5 - 1, n2 + 5 + n5, n + 5 - 1, n2 + n4 - 5);
            graphics.drawLine(n + n3 - 5, n2 + 5 + n5, n + n3 - 5, n2 + n4 - 5);
            graphics.drawLine(n + 5 - 1, n2 + n4 - 5, n + n3 - 5, n2 + n4 - 5);
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed() || buttonModel.isSelected()) {
                    Color color = ColorHelper.darker(AbstractLookAndFeel.getToolbarBackgroundColor(), 30.0);
                    graphics.setColor(color);
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Composite composite = graphics2D.getComposite();
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.1f);
                    graphics2D.setComposite(alphaComposite);
                    graphics.setColor(Color.black);
                    graphics.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
                    graphics2D.setComposite(composite);
                } else if (buttonModel.isRollover()) {
                    ColorUIResource colorUIResource = AbstractLookAndFeel.getToolbarBackgroundColor();
                    Color color = ColorHelper.darker(colorUIResource, 5.0);
                    Color color2 = ColorHelper.darker(colorUIResource, 20.0);
                    JTattooUtilities.draw3DBorder(graphics, color, color2, n, n2, n3, n4);
                    color = Color.white;
                    color2 = ColorHelper.brighter(color2, 60.0);
                    JTattooUtilities.draw3DBorder(graphics, color, color2, n + 1, n2 + 1, n3 - 2, n4 - 2);
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Composite composite = graphics2D.getComposite();
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.4f);
                    graphics2D.setComposite(alphaComposite);
                    graphics.setColor(Color.white);
                    graphics.fillRect(n + 2, n2 + 2, n3 - 4, n4 - 4);
                    graphics2D.setComposite(composite);
                    graphics.setColor(AbstractLookAndFeel.getFocusColor());
                    graphics.drawLine(n + 1, n2 + 1, n + n3 - 1, n2 + 1);
                    graphics.drawLine(n + 1, n2 + 2, n + n3 - 2, n2 + 2);
                } else if (buttonModel.isSelected()) {
                    ColorUIResource colorUIResource = AbstractLookAndFeel.getToolbarBackgroundColor();
                    Color color = Color.white;
                    Color color3 = ColorHelper.darker(colorUIResource, 30.0);
                    JTattooUtilities.draw3DBorder(graphics, color3, color, n, n2, n3, n4);
                }
            }
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ToggleButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(3, 6, 3, 6);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isEnabled()) {
                Color color = Color.white;
                Color color2 = ColorHelper.brighter(SmartLookAndFeel.getFrameColor(), 80.0);
                Color color3 = ColorHelper.brighter(SmartLookAndFeel.getFrameColor(), 20.0);
                if (buttonModel.isPressed() && buttonModel.isArmed() || buttonModel.isSelected()) {
                    JTattooUtilities.draw3DBorder(graphics, color3, color, n + 1, n2 + 1, n3 - 1, n4 - 1);
                } else {
                    JTattooUtilities.draw3DBorder(graphics, color2, color, n, n2, n3, n4);
                    JTattooUtilities.draw3DBorder(graphics, ColorHelper.brighter(SmartLookAndFeel.getFrameColor(), 20.0), SmartLookAndFeel.getFrameColor(), n + 1, n2 + 1, n3 - 2, n4 - 2);
                }
            } else {
                JTattooUtilities.drawBorder(graphics, Color.lightGray, n, n2, n3, n4);
            }
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        private static final Color defaultColorHi = new Color(220, 230, 245);
        private static final Color defaultColorMed = new Color(212, 224, 243);
        private static final Color defaultColorLo = new Color(200, 215, 240);
        private static final Insets borderInsets = new Insets(3, 6, 3, 6);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = AbstractLookAndFeel.getTheme().getFrameColor();
            if (!JTattooUtilities.isFrameActive(abstractButton)) {
                color = ColorHelper.brighter(color, 40.0);
            }
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (abstractButton.getRootPane() != null && abstractButton.equals(abstractButton.getRootPane().getDefaultButton()) && !abstractButton.getModel().isRollover()) {
                graphics2D.setColor(defaultColorHi);
                graphics2D.drawRoundRect(n + 1, n2 + 1, n3 - 4, n4 - 2, 6, 6);
                graphics2D.setColor(defaultColorMed);
                graphics2D.drawRoundRect(n + 2, n2 + 2, n3 - 6, n4 - 6, 6, 6);
                graphics2D.setColor(defaultColorLo);
                graphics2D.drawLine(n + 3, n4 - 3, n3 - 3, n4 - 3);
                graphics2D.drawLine(n3 - 3, n2 + 4, n3 - 3, n4 - 4);
            }
            graphics2D.setColor(Color.white);
            graphics2D.drawRoundRect(n, n2, n3 - 1, n4 - 1, 6, 6);
            graphics2D.setColor(color);
            graphics2D.drawRoundRect(n, n2, n3 - 2, n4 - 2, 6, 6);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }

        public Insets getBorderInsets(Component component) {
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

