/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;

public class CachedIntrospectionResults {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$beans$CachedIntrospectionResults == null ? (class$org$springframework$beans$CachedIntrospectionResults = CachedIntrospectionResults.class$("org.springframework.beans.CachedIntrospectionResults")) : class$org$springframework$beans$CachedIntrospectionResults));
    static final Set acceptedClassLoaders = Collections.synchronizedSet(new HashSet());
    static final Map classCache = Collections.synchronizedMap(new WeakHashMap());
    private final BeanInfo beanInfo;
    private final Map propertyDescriptorCache;
    static /* synthetic */ Class class$org$springframework$beans$CachedIntrospectionResults;

    public static void acceptClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            acceptedClassLoaders.add(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearClassLoader(ClassLoader classLoader) {
        Object object;
        Iterator<Object> iterator;
        if (classLoader == null) {
            return;
        }
        Object object2 = classCache;
        synchronized (object2) {
            iterator = classCache.keySet().iterator();
            while (iterator.hasNext()) {
                object = (Class)iterator.next();
                if (!CachedIntrospectionResults.isUnderneathClassLoader(((Class)object).getClassLoader(), classLoader)) continue;
                iterator.remove();
            }
        }
        object2 = acceptedClassLoaders;
        synchronized (object2) {
            iterator = acceptedClassLoaders.iterator();
            while (iterator.hasNext()) {
                object = (ClassLoader)iterator.next();
                if (!CachedIntrospectionResults.isUnderneathClassLoader((ClassLoader)object, classLoader)) continue;
                iterator.remove();
            }
        }
    }

    static CachedIntrospectionResults forClass(Class clazz) throws BeansException {
        CachedIntrospectionResults cachedIntrospectionResults = null;
        Object v = classCache.get(clazz);
        if (v instanceof Reference) {
            Reference reference = (Reference)v;
            cachedIntrospectionResults = (CachedIntrospectionResults)reference.get();
        } else {
            cachedIntrospectionResults = (CachedIntrospectionResults)v;
        }
        if (cachedIntrospectionResults == null) {
            cachedIntrospectionResults = new CachedIntrospectionResults(clazz);
            if (CachedIntrospectionResults.isCacheSafe(clazz) || CachedIntrospectionResults.isClassLoaderAccepted(clazz.getClassLoader())) {
                classCache.put(clazz, cachedIntrospectionResults);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Not strongly caching class [" + clazz.getName() + "] because it is not cache-safe"));
                }
                classCache.put(clazz, new WeakReference<CachedIntrospectionResults>(cachedIntrospectionResults));
            }
        }
        return cachedIntrospectionResults;
    }

    private static boolean isClassLoaderAccepted(ClassLoader classLoader) {
        Object[] objectArray = acceptedClassLoaders.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ClassLoader classLoader2 = (ClassLoader)objectArray[i];
            if (!CachedIntrospectionResults.isUnderneathClassLoader(classLoader, classLoader2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCacheSafe(Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null) {
            return false;
        }
        ClassLoader classLoader2 = (class$org$springframework$beans$CachedIntrospectionResults == null ? (class$org$springframework$beans$CachedIntrospectionResults = CachedIntrospectionResults.class$("org.springframework.beans.CachedIntrospectionResults")) : class$org$springframework$beans$CachedIntrospectionResults).getClassLoader();
        if (classLoader2 == classLoader) {
            return true;
        }
        while (classLoader2 != null) {
            if ((classLoader2 = classLoader2.getParent()) != classLoader) continue;
            return true;
        }
        return false;
    }

    private static boolean isUnderneathClassLoader(ClassLoader classLoader, ClassLoader classLoader2) {
        if (classLoader == null) {
            return false;
        }
        if (classLoader == classLoader2) {
            return true;
        }
        ClassLoader classLoader3 = classLoader;
        while (classLoader3 != null) {
            if ((classLoader3 = classLoader3.getParent()) != classLoader2) continue;
            return true;
        }
        return false;
    }

    private CachedIntrospectionResults(Class clazz) throws BeansException {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Getting BeanInfo for class [" + clazz.getName() + "]"));
            }
            this.beanInfo = Introspector.getBeanInfo(clazz);
            Class clazz2 = clazz;
            do {
                Introspector.flushFromCaches(clazz2);
            } while ((clazz2 = clazz2.getSuperclass()) != null);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Caching PropertyDescriptors for class [" + clazz.getName() + "]"));
            }
            this.propertyDescriptorCache = new HashMap();
            PropertyDescriptor[] propertyDescriptorArray = this.beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Found bean property '" + propertyDescriptor.getName() + "'" + (propertyDescriptor.getPropertyType() != null ? " of type [" + propertyDescriptor.getPropertyType().getName() + "]" : "") + (propertyDescriptor.getPropertyEditorClass() != null ? "; editor [" + propertyDescriptor.getPropertyEditorClass().getName() + "]" : "")));
                }
                this.propertyDescriptorCache.put(propertyDescriptor.getName(), propertyDescriptor);
            }
        }
        catch (IntrospectionException introspectionException) {
            throw new FatalBeanException("Cannot get BeanInfo for object of class [" + clazz.getName() + "]", introspectionException);
        }
    }

    BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    Class getBeanClass() {
        return this.beanInfo.getBeanDescriptor().getBeanClass();
    }

    PropertyDescriptor getPropertyDescriptor(String string) {
        return (PropertyDescriptor)this.propertyDescriptorCache.get(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

