/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import org.springframework.util.StringUtils;

public class StringTrimmerEditor
extends PropertyEditorSupport {
    private final String charsToDelete;
    private final boolean emptyAsNull;

    public StringTrimmerEditor(boolean bl) {
        this.charsToDelete = null;
        this.emptyAsNull = bl;
    }

    public StringTrimmerEditor(String string, boolean bl) {
        this.charsToDelete = string;
        this.emptyAsNull = bl;
    }

    public void setAsText(String string) {
        if (string == null) {
            this.setValue(null);
        } else {
            String string2 = string.trim();
            if (this.charsToDelete != null) {
                string2 = StringUtils.deleteAny((String)string2, (String)this.charsToDelete);
            }
            if (this.emptyAsNull && "".equals(string2)) {
                this.setValue(null);
            } else {
                this.setValue(string2);
            }
        }
    }

    public String getAsText() {
        Object object = this.getValue();
        return object != null ? object.toString() : "";
    }
}

