/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl.platform.gstreamer;

import com.sun.media.jfxmedia.MediaError;
import com.sun.media.jfxmedia.MediaException;
import com.sun.media.jfxmedia.effects.AudioEqualizer;
import com.sun.media.jfxmedia.effects.AudioSpectrum;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmediaimpl.NativeMediaPlayer;
import com.sun.media.jfxmediaimpl.platform.gstreamer.GSTAudioEqualizer;
import com.sun.media.jfxmediaimpl.platform.gstreamer.GSTAudioSpectrum;
import com.sun.media.jfxmediaimpl.platform.gstreamer.GSTMedia;

final class GSTMediaPlayer
extends NativeMediaPlayer {
    private GSTMedia gstMedia = null;
    private float mutedVolume = 1.0f;
    private boolean muteEnabled = false;
    private boolean isStopTimeSet = false;
    private AudioEqualizer audioEqualizer;
    private AudioSpectrum audioSpectrum;

    private GSTMediaPlayer(GSTMedia gSTMedia) {
        super(gSTMedia);
        this.gstMedia = gSTMedia;
        int n = this.gstInitPlayer(this.gstMedia.getNativeMediaRef());
        if (0 != n) {
            this.throwMediaErrorException(n, null);
        }
        this.audioSpectrum = new GSTAudioSpectrum(this.gstMedia.getNativeMediaRef());
        this.audioEqualizer = new GSTAudioEqualizer(this.gstMedia.getNativeMediaRef());
    }

    GSTMediaPlayer(Locator locator) {
        this(new GSTMedia(locator));
    }

    public AudioEqualizer getEqualizer() {
        return this.audioEqualizer;
    }

    public AudioSpectrum getAudioSpectrum() {
        return this.audioSpectrum;
    }

    private void throwMediaErrorException(int n, String string) throws MediaException {
        MediaError mediaError = MediaError.getFromCode(n);
        throw new MediaException(string, null, mediaError);
    }

    protected long playerGetAudioSyncDelay() throws MediaException {
        long[] lArray = new long[1];
        int n = this.gstGetAudioSyncDelay(this.gstMedia.getNativeMediaRef(), lArray);
        if (0 != n) {
            this.throwMediaErrorException(n, null);
        }
        return lArray[0];
    }

    protected void playerSetAudioSyncDelay(long l) throws MediaException {
        int n = this.gstSetAudioSyncDelay(this.gstMedia.getNativeMediaRef(), l);
        if (0 != n) {
            this.throwMediaErrorException(n, null);
        }
    }

    protected void playerPlay() throws MediaException {
        int n = this.gstPlay(this.gstMedia.getNativeMediaRef());
        if (0 != n) {
            this.throwMediaErrorException(n, null);
        }
    }

    protected void playerStop() throws MediaException {
        int n = this.gstStop(this.gstMedia.getNativeMediaRef());
        if (0 != n) {
            this.throwMediaErrorException(n, null);
        }
    }

    protected void playerPause() throws MediaException {
        int n = this.gstPause(this.gstMedia.getNativeMediaRef());
        if (0 != n) {
            this.throwMediaErrorException(n, null);
        }
    }

    protected float playerGetRate() throws MediaException {
        float[] fArray = new float[1];
        int n = this.gstGetRate(this.gstMedia.getNativeMediaRef(), fArray);
        if (0 != n) {
            this.throwMediaErrorException(n, null);
        }
        return fArray[0];
    }

    protected void playerSetRate(float f) throws MediaException {
        int n = this.gstSetRate(this.gstMedia.getNativeMediaRef(), f);
        if (0 != n) {
            this.throwMediaErrorException(n, null);
        }
    }

    protected double playerGetPresentationTime() throws MediaException {
        double[] dArray = new double[1];
        int n = this.gstGetPresentationTime(this.gstMedia.getNativeMediaRef(), dArray);
        if (0 != n) {
            this.throwMediaErrorException(n, null);
        }
        return dArray[0];
    }

    protected boolean playerGetMute() throws MediaException {
        return this.muteEnabled;
    }

    protected synchronized void playerSetMute(boolean bl) throws MediaException {
        if (bl != this.muteEnabled) {
            if (bl) {
                float f = this.getVolume();
                this.playerSetVolume(0.0f);
                this.muteEnabled = true;
                this.mutedVolume = f;
            } else {
                this.muteEnabled = false;
                this.playerSetVolume(this.mutedVolume);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float playerGetVolume() throws MediaException {
        Object object = this;
        synchronized (object) {
            if (this.muteEnabled) {
                return this.mutedVolume;
            }
        }
        object = new float[1];
        int n = this.gstGetVolume(this.gstMedia.getNativeMediaRef(), (float[])object);
        if (0 != n) {
            this.throwMediaErrorException(n, null);
        }
        return (float)object[0];
    }

    protected synchronized void playerSetVolume(float f) throws MediaException {
        if (!this.muteEnabled) {
            int n = this.gstSetVolume(this.gstMedia.getNativeMediaRef(), f);
            if (0 != n) {
                this.throwMediaErrorException(n, null);
            } else {
                this.mutedVolume = f;
            }
        } else {
            this.mutedVolume = f;
        }
    }

    protected float playerGetBalance() throws MediaException {
        float[] fArray = new float[1];
        int n = this.gstGetBalance(this.gstMedia.getNativeMediaRef(), fArray);
        if (0 != n) {
            this.throwMediaErrorException(n, null);
        }
        return fArray[0];
    }

    protected void playerSetBalance(float f) throws MediaException {
        int n = this.gstSetBalance(this.gstMedia.getNativeMediaRef(), f);
        if (0 != n) {
            this.throwMediaErrorException(n, null);
        }
    }

    protected double playerGetDuration() throws MediaException {
        double[] dArray = new double[1];
        int n = this.gstGetDuration(this.gstMedia.getNativeMediaRef(), dArray);
        if (0 != n) {
            this.throwMediaErrorException(n, null);
        }
        if (dArray[0] == -1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return dArray[0];
    }

    protected synchronized double playerGetStartTime() throws MediaException {
        double[] dArray = new double[1];
        int n = this.gstGetStartTime(this.gstMedia.getNativeMediaRef(), dArray);
        if (0 != n) {
            this.throwMediaErrorException(n, null);
            dArray[0] = 0.0;
        }
        return dArray[0];
    }

    protected synchronized void playerSetStartTime(double d) throws MediaException {
        int n = this.gstSetStartTime(this.gstMedia.getNativeMediaRef(), d);
        if (0 != n) {
            this.throwMediaErrorException(n, null);
        }
    }

    protected synchronized double playerGetStopTime() throws MediaException {
        double[] dArray = new double[1];
        int n = this.gstGetStopTime(this.gstMedia.getNativeMediaRef(), dArray);
        if (0 != n) {
            this.throwMediaErrorException(n, null);
            dArray[0] = Double.MAX_VALUE;
        }
        return dArray[0];
    }

    protected synchronized void playerSetStopTime(double d) throws MediaException {
        int n = this.gstSetStopTime(this.gstMedia.getNativeMediaRef(), d);
        if (0 != n) {
            this.throwMediaErrorException(n, null);
        }
        this.isStopTimeSet = true;
    }

    protected void playerSeek(double d) throws MediaException {
        int n = this.gstSeek(this.gstMedia.getNativeMediaRef(), d);
        if (0 != n) {
            this.throwMediaErrorException(n, null);
        }
    }

    protected void playerInit() throws MediaException {
        if (!this.isStopTimeSet) {
            this.playerSetStopTime(Double.MAX_VALUE);
            this.isStopTimeSet = true;
        }
    }

    protected void playerDispose() {
        this.audioEqualizer = null;
        this.audioSpectrum = null;
        this.gstMedia = null;
    }

    private native int gstInitPlayer(long var1);

    private native int gstGetAudioSyncDelay(long var1, long[] var3);

    private native int gstSetAudioSyncDelay(long var1, long var3);

    private native int gstPlay(long var1);

    private native int gstPause(long var1);

    private native int gstStop(long var1);

    private native int gstGetRate(long var1, float[] var3);

    private native int gstSetRate(long var1, float var3);

    private native int gstGetPresentationTime(long var1, double[] var3);

    private native int gstGetVolume(long var1, float[] var3);

    private native int gstSetVolume(long var1, float var3);

    private native int gstGetBalance(long var1, float[] var3);

    private native int gstSetBalance(long var1, float var3);

    private native int gstGetStartTime(long var1, double[] var3);

    private native int gstSetStartTime(long var1, double var3);

    private native int gstGetStopTime(long var1, double[] var3);

    private native int gstSetStopTime(long var1, double var3);

    private native int gstGetDuration(long var1, double[] var3);

    private native int gstSeek(long var1, double var3);
}

