/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.util;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.fastinfoset.util.ValueArray;
import com.sun.xml.internal.fastinfoset.util.ValueArrayResourceException;

public class ContiguousCharArrayArray
extends ValueArray {
    public static final int INITIAL_CHARACTER_SIZE = 512;
    public static final int MAXIMUM_CHARACTER_SIZE = Integer.MAX_VALUE;
    protected int _maximumCharacterSize;
    public int[] _offset;
    public int[] _length;
    public char[] _array;
    public int _arrayIndex;
    public int _readOnlyArrayIndex;
    private String[] _cachedStrings;
    public int _cachedIndex;
    private ContiguousCharArrayArray _readOnlyArray;

    public ContiguousCharArrayArray(int n, int n2, int n3, int n4) {
        this._offset = new int[n];
        this._length = new int[n];
        this._array = new char[n3];
        this._maximumCapacity = n2;
        this._maximumCharacterSize = n4;
    }

    public ContiguousCharArrayArray() {
        this(10, Integer.MAX_VALUE, 512, Integer.MAX_VALUE);
    }

    @Override
    public final void clear() {
        this._arrayIndex = this._readOnlyArrayIndex;
        this._size = this._readOnlyArraySize;
        if (this._cachedStrings != null) {
            for (int i = this._readOnlyArraySize; i < this._cachedStrings.length; ++i) {
                this._cachedStrings[i] = null;
            }
        }
    }

    public final int getArrayIndex() {
        return this._arrayIndex;
    }

    @Override
    public final void setReadOnlyArray(ValueArray valueArray, boolean bl) {
        if (!(valueArray instanceof ContiguousCharArrayArray)) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.illegalClass", new Object[]{valueArray}));
        }
        this.setReadOnlyArray((ContiguousCharArrayArray)valueArray, bl);
    }

    public final void setReadOnlyArray(ContiguousCharArrayArray contiguousCharArrayArray, boolean bl) {
        if (contiguousCharArrayArray != null) {
            this._readOnlyArray = contiguousCharArrayArray;
            this._readOnlyArraySize = contiguousCharArrayArray.getSize();
            this._readOnlyArrayIndex = contiguousCharArrayArray.getArrayIndex();
            if (bl) {
                this.clear();
            }
            this._array = this.getCompleteCharArray();
            this._offset = this.getCompleteOffsetArray();
            this._length = this.getCompleteLengthArray();
            this._size = this._readOnlyArraySize;
            this._arrayIndex = this._readOnlyArrayIndex;
        }
    }

    public final char[] getCompleteCharArray() {
        if (this._readOnlyArray == null) {
            return this._array;
        }
        char[] cArray = this._readOnlyArray.getCompleteCharArray();
        char[] cArray2 = new char[this._readOnlyArrayIndex + this._array.length];
        System.arraycopy(cArray, 0, cArray2, 0, this._readOnlyArrayIndex);
        return cArray2;
    }

    public final int[] getCompleteOffsetArray() {
        if (this._readOnlyArray == null) {
            return this._offset;
        }
        int[] nArray = this._readOnlyArray.getCompleteOffsetArray();
        int[] nArray2 = new int[this._readOnlyArraySize + this._offset.length];
        System.arraycopy(nArray, 0, nArray2, 0, this._readOnlyArraySize);
        return nArray2;
    }

    public final int[] getCompleteLengthArray() {
        if (this._readOnlyArray == null) {
            return this._length;
        }
        int[] nArray = this._readOnlyArray.getCompleteLengthArray();
        int[] nArray2 = new int[this._readOnlyArraySize + this._length.length];
        System.arraycopy(nArray, 0, nArray2, 0, this._readOnlyArraySize);
        return nArray2;
    }

    public final String getString(int n) {
        if (this._cachedStrings != null && n < this._cachedStrings.length) {
            String string = this._cachedStrings[n];
            return string != null ? string : new String(this._array, this._offset[n], this._length[n]);
        }
        String[] stringArray = new String[this._offset.length];
        if (this._cachedStrings != null && n >= this._cachedStrings.length) {
            System.arraycopy(this._cachedStrings, 0, stringArray, 0, this._cachedStrings.length);
        }
        this._cachedStrings = stringArray;
        this._cachedStrings[n] = new String(this._array, this._offset[n], this._length[n]);
        return this._cachedStrings[n];
    }

    public final void ensureSize(int n) {
        if (this._arrayIndex + n >= this._array.length) {
            this.resizeArray(this._arrayIndex + n);
        }
    }

    public final void add(int n) {
        if (this._size == this._offset.length) {
            this.resize();
        }
        this._cachedIndex = this._size;
        this._offset[this._size] = this._arrayIndex;
        this._length[this._size++] = n;
        this._arrayIndex += n;
    }

    public final int add(char[] cArray, int n) {
        if (this._size == this._offset.length) {
            this.resize();
        }
        int n2 = this._arrayIndex;
        int n3 = n2 + n;
        this._cachedIndex = this._size;
        this._offset[this._size] = n2;
        this._length[this._size++] = n;
        if (n3 >= this._array.length) {
            this.resizeArray(n3);
        }
        System.arraycopy(cArray, 0, this._array, n2, n);
        this._arrayIndex = n3;
        return n2;
    }

    protected final void resize() {
        if (this._size == this._maximumCapacity) {
            throw new ValueArrayResourceException(CommonResourceBundle.getInstance().getString("message.arrayMaxCapacity"));
        }
        int n = this._size * 3 / 2 + 1;
        if (n > this._maximumCapacity) {
            n = this._maximumCapacity;
        }
        int[] nArray = new int[n];
        System.arraycopy(this._offset, 0, nArray, 0, this._size);
        this._offset = nArray;
        int[] nArray2 = new int[n];
        System.arraycopy(this._length, 0, nArray2, 0, this._size);
        this._length = nArray2;
    }

    protected final void resizeArray(int n) {
        if (this._arrayIndex == this._maximumCharacterSize) {
            throw new ValueArrayResourceException(CommonResourceBundle.getInstance().getString("message.maxNumberOfCharacters"));
        }
        int n2 = n * 3 / 2 + 1;
        if (n2 > this._maximumCharacterSize) {
            n2 = this._maximumCharacterSize;
        }
        char[] cArray = new char[n2];
        System.arraycopy(this._array, 0, cArray, 0, this._arrayIndex);
        this._array = cArray;
    }
}

