/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import sun.misc.Unsafe;

public class ForkJoinPool
extends AbstractExecutorService {
    public static final ForkJoinWorkerThreadFactory defaultForkJoinWorkerThreadFactory;
    private static final RuntimePermission modifyThreadPermission;
    private static final AtomicInteger poolNumberGenerator;
    static final Random workerSeedGenerator;
    ForkJoinWorkerThread[] workers;
    private static final int INITIAL_QUEUE_CAPACITY = 8;
    private static final int MAXIMUM_QUEUE_CAPACITY = 0x1000000;
    private ForkJoinTask<?>[] submissionQueue;
    private final ReentrantLock submissionLock;
    private final Condition termination;
    private final ForkJoinWorkerThreadFactory factory;
    final Thread.UncaughtExceptionHandler ueh;
    private final String workerNamePrefix;
    private volatile long stealCount;
    volatile long ctl;
    private static final int AC_SHIFT = 48;
    private static final int TC_SHIFT = 32;
    private static final int ST_SHIFT = 31;
    private static final int EC_SHIFT = 16;
    private static final int MAX_ID = Short.MAX_VALUE;
    private static final int SMASK = 65535;
    private static final int SHORT_SIGN = 32768;
    private static final int INT_SIGN = Integer.MIN_VALUE;
    private static final long STOP_BIT = 0x80000000L;
    private static final long AC_MASK = -281474976710656L;
    private static final long TC_MASK = 0xFFFF00000000L;
    private static final long TC_UNIT = 0x100000000L;
    private static final long AC_UNIT = 0x1000000000000L;
    private static final int UAC_SHIFT = 16;
    private static final int UTC_SHIFT = 0;
    private static final int UAC_MASK = -65536;
    private static final int UTC_MASK = 65535;
    private static final int UAC_UNIT = 65536;
    private static final int UTC_UNIT = 1;
    private static final int E_MASK = Integer.MAX_VALUE;
    private static final int EC_UNIT = 65536;
    final int parallelism;
    volatile int queueBase;
    int queueTop;
    volatile boolean shutdown;
    final boolean locallyFifo;
    volatile int quiescerCount;
    volatile int blockedCount;
    private volatile int nextWorkerNumber;
    private int nextWorkerIndex;
    volatile int scanGuard;
    private static final int SG_UNIT = 65536;
    private static final long SHRINK_RATE = 4000000000L;
    private static final Unsafe UNSAFE;
    private static final long ctlOffset;
    private static final long stealCountOffset;
    private static final long blockedCountOffset;
    private static final long quiescerCountOffset;
    private static final long scanGuardOffset;
    private static final long nextWorkerNumberOffset;
    private static final long ABASE;
    private static final int ASHIFT;

    private static void checkPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(modifyThreadPermission);
        }
    }

    final void work(ForkJoinWorkerThread forkJoinWorkerThread) {
        long l;
        boolean bl = false;
        while (!forkJoinWorkerThread.terminate && (int)(l = this.ctl) >= 0) {
            int n;
            if (!bl && (n = (int)(l >> 48)) <= 0) {
                bl = this.scan(forkJoinWorkerThread, n);
                continue;
            }
            if (!this.tryAwaitWork(forkJoinWorkerThread, l)) continue;
            bl = false;
        }
    }

    final void signalWork() {
        int n;
        long l;
        int n2;
        while ((((n2 = (int)(l = this.ctl)) | (n = (int)(l >>> 32))) & 0x80008000) == -2147450880 && n2 >= 0) {
            if (n2 > 0) {
                ForkJoinWorkerThread forkJoinWorkerThread;
                int n3;
                ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.workers;
                if (this.workers == null || (n3 = ~n2 & 0xFFFF) >= forkJoinWorkerThreadArray.length || (forkJoinWorkerThread = forkJoinWorkerThreadArray[n3]) == null) break;
                long l2 = (long)(forkJoinWorkerThread.nextWait & Integer.MAX_VALUE) | (long)(n + 65536) << 32;
                if (forkJoinWorkerThread.eventCount != n2 || !UNSAFE.compareAndSwapLong(this, ctlOffset, l, l2)) continue;
                forkJoinWorkerThread.eventCount = n2 + 65536 & Integer.MAX_VALUE;
                if (!forkJoinWorkerThread.parked) break;
                UNSAFE.unpark(forkJoinWorkerThread);
                break;
            }
            if (!UNSAFE.compareAndSwapLong(this, ctlOffset, l, (long)(n + 1 & 0xFFFF | n + 65536 & 0xFFFF0000) << 32)) continue;
            this.addWorker();
            break;
        }
    }

    private boolean tryReleaseWaiter() {
        long l = this.ctl;
        int n = (int)l;
        if (n > 0 && (int)(l >> 48) < 0) {
            ForkJoinWorkerThread forkJoinWorkerThread;
            int n2;
            ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.workers;
            if (this.workers != null && (n2 = ~n & 0xFFFF) < forkJoinWorkerThreadArray.length && (forkJoinWorkerThread = forkJoinWorkerThreadArray[n2]) != null) {
                long l2 = (long)(forkJoinWorkerThread.nextWait & Integer.MAX_VALUE) | l + 0x1000000000000L & 0xFFFFFFFF00000000L;
                if (forkJoinWorkerThread.eventCount != n || !UNSAFE.compareAndSwapLong(this, ctlOffset, l, l2)) {
                    return false;
                }
                forkJoinWorkerThread.eventCount = n + 65536 & Integer.MAX_VALUE;
                if (forkJoinWorkerThread.parked) {
                    UNSAFE.unpark(forkJoinWorkerThread);
                }
            }
        }
        return true;
    }

    private boolean scan(ForkJoinWorkerThread forkJoinWorkerThread, int n) {
        int n2;
        int n3;
        int n4 = this.scanGuard;
        int n5 = this.parallelism == 1 - n && this.blockedCount == 0 ? 0 : n4 & 0xFFFF;
        ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.workers;
        if (forkJoinWorkerThreadArray == null || forkJoinWorkerThreadArray.length <= n5) {
            return false;
        }
        int n6 = n3 = forkJoinWorkerThread.seed;
        for (n2 = -(n5 + n5); n2 <= n5 + n5; ++n2) {
            int n7;
            ForkJoinWorkerThread forkJoinWorkerThread2 = forkJoinWorkerThreadArray[n6 & n5];
            if (forkJoinWorkerThread2 != null && (n7 = forkJoinWorkerThread2.queueBase) != forkJoinWorkerThread2.queueTop) {
                int n8;
                ForkJoinTask<?>[] forkJoinTaskArray = forkJoinWorkerThread2.queue;
                if (forkJoinWorkerThread2.queue != null && (n8 = forkJoinTaskArray.length - 1 & n7) >= 0) {
                    long l = (long)(n8 << ASHIFT) + ABASE;
                    ForkJoinTask<?> forkJoinTask = forkJoinTaskArray[n8];
                    if (forkJoinTask != null && forkJoinWorkerThread2.queueBase == n7 && UNSAFE.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask, null)) {
                        forkJoinWorkerThread2.queueBase = n7 + 1;
                        int n9 = forkJoinWorkerThread2.queueBase - forkJoinWorkerThread2.queueTop;
                        forkJoinWorkerThread2.stealHint = forkJoinWorkerThread.poolIndex;
                        if (n9 != 0) {
                            this.signalWork();
                        }
                        forkJoinWorkerThread.execTask(forkJoinTask);
                    }
                    n3 ^= n3 << 13;
                    n3 ^= n3 >>> 17;
                    forkJoinWorkerThread.seed = n3 ^ n3 << 5;
                    return false;
                }
            }
            if (n2 < 0) {
                n3 ^= n3 << 13;
                n3 ^= n3 >>> 17;
                n3 ^= n3 << 5;
                n6 = n3;
                continue;
            }
            ++n6;
        }
        if (this.scanGuard != n4) {
            return false;
        }
        n2 = this.queueBase;
        if (n2 != this.queueTop) {
            int n10;
            ForkJoinTask<?>[] forkJoinTaskArray = this.submissionQueue;
            if (this.submissionQueue != null && (n10 = forkJoinTaskArray.length - 1 & n2) >= 0) {
                long l = (long)(n10 << ASHIFT) + ABASE;
                ForkJoinTask<?> forkJoinTask = forkJoinTaskArray[n10];
                if (forkJoinTask != null && this.queueBase == n2 && UNSAFE.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask, null)) {
                    this.queueBase = n2 + 1;
                    forkJoinWorkerThread.execTask(forkJoinTask);
                }
                return false;
            }
        }
        return true;
    }

    private boolean tryAwaitWork(ForkJoinWorkerThread forkJoinWorkerThread, long l) {
        int n = forkJoinWorkerThread.eventCount;
        forkJoinWorkerThread.nextWait = (int)l;
        long l2 = (long)(n & Integer.MAX_VALUE) | l - 0x1000000000000L & 0xFFFFFFFF00000000L;
        if (this.ctl != l || !UNSAFE.compareAndSwapLong(this, ctlOffset, l, l2)) {
            long l3 = this.ctl;
            return (int)l3 != (int)l && (l3 - l & 0xFFFF000000000000L) >= 0L;
        }
        int n2 = forkJoinWorkerThread.stealCount;
        while (n2 != 0) {
            long l4 = this.stealCount;
            if (UNSAFE.compareAndSwapLong(this, stealCountOffset, l4, l4 + (long)n2)) {
                forkJoinWorkerThread.stealCount = 0;
                n2 = 0;
                continue;
            }
            if (forkJoinWorkerThread.eventCount == n) continue;
            return true;
        }
        if (!(this.shutdown && this.tryTerminate(false) || (int)l == 0 || this.parallelism + (int)(l2 >> 48) != 0 || this.blockedCount != 0 || this.quiescerCount != 0)) {
            this.idleAwaitWork(forkJoinWorkerThread, l2, l, n);
        }
        n2 = 0;
        while (forkJoinWorkerThread.eventCount == n) {
            if (n2 == 0) {
                int n3 = this.scanGuard;
                int n4 = n3 & 0xFFFF;
                ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.workers;
                if (forkJoinWorkerThreadArray != null && n4 < forkJoinWorkerThreadArray.length) {
                    n2 = 1;
                    for (int i = 0; i <= n4; ++i) {
                        ForkJoinWorkerThread forkJoinWorkerThread2 = forkJoinWorkerThreadArray[i];
                        if (forkJoinWorkerThread2 == null) continue;
                        if (forkJoinWorkerThread2.queueBase != forkJoinWorkerThread2.queueTop && !this.tryReleaseWaiter()) {
                            n2 = 0;
                        }
                        if (forkJoinWorkerThread.eventCount == n) continue;
                        return true;
                    }
                }
                if (this.scanGuard != n3 || this.queueBase != this.queueTop && !this.tryReleaseWaiter()) {
                    n2 = 0;
                }
                if (n2 == 0) {
                    Thread.yield();
                    continue;
                }
                Thread.interrupted();
                continue;
            }
            forkJoinWorkerThread.parked = true;
            if (forkJoinWorkerThread.eventCount != n) {
                forkJoinWorkerThread.parked = false;
                return true;
            }
            LockSupport.park(this);
            forkJoinWorkerThread.parked = false;
            n2 = 0;
        }
        return true;
    }

    private void idleAwaitWork(ForkJoinWorkerThread forkJoinWorkerThread, long l, long l2, int n) {
        if (forkJoinWorkerThread.eventCount == n) {
            if (this.shutdown) {
                this.tryTerminate(false);
            }
            ForkJoinTask.helpExpungeStaleExceptions();
            while (this.ctl == l) {
                long l3 = System.nanoTime();
                forkJoinWorkerThread.parked = true;
                if (forkJoinWorkerThread.eventCount == n) {
                    LockSupport.parkNanos(this, 4000000000L);
                }
                forkJoinWorkerThread.parked = false;
                if (forkJoinWorkerThread.eventCount != n) break;
                if (System.nanoTime() - l3 < 3600000000L) {
                    Thread.interrupted();
                    continue;
                }
                if (!UNSAFE.compareAndSwapLong(this, ctlOffset, l, l2)) continue;
                forkJoinWorkerThread.terminate = true;
                forkJoinWorkerThread.eventCount = (int)l + 65536 & Integer.MAX_VALUE;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSubmission(ForkJoinTask<?> forkJoinTask) {
        ReentrantLock reentrantLock = this.submissionLock;
        reentrantLock.lock();
        try {
            ForkJoinTask<?>[] forkJoinTaskArray = this.submissionQueue;
            if (this.submissionQueue != null) {
                int n = this.queueTop;
                int n2 = forkJoinTaskArray.length - 1;
                long l = (long)((n & n2) << ASHIFT) + ABASE;
                UNSAFE.putOrderedObject(forkJoinTaskArray, l, forkJoinTask);
                this.queueTop = n + 1;
                if (n - this.queueBase == n2) {
                    this.growSubmissionQueue();
                }
            }
        }
        finally {
            reentrantLock.unlock();
        }
        this.signalWork();
    }

    private void growSubmissionQueue() {
        int n;
        int n2;
        ForkJoinTask<?>[] forkJoinTaskArray = this.submissionQueue;
        int n3 = n2 = forkJoinTaskArray != null ? forkJoinTaskArray.length << 1 : 8;
        if (n2 > 0x1000000) {
            throw new RejectedExecutionException("Queue capacity exceeded");
        }
        if (n2 < 8) {
            n2 = 8;
        }
        this.submissionQueue = new ForkJoinTask[n2];
        ForkJoinTask[] forkJoinTaskArray2 = this.submissionQueue;
        int n4 = n2 - 1;
        int n5 = this.queueTop;
        if (forkJoinTaskArray != null && (n = forkJoinTaskArray.length - 1) >= 0) {
            for (int i = this.queueBase; i != n5; ++i) {
                long l = (long)((i & n) << ASHIFT) + ABASE;
                Object object = UNSAFE.getObjectVolatile(forkJoinTaskArray, l);
                if (object == null || !UNSAFE.compareAndSwapObject(forkJoinTaskArray, l, object, null)) continue;
                UNSAFE.putObjectVolatile(forkJoinTaskArray2, (long)((i & n4) << ASHIFT) + ABASE, object);
            }
        }
    }

    private boolean tryPreBlock() {
        int n = this.blockedCount;
        if (UNSAFE.compareAndSwapInt(this, blockedCountOffset, n, n + 1)) {
            int n2 = this.parallelism;
            do {
                short s;
                long l;
                long l2 = this.ctl;
                int n3 = (int)(l2 >>> 32);
                int n4 = (int)l2;
                if (n4 < 0) continue;
                int n5 = n3 >> 16;
                if (n5 <= 0 && n4 != 0) {
                    ForkJoinWorkerThread forkJoinWorkerThread;
                    int n6;
                    ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.workers;
                    if (this.workers != null && (n6 = ~n4 & 0xFFFF) < forkJoinWorkerThreadArray.length && (forkJoinWorkerThread = forkJoinWorkerThreadArray[n6]) != null) {
                        l = (long)(forkJoinWorkerThread.nextWait & Integer.MAX_VALUE) | l2 & 0xFFFFFFFF00000000L;
                        if (forkJoinWorkerThread.eventCount != n4 || !UNSAFE.compareAndSwapLong(this, ctlOffset, l2, l)) continue;
                        forkJoinWorkerThread.eventCount = n4 + 65536 & Integer.MAX_VALUE;
                        if (forkJoinWorkerThread.parked) {
                            UNSAFE.unpark(forkJoinWorkerThread);
                        }
                        return true;
                    }
                }
                if ((s = (short)(n3 >>> 0)) >= 0 && n5 + n2 > 1) {
                    l = l2 - 0x1000000000000L & 0xFFFF000000000000L | l2 & 0xFFFFFFFFFFFFL;
                    if (!UNSAFE.compareAndSwapLong(this, ctlOffset, l2, l)) continue;
                    return true;
                }
                if (s + n2 >= Short.MAX_VALUE || !UNSAFE.compareAndSwapLong(this, ctlOffset, l2, l = l2 + 0x100000000L & 0xFFFF00000000L | l2 & 0xFFFF0000FFFFFFFFL)) continue;
                this.addWorker();
                return true;
            } while (!UNSAFE.compareAndSwapInt(this, blockedCountOffset, n = this.blockedCount, n - 1));
        }
        return false;
    }

    private void postBlock() {
        int n;
        long l;
        while (!UNSAFE.compareAndSwapLong(this, ctlOffset, l = this.ctl, l + 0x1000000000000L)) {
        }
        while (!UNSAFE.compareAndSwapInt(this, blockedCountOffset, n = this.blockedCount, n - 1)) {
        }
    }

    final void tryAwaitJoin(ForkJoinTask<?> forkJoinTask) {
        Thread.interrupted();
        if (forkJoinTask.status >= 0) {
            if (this.tryPreBlock()) {
                forkJoinTask.tryAwaitDone(0L);
                this.postBlock();
            } else if ((this.ctl & 0x80000000L) != 0L) {
                forkJoinTask.cancelIgnoringExceptions();
            }
        }
    }

    final void timedAwaitJoin(ForkJoinTask<?> forkJoinTask, long l) {
        while (forkJoinTask.status >= 0) {
            long l2;
            Thread.interrupted();
            if ((this.ctl & 0x80000000L) != 0L) {
                forkJoinTask.cancelIgnoringExceptions();
                break;
            }
            if (!this.tryPreBlock()) continue;
            long l3 = System.nanoTime();
            while (forkJoinTask.status >= 0 && (l2 = TimeUnit.NANOSECONDS.toMillis(l)) > 0L) {
                forkJoinTask.tryAwaitDone(l2);
                if (forkJoinTask.status < 0) break;
                if ((this.ctl & 0x80000000L) != 0L) {
                    forkJoinTask.cancelIgnoringExceptions();
                    break;
                }
                long l4 = System.nanoTime();
                l -= l4 - l3;
                l3 = l4;
            }
            this.postBlock();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitBlocker(ManagedBlocker managedBlocker) throws InterruptedException {
        while (!managedBlocker.isReleasable()) {
            if (!this.tryPreBlock()) continue;
            try {
                while (!managedBlocker.isReleasable() && !managedBlocker.block()) {
                }
                break;
            }
            finally {
                this.postBlock();
            }
        }
    }

    private void addWorker() {
        Throwable throwable = null;
        ForkJoinWorkerThread forkJoinWorkerThread = null;
        try {
            forkJoinWorkerThread = this.factory.newThread(this);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        if (forkJoinWorkerThread == null) {
            long l;
            while (!UNSAFE.compareAndSwapLong(this, ctlOffset, l = this.ctl, l - 0x1000000000000L & 0xFFFF000000000000L | l - 0x100000000L & 0xFFFF00000000L | l & 0xFFFFFFFFL)) {
            }
            if (!this.tryTerminate(false) && throwable != null && !(Thread.currentThread() instanceof ForkJoinWorkerThread)) {
                UNSAFE.throwException(throwable);
            }
        } else {
            forkJoinWorkerThread.start();
        }
    }

    final String nextWorkerName() {
        int n;
        do {
            n = this.nextWorkerNumber;
        } while (!UNSAFE.compareAndSwapInt(this, nextWorkerNumberOffset, n, ++n));
        return this.workerNamePrefix + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    final int registerWorker(ForkJoinWorkerThread var1_1) {
        block3: while (true) {
            if (((var2_2 = this.scanGuard) & 65536) == 0 && ForkJoinPool.UNSAFE.compareAndSwapInt(this, ForkJoinPool.scanGuardOffset, var2_2, var2_2 | 65536)) {
                var4_5 = this.nextWorkerIndex;
                try {
                    var3_3 = this.workers;
                    if (this.workers != null) {
                        var5_6 = var3_3.length;
                        if (var4_5 < 0 || var4_5 >= var5_6 || var3_3[var4_5] != null) {
                            for (var4_5 = 0; var4_5 < var5_6 && var3_3[var4_5] != null; ++var4_5) {
                            }
                            if (var4_5 == var5_6) {
                                var3_3 = this.workers = Arrays.copyOf(var3_3, var5_6 << 1);
                            }
                        }
                        var3_3[var4_5] = var1_1;
                        this.nextWorkerIndex = var4_5 + 1;
                        var6_7 = var2_2 & 65535;
                        var2_2 = var4_5 > var6_7 ? (var6_7 << 1) + 1 & 65535 : var2_2 + 131072;
                    }
                }
                finally {
                    this.scanGuard = var2_2;
                }
                return var4_5;
            }
            var3_3 = this.workers;
            if (this.workers == null) continue;
            var4_4 = var3_3;
            var5_6 = var4_4.length;
            var6_7 = 0;
            while (true) {
                if (!(var6_7 >= var5_6 || (var7_8 = var4_4[var6_7]) != null && var7_8.queueBase != var7_8.queueTop && this.tryReleaseWaiter())) ** break;
                continue block3;
                ++var6_7;
            }
            break;
        }
    }

    final void deregisterWorker(ForkJoinWorkerThread forkJoinWorkerThread, Throwable throwable) {
        int n = forkJoinWorkerThread.poolIndex;
        int n2 = forkJoinWorkerThread.stealCount;
        int n3 = 0;
        do {
            long l;
            long l2;
            int n4;
            if (n3 == 0 && ((n4 = this.scanGuard) & 0x10000) == 0 && UNSAFE.compareAndSwapInt(this, scanGuardOffset, n4, n4 |= 0x10000)) {
                ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.workers;
                if (forkJoinWorkerThreadArray != null && n >= 0 && n < forkJoinWorkerThreadArray.length && forkJoinWorkerThreadArray[n] == forkJoinWorkerThread) {
                    forkJoinWorkerThreadArray[n] = null;
                }
                this.nextWorkerIndex = n;
                this.scanGuard = n4 + 65536;
                n3 = 1;
            }
            if (n3 == 1 && UNSAFE.compareAndSwapLong(this, ctlOffset, l2 = this.ctl, l2 - 0x1000000000000L & 0xFFFF000000000000L | l2 - 0x100000000L & 0xFFFF00000000L | l2 & 0xFFFFFFFFL)) {
                n3 = 2;
            }
            if (n2 == 0 || !UNSAFE.compareAndSwapLong(this, stealCountOffset, l = this.stealCount, l + (long)n2)) continue;
            n2 = 0;
        } while (n3 != 2 || n2 != 0);
        if (!this.tryTerminate(false)) {
            if (throwable != null) {
                this.signalWork();
            } else {
                this.tryReleaseWaiter();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryTerminate(boolean bl) {
        long l;
        while (((l = this.ctl) & 0x80000000L) == 0L) {
            if (!bl) {
                if ((int)(l >> 48) != -this.parallelism) {
                    return false;
                }
                if (!this.shutdown || this.blockedCount != 0 || this.quiescerCount != 0 || this.queueBase != this.queueTop) {
                    if (this.ctl != l) continue;
                    return false;
                }
            }
            if (!UNSAFE.compareAndSwapLong(this, ctlOffset, l, l | 0x80000000L)) continue;
            this.startTerminating();
        }
        if ((short)(l >>> 32) == -this.parallelism) {
            ReentrantLock reentrantLock = this.submissionLock;
            reentrantLock.lock();
            try {
                this.termination.signalAll();
            }
            finally {
                reentrantLock.unlock();
            }
        }
        return true;
    }

    private void startTerminating() {
        this.cancelSubmissions();
        for (int i = 0; i < 3; ++i) {
            ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.workers;
            if (forkJoinWorkerThreadArray == null) continue;
            for (ForkJoinWorkerThread forkJoinWorkerThread : forkJoinWorkerThreadArray) {
                if (forkJoinWorkerThread == null) continue;
                forkJoinWorkerThread.terminate = true;
                if (i <= 0) continue;
                forkJoinWorkerThread.cancelTasks();
                if (i <= 1 || forkJoinWorkerThread.isInterrupted()) continue;
                try {
                    forkJoinWorkerThread.interrupt();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            this.terminateWaiters();
        }
    }

    private void cancelSubmissions() {
        while (this.queueBase != this.queueTop) {
            ForkJoinTask<?> forkJoinTask = this.pollSubmission();
            if (forkJoinTask == null) continue;
            try {
                forkJoinTask.cancel(false);
            }
            catch (Throwable throwable) {}
        }
    }

    private void terminateWaiters() {
        ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.workers;
        if (forkJoinWorkerThreadArray != null) {
            ForkJoinWorkerThread forkJoinWorkerThread;
            long l;
            int n;
            int n2;
            int n3 = forkJoinWorkerThreadArray.length;
            while ((n2 = ~(n = (int)(l = this.ctl)) & 0xFFFF) < n3 && (forkJoinWorkerThread = forkJoinWorkerThreadArray[n2]) != null && forkJoinWorkerThread.eventCount == (n & Integer.MAX_VALUE)) {
                if (!UNSAFE.compareAndSwapLong(this, ctlOffset, l, (long)(forkJoinWorkerThread.nextWait & Integer.MAX_VALUE) | l + 0x1000000000000L & 0xFFFF000000000000L | l & 0xFFFF80000000L)) continue;
                forkJoinWorkerThread.terminate = true;
                forkJoinWorkerThread.eventCount = n + 65536;
                if (!forkJoinWorkerThread.parked) continue;
                UNSAFE.unpark(forkJoinWorkerThread);
            }
        }
    }

    final void addQuiescerCount(int n) {
        int n2;
        while (!UNSAFE.compareAndSwapInt(this, quiescerCountOffset, n2 = this.quiescerCount, n2 + n)) {
        }
    }

    final void addActiveCount(int n) {
        long l;
        long l2;
        long l3 = l2 = n < 0 ? -281474976710656L : 0x1000000000000L;
        while (!UNSAFE.compareAndSwapLong(this, ctlOffset, l = this.ctl, l + l2 & 0xFFFF000000000000L | l & 0xFFFFFFFFFFFFL)) {
        }
    }

    final int idlePerActive() {
        int n = this.parallelism;
        int n2 = n + (int)(this.ctl >> 48);
        return n2 > (n >>>= 1) ? 0 : (n2 > (n >>>= 1) ? 1 : (n2 > (n >>>= 1) ? 2 : (n2 > (n >>>= 1) ? 4 : 8)));
    }

    public ForkJoinPool() {
        this(Runtime.getRuntime().availableProcessors(), defaultForkJoinWorkerThreadFactory, null, false);
    }

    public ForkJoinPool(int n) {
        this(n, defaultForkJoinWorkerThreadFactory, null, false);
    }

    public ForkJoinPool(int n, ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, boolean bl) {
        ForkJoinPool.checkPermission();
        if (forkJoinWorkerThreadFactory == null) {
            throw new NullPointerException();
        }
        if (n <= 0 || n > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.parallelism = n;
        this.factory = forkJoinWorkerThreadFactory;
        this.ueh = uncaughtExceptionHandler;
        this.locallyFifo = bl;
        long l = -n;
        this.ctl = l << 48 & 0xFFFF000000000000L | l << 32 & 0xFFFF00000000L;
        this.submissionQueue = new ForkJoinTask[8];
        int n2 = n << 1;
        if (n2 >= Short.MAX_VALUE) {
            n2 = Short.MAX_VALUE;
        } else {
            n2 |= n2 >>> 1;
            n2 |= n2 >>> 2;
            n2 |= n2 >>> 4;
            n2 |= n2 >>> 8;
        }
        this.workers = new ForkJoinWorkerThread[n2 + 1];
        this.submissionLock = new ReentrantLock();
        this.termination = this.submissionLock.newCondition();
        StringBuilder stringBuilder = new StringBuilder("ForkJoinPool-");
        stringBuilder.append(poolNumberGenerator.incrementAndGet());
        stringBuilder.append("-worker-");
        this.workerNamePrefix = stringBuilder.toString();
    }

    public <T> T invoke(ForkJoinTask<T> forkJoinTask) {
        Thread thread = Thread.currentThread();
        if (forkJoinTask == null) {
            throw new NullPointerException();
        }
        if (this.shutdown) {
            throw new RejectedExecutionException();
        }
        if (thread instanceof ForkJoinWorkerThread && ((ForkJoinWorkerThread)thread).pool == this) {
            return forkJoinTask.invoke();
        }
        this.addSubmission(forkJoinTask);
        return forkJoinTask.join();
    }

    /*
     * Enabled aggressive block sorting
     */
    private <T> void forkOrSubmit(ForkJoinTask<T> forkJoinTask) {
        Thread thread = Thread.currentThread();
        if (this.shutdown) {
            throw new RejectedExecutionException();
        }
        if (thread instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread;
            if (forkJoinWorkerThread.pool == this) {
                forkJoinWorkerThread.pushTask(forkJoinTask);
                return;
            }
        }
        this.addSubmission(forkJoinTask);
    }

    public void execute(ForkJoinTask<?> forkJoinTask) {
        if (forkJoinTask == null) {
            throw new NullPointerException();
        }
        this.forkOrSubmit(forkJoinTask);
    }

    @Override
    public void execute(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        ForkJoinTask<Object> forkJoinTask = runnable instanceof ForkJoinTask ? (ForkJoinTask<Object>)((Object)runnable) : ForkJoinTask.adapt(runnable, null);
        this.forkOrSubmit(forkJoinTask);
    }

    public <T> ForkJoinTask<T> submit(ForkJoinTask<T> forkJoinTask) {
        if (forkJoinTask == null) {
            throw new NullPointerException();
        }
        this.forkOrSubmit(forkJoinTask);
        return forkJoinTask;
    }

    public <T> ForkJoinTask<T> submit(Callable<T> callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        ForkJoinTask<T> forkJoinTask = ForkJoinTask.adapt(callable);
        this.forkOrSubmit(forkJoinTask);
        return forkJoinTask;
    }

    public <T> ForkJoinTask<T> submit(Runnable runnable, T t) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        ForkJoinTask<T> forkJoinTask = ForkJoinTask.adapt(runnable, t);
        this.forkOrSubmit(forkJoinTask);
        return forkJoinTask;
    }

    public ForkJoinTask<?> submit(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        ForkJoinTask<Object> forkJoinTask = runnable instanceof ForkJoinTask ? (ForkJoinTask<Object>)((Object)runnable) : ForkJoinTask.adapt(runnable, null);
        this.forkOrSubmit(forkJoinTask);
        return forkJoinTask;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) {
        ArrayList arrayList = new ArrayList(collection.size());
        for (Callable<T> callable : collection) {
            arrayList.add(ForkJoinTask.adapt(callable));
        }
        this.invoke(new InvokeAll(arrayList));
        ArrayList arrayList2 = arrayList;
        return arrayList2;
    }

    public ForkJoinWorkerThreadFactory getFactory() {
        return this.factory;
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.ueh;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public int getPoolSize() {
        return this.parallelism + (short)(this.ctl >>> 32);
    }

    public boolean getAsyncMode() {
        return this.locallyFifo;
    }

    public int getRunningThreadCount() {
        int n = this.parallelism + (int)(this.ctl >> 48);
        return n <= 0 ? 0 : n;
    }

    public int getActiveThreadCount() {
        int n = this.parallelism + (int)(this.ctl >> 48) + this.blockedCount;
        return n <= 0 ? 0 : n;
    }

    public boolean isQuiescent() {
        return this.parallelism + (int)(this.ctl >> 48) + this.blockedCount == 0;
    }

    public long getStealCount() {
        return this.stealCount;
    }

    public long getQueuedTaskCount() {
        long l = 0L;
        if ((short)(this.ctl >>> 32) > -this.parallelism) {
            ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.workers;
            if (this.workers != null) {
                for (ForkJoinWorkerThread forkJoinWorkerThread : forkJoinWorkerThreadArray) {
                    if (forkJoinWorkerThread == null) continue;
                    l -= (long)(forkJoinWorkerThread.queueBase - forkJoinWorkerThread.queueTop);
                }
            }
        }
        return l;
    }

    public int getQueuedSubmissionCount() {
        return -this.queueBase + this.queueTop;
    }

    public boolean hasQueuedSubmissions() {
        return this.queueBase != this.queueTop;
    }

    protected ForkJoinTask<?> pollSubmission() {
        int n;
        while ((n = this.queueBase) != this.queueTop) {
            int n2;
            ForkJoinTask<?>[] forkJoinTaskArray = this.submissionQueue;
            if (this.submissionQueue == null || (n2 = forkJoinTaskArray.length - 1 & n) < 0) break;
            long l = (long)(n2 << ASHIFT) + ABASE;
            ForkJoinTask<?> forkJoinTask = forkJoinTaskArray[n2];
            if (forkJoinTask == null || this.queueBase != n || !UNSAFE.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask, null)) continue;
            this.queueBase = n + 1;
            return forkJoinTask;
        }
        return null;
    }

    protected int drainTasksTo(Collection<? super ForkJoinTask<?>> collection) {
        ForkJoinWorkerThread[] forkJoinWorkerThreadArray;
        int n = 0;
        while (this.queueBase != this.queueTop) {
            forkJoinWorkerThreadArray = this.pollSubmission();
            if (forkJoinWorkerThreadArray == null) continue;
            collection.add((ForkJoinTask<?>)forkJoinWorkerThreadArray);
            ++n;
        }
        if ((short)(this.ctl >>> 32) > -this.parallelism) {
            forkJoinWorkerThreadArray = this.workers;
            if (this.workers != null) {
                for (ForkJoinWorkerThread forkJoinWorkerThread : forkJoinWorkerThreadArray) {
                    if (forkJoinWorkerThread == null) continue;
                    n += forkJoinWorkerThread.drainTasksTo(collection);
                }
            }
        }
        return n;
    }

    public String toString() {
        long l = this.getStealCount();
        long l2 = this.getQueuedTaskCount();
        long l3 = this.getQueuedSubmissionCount();
        int n = this.parallelism;
        long l4 = this.ctl;
        int n2 = n + (short)(l4 >>> 32);
        int n3 = n + (int)(l4 >> 48);
        if (n3 < 0) {
            n3 = 0;
        }
        int n4 = n3 + this.blockedCount;
        String string = (l4 & 0x80000000L) != 0L ? (n2 == 0 ? "Terminated" : "Terminating") : (this.shutdown ? "Shutting down" : "Running");
        return super.toString() + "[" + string + ", parallelism = " + n + ", size = " + n2 + ", active = " + n4 + ", running = " + n3 + ", steals = " + l + ", tasks = " + l2 + ", submissions = " + l3 + "]";
    }

    @Override
    public void shutdown() {
        ForkJoinPool.checkPermission();
        this.shutdown = true;
        this.tryTerminate(false);
    }

    @Override
    public List<Runnable> shutdownNow() {
        ForkJoinPool.checkPermission();
        this.shutdown = true;
        this.tryTerminate(true);
        return Collections.emptyList();
    }

    @Override
    public boolean isTerminated() {
        long l = this.ctl;
        return (l & 0x80000000L) != 0L && (short)(l >>> 32) == -this.parallelism;
    }

    public boolean isTerminating() {
        long l = this.ctl;
        return (l & 0x80000000L) != 0L && (short)(l >>> 32) != -this.parallelism;
    }

    final boolean isAtLeastTerminating() {
        return (this.ctl & 0x80000000L) != 0L;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.submissionLock;
        reentrantLock.lock();
        try {
            while (true) {
                if (this.isTerminated()) {
                    boolean bl = true;
                    return bl;
                }
                if (l2 <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                l2 = this.termination.awaitNanos(l2);
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public static void managedBlock(ManagedBlocker managedBlocker) throws InterruptedException {
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread;
            forkJoinWorkerThread.pool.awaitBlocker(managedBlocker);
        } else {
            while (!managedBlocker.isReleasable() && !managedBlocker.block()) {
            }
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
        return (RunnableFuture)((Object)ForkJoinTask.adapt(runnable, t));
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return (RunnableFuture)((Object)ForkJoinTask.adapt(callable));
    }

    static {
        int n;
        poolNumberGenerator = new AtomicInteger();
        workerSeedGenerator = new Random();
        modifyThreadPermission = new RuntimePermission("modifyThread");
        defaultForkJoinWorkerThreadFactory = new DefaultForkJoinWorkerThreadFactory();
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<ForkJoinPool> clazz = ForkJoinPool.class;
            ctlOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("ctl"));
            stealCountOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("stealCount"));
            blockedCountOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("blockedCount"));
            quiescerCountOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("quiescerCount"));
            scanGuardOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("scanGuard"));
            nextWorkerNumberOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("nextWorkerNumber"));
            Class<ForkJoinTask[]> clazz2 = ForkJoinTask[].class;
            ABASE = UNSAFE.arrayBaseOffset(clazz2);
            n = UNSAFE.arrayIndexScale(clazz2);
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
        if ((n & n - 1) != 0) {
            throw new Error("data type scale not a power of two");
        }
        ASHIFT = 31 - Integer.numberOfLeadingZeros(n);
    }

    static class DefaultForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        DefaultForkJoinWorkerThreadFactory() {
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool forkJoinPool) {
            return new ForkJoinWorkerThread(forkJoinPool);
        }
    }

    public static interface ForkJoinWorkerThreadFactory {
        public ForkJoinWorkerThread newThread(ForkJoinPool var1);
    }

    static final class InvokeAll<T>
    extends RecursiveAction {
        final ArrayList<ForkJoinTask<T>> tasks;
        private static final long serialVersionUID = -7914297376763021607L;

        InvokeAll(ArrayList<ForkJoinTask<T>> arrayList) {
            this.tasks = arrayList;
        }

        @Override
        public void compute() {
            try {
                InvokeAll.invokeAll(this.tasks);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface ManagedBlocker {
        public boolean block() throws InterruptedException;

        public boolean isReleasable();
    }
}

