/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.access;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.beans.factory.access.BootstrapException;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;

public class SingletonBeanFactoryLocator
implements BeanFactoryLocator {
    private static final String DEFAULT_RESOURCE_LOCATION = "classpath*:beanRefFactory.xml";
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$beans$factory$access$SingletonBeanFactoryLocator == null ? (class$org$springframework$beans$factory$access$SingletonBeanFactoryLocator = SingletonBeanFactoryLocator.class$("org.springframework.beans.factory.access.SingletonBeanFactoryLocator")) : class$org$springframework$beans$factory$access$SingletonBeanFactoryLocator));
    private static Map instances = new HashMap();
    private final Map bfgInstancesByKey = new HashMap();
    private final Map bfgInstancesByObj = new HashMap();
    private final String resourceLocation;
    static /* synthetic */ Class class$org$springframework$beans$factory$access$SingletonBeanFactoryLocator;

    public static BeanFactoryLocator getInstance() throws BeansException {
        return SingletonBeanFactoryLocator.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanFactoryLocator getInstance(String string) throws BeansException {
        String string2 = string;
        if (string2 == null) {
            string2 = DEFAULT_RESOURCE_LOCATION;
        }
        if (!ResourcePatternUtils.isUrl((String)string2)) {
            string2 = "classpath*:" + string2;
        }
        Map map = instances;
        synchronized (map) {
            BeanFactoryLocator beanFactoryLocator;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("SingletonBeanFactoryLocator.getInstance(): instances.hashCode=" + ((Object)instances).hashCode() + ", instances=" + instances));
            }
            if ((beanFactoryLocator = (BeanFactoryLocator)instances.get(string2)) == null) {
                beanFactoryLocator = new SingletonBeanFactoryLocator(string2);
                instances.put(string2, beanFactoryLocator);
            }
            return beanFactoryLocator;
        }
    }

    protected SingletonBeanFactoryLocator(String string) {
        this.resourceLocation = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanFactoryReference useBeanFactory(String string) throws BeansException {
        Map map = this.bfgInstancesByKey;
        synchronized (map) {
            Object object;
            BeanFactory beanFactory;
            BeanFactoryGroup beanFactoryGroup = (BeanFactoryGroup)this.bfgInstancesByKey.get(this.resourceLocation);
            if (beanFactoryGroup != null) {
                beanFactoryGroup.refCount++;
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Factory group with resource name [" + this.resourceLocation + "] requested. Creating new instance."));
                }
                beanFactory = this.createDefinition(this.resourceLocation, string);
                beanFactoryGroup = new BeanFactoryGroup();
                beanFactoryGroup.definition = beanFactory;
                beanFactoryGroup.refCount = 1;
                this.bfgInstancesByKey.put(this.resourceLocation, beanFactoryGroup);
                this.bfgInstancesByObj.put(beanFactory, beanFactoryGroup);
                try {
                    this.initializeDefinition(beanFactory);
                }
                catch (BeansException beansException) {
                    throw new BootstrapException("Unable to initialize group definition. Group resource name [" + this.resourceLocation + "], factory key [" + string + "]", (Throwable)((Object)beansException));
                }
            }
            beanFactory = beanFactoryGroup.definition;
            String string2 = string;
            try {
                object = beanFactory.getBean(string2);
                if (object instanceof String) {
                    logger.warn((Object)"You're using the deprecated alias-through-String-bean feature, which will be removed as of Spring 2.1. It is recommended to replace this with an <alias> tag (see SingletonBeanFactoryLocator javadoc).");
                    string2 = (String)object;
                    object = beanFactory.getBean(string2);
                }
            }
            catch (BeansException beansException) {
                throw new BootstrapException("Unable to return specified BeanFactory instance: factory key [" + string + "], from group with resource name [" + this.resourceLocation + "]", (Throwable)((Object)beansException));
            }
            if (!(object instanceof BeanFactory)) {
                throw new BootstrapException("Bean '" + string2 + "' is not a BeanFactory: factory key [" + string + "], from group with resource name [" + this.resourceLocation + "]");
            }
            final BeanFactory beanFactory2 = (BeanFactory)object;
            return new BeanFactoryReference(){
                BeanFactory groupContextRef;
                {
                    this.groupContextRef = beanFactory;
                }

                public BeanFactory getFactory() {
                    return beanFactory2;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void release() throws FatalBeanException {
                    Map map = SingletonBeanFactoryLocator.this.bfgInstancesByKey;
                    synchronized (map) {
                        BeanFactory beanFactory3 = this.groupContextRef;
                        if (beanFactory3 != null) {
                            this.groupContextRef = null;
                            BeanFactoryGroup beanFactoryGroup = (BeanFactoryGroup)SingletonBeanFactoryLocator.this.bfgInstancesByObj.get(beanFactory3);
                            if (beanFactoryGroup != null) {
                                beanFactoryGroup.refCount--;
                                if (beanFactoryGroup.refCount == 0) {
                                    SingletonBeanFactoryLocator.this.destroyDefinition(beanFactory3, SingletonBeanFactoryLocator.this.resourceLocation);
                                    SingletonBeanFactoryLocator.this.bfgInstancesByKey.remove(SingletonBeanFactoryLocator.this.resourceLocation);
                                    SingletonBeanFactoryLocator.this.bfgInstancesByObj.remove(beanFactory3);
                                }
                            } else {
                                logger.warn((Object)("Tried to release a SingletonBeanFactoryLocator group definition more times than it has actually been used. Resource name [" + SingletonBeanFactoryLocator.this.resourceLocation + "]"));
                            }
                        }
                    }
                }
            };
        }
    }

    protected BeanFactory createDefinition(String string, String string2) {
        DefaultListableBeanFactory defaultListableBeanFactory = new DefaultListableBeanFactory();
        XmlBeanDefinitionReader xmlBeanDefinitionReader = new XmlBeanDefinitionReader(defaultListableBeanFactory);
        PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resourceArray = pathMatchingResourcePatternResolver.getResources(string);
            if (resourceArray.length == 0) {
                throw new FatalBeanException("Unable to find resource for specified definition. Group resource name [" + this.resourceLocation + "], factory key [" + string2 + "]");
            }
            xmlBeanDefinitionReader.loadBeanDefinitions(resourceArray);
        }
        catch (IOException iOException) {
            throw new BeanDefinitionStoreException("Error accessing bean definition resource [" + this.resourceLocation + "]", iOException);
        }
        catch (BeanDefinitionStoreException beanDefinitionStoreException) {
            throw new FatalBeanException("Unable to load group definition: group resource name [" + this.resourceLocation + "], factory key [" + string2 + "]", (Throwable)((Object)beanDefinitionStoreException));
        }
        return defaultListableBeanFactory;
    }

    protected void initializeDefinition(BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            ((ConfigurableListableBeanFactory)beanFactory).preInstantiateSingletons();
        }
    }

    protected void destroyDefinition(BeanFactory beanFactory, String string) {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Factory group with selector '" + string + "' being released, as there are no more references to it"));
            }
            ((ConfigurableBeanFactory)beanFactory).destroySingletons();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class BeanFactoryGroup {
        private BeanFactory definition;
        private int refCount = 0;

        private BeanFactoryGroup() {
        }
    }
}

