/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.parsing;

import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.ParseState;
import org.springframework.util.Assert;

public class Problem {
    private final String message;
    private final Location location;
    private final ParseState parseState;
    private final Throwable rootCause;

    public Problem(String string, Location location) {
        this(string, location, null, null);
    }

    public Problem(String string, Location location, ParseState parseState) {
        this(string, location, parseState, null);
    }

    public Problem(String string, Location location, ParseState parseState, Throwable throwable) {
        Assert.notNull((Object)string, (String)"Message must not be null");
        Assert.notNull((Object)location, (String)"Location must not be null");
        this.message = string;
        this.location = location;
        this.parseState = parseState;
        this.rootCause = throwable;
    }

    public String getMessage() {
        return this.message;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getResourceDescription() {
        return this.getLocation().getResource().getDescription();
    }

    public ParseState getParseState() {
        return this.parseState;
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Configuration problem: ");
        stringBuffer.append(this.getMessage());
        stringBuffer.append("\nOffending resource: ").append(this.getResourceDescription());
        if (this.getParseState() != null) {
            stringBuffer.append('\n').append(this.getParseState());
        }
        return stringBuffer.toString();
    }
}

