/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.io;

import gnu.io.CommPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.wimpi.modbus.Modbus;
import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.io.ModbusTransport;
import net.wimpi.modbus.io.SerialInputStream;
import net.wimpi.modbus.msg.ModbusMessage;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.util.ModbusUtil;

public abstract class ModbusSerialTransport
implements ModbusTransport {
    protected CommPort m_CommPort;
    protected boolean m_Echo = false;

    public abstract void prepareStreams(InputStream var1, OutputStream var2) throws IOException;

    @Override
    public abstract ModbusResponse readResponse() throws ModbusIOException;

    @Override
    public abstract ModbusRequest readRequest() throws ModbusIOException;

    @Override
    public abstract void writeMessage(ModbusMessage var1) throws ModbusIOException;

    @Override
    public abstract void close() throws IOException;

    public void setCommPort(CommPort cp) throws IOException {
        this.m_CommPort = cp;
        if (cp != null) {
            this.prepareStreams(new SerialInputStream(cp.getInputStream()), cp.getOutputStream());
        }
    }

    public boolean isEcho() {
        return this.m_Echo;
    }

    public void setEcho(boolean b) {
        this.m_Echo = b;
    }

    public void setReceiveThreshold(int th) {
    }

    public void setReceiveTimeout(int ms) {
        try {
            this.m_CommPort.enableReceiveTimeout(ms);
        }
        catch (UnsupportedCommOperationException e) {
            System.out.println(e.getMessage());
        }
    }

    public void readEcho(int len) throws IOException {
        byte[] echoBuf = new byte[len];
        this.setReceiveThreshold(len);
        int echoLen = new SerialInputStream(this.m_CommPort.getInputStream()).read(echoBuf, 0, len);
        if (Modbus.debug) {
            System.out.println("Echo: " + ModbusUtil.toHex(echoBuf, 0, echoLen));
        }
        this.m_CommPort.disableReceiveThreshold();
        if (echoLen != len) {
            if (Modbus.debug) {
                System.err.println("Error: Transmit echo not received.");
            }
            throw new IOException("Echo not received.");
        }
    }
}

