/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import com.sun.javafx.scene.input.InputEventUtils;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.input.InputEvent;

public class ContextMenuEvent
extends InputEvent {
    public static final EventType<ContextMenuEvent> CONTEXT_MENU_REQUESTED = new EventType(ANY, "CONTEXT_MENU_REQUESTED");
    private boolean keyboardTrigger;
    private double x;
    private double y;
    private double screenX;
    private double screenY;
    private double sceneX;
    private double sceneY;

    private ContextMenuEvent(EventType<? extends ContextMenuEvent> eventType) {
        super((EventType<? extends InputEvent>)eventType);
    }

    @Deprecated
    public static ContextMenuEvent impl_contextEvent(double d, double d2, double d3, double d4, boolean bl, EventType<? extends ContextMenuEvent> eventType) {
        ContextMenuEvent contextMenuEvent = new ContextMenuEvent(eventType);
        contextMenuEvent.x = d;
        contextMenuEvent.y = d2;
        contextMenuEvent.screenX = d3;
        contextMenuEvent.screenY = d4;
        contextMenuEvent.sceneX = d;
        contextMenuEvent.sceneY = d2;
        contextMenuEvent.keyboardTrigger = bl;
        return contextMenuEvent;
    }

    private void recomputeCoordinatesToSource(ContextMenuEvent contextMenuEvent, Object object) {
        Point2D point2D = InputEventUtils.recomputeCoordinates(new Point2D(this.sceneX, this.sceneY), null, object);
        contextMenuEvent.x = point2D.getX();
        contextMenuEvent.y = point2D.getY();
    }

    @Override
    public Event copyFor(Object object, EventTarget eventTarget) {
        ContextMenuEvent contextMenuEvent = (ContextMenuEvent)super.copyFor(object, eventTarget);
        this.recomputeCoordinatesToSource(contextMenuEvent, object);
        return contextMenuEvent;
    }

    public boolean isKeyboardTrigger() {
        return this.keyboardTrigger;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getScreenX() {
        return this.screenX;
    }

    public final double getScreenY() {
        return this.screenY;
    }

    public final double getSceneX() {
        return this.sceneX;
    }

    public final double getSceneY() {
        return this.sceneY;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ContextMenuEvent [");
        stringBuilder.append("source = ").append(this.getSource());
        stringBuilder.append(", target = ").append(this.getTarget());
        stringBuilder.append(", eventType = ").append(this.getEventType());
        stringBuilder.append(", consumed = ").append(this.isConsumed());
        stringBuilder.append(", x = ").append(this.getX()).append(", y = ").append(this.getY());
        return stringBuilder.append("]").toString();
    }
}

