/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.impl.jdbc.LOBFile;
import org.apache.derby.io.StorageFile;

class EncryptedLOBFile
extends LOBFile {
    private final int blockSize;
    private final byte[] tail;
    private int tailSize;
    private long currentPos;
    private final DataFactory df;

    EncryptedLOBFile(StorageFile storageFile, DataFactory dataFactory) throws FileNotFoundException {
        super(storageFile);
        this.df = dataFactory;
        this.blockSize = dataFactory.getEncryptionBlockSize();
        this.tail = new byte[this.blockSize];
        this.tailSize = 0;
    }

    private byte[] getBlocks(long l, int n) throws IOException, StandardException {
        if (n < 0) {
            throw new IndexOutOfBoundsException(MessageService.getTextMessage("XJ071.S", new Integer(n)));
        }
        long l2 = l - l % (long)this.blockSize;
        long l3 = (l + (long)n + (long)this.blockSize - 1L) / (long)this.blockSize * (long)this.blockSize;
        byte[] byArray = new byte[(int)(l3 - l2)];
        super.seek(l2);
        super.read(byArray, 0, byArray.length);
        return byArray;
    }

    long length() throws IOException {
        return super.length() + (long)this.tailSize;
    }

    long getFilePointer() {
        return this.currentPos;
    }

    void seek(long l) throws IOException {
        long l2 = super.length();
        if (l > l2 + (long)this.tailSize) {
            throw new IllegalArgumentException("Internal Error");
        }
        if (l < l2) {
            super.seek(l);
        }
        this.currentPos = l;
    }

    void write(int n) throws IOException, StandardException {
        long l = super.length();
        if (this.currentPos >= l) {
            int n2 = (int)(this.currentPos - l);
            this.tail[n2] = (byte)n;
            if (n2 >= this.tailSize) {
                this.tailSize = n2 + 1;
            }
            if (this.tailSize == this.blockSize) {
                byte[] byArray = new byte[this.blockSize];
                this.df.encrypt(this.tail, 0, this.tailSize, byArray, 0, false);
                super.seek(l);
                super.write(byArray);
                this.tailSize = 0;
            }
        } else {
            byte[] byArray = this.getBlocks(this.currentPos, 1);
            byte[] byArray2 = new byte[this.blockSize];
            this.df.decrypt(byArray, 0, this.blockSize, byArray2, 0);
            byArray2[(int)(this.currentPos % (long)this.blockSize)] = (byte)n;
            this.df.encrypt(byArray2, 0, this.blockSize, byArray, 0, false);
            super.seek(this.currentPos - this.currentPos % (long)this.blockSize);
            super.write(byArray);
        }
        ++this.currentPos;
    }

    void write(byte[] byArray, int n, int n2) throws IOException, StandardException {
        int n3;
        byte[] byArray2;
        int n4;
        long l = super.length();
        if (this.currentPos < l) {
            int n5;
            n4 = (int)Math.max(0L, this.currentPos + (long)n2 - l);
            long l2 = this.currentPos;
            byte[] byArray3 = this.getBlocks(this.currentPos, n2 - n4);
            byArray2 = new byte[byArray3.length];
            for (n5 = 0; n5 < byArray3.length / this.blockSize; ++n5) {
                this.df.decrypt(byArray3, n5 * this.blockSize, this.blockSize, byArray2, n5 * this.blockSize);
            }
            System.arraycopy(byArray, n, byArray2, (int)(this.currentPos % (long)this.blockSize), n2 - n4);
            for (n5 = 0; n5 < byArray3.length / this.blockSize; ++n5) {
                this.df.encrypt(byArray2, n5 * this.blockSize, this.blockSize, byArray3, n5 * this.blockSize, false);
            }
            super.seek(l2 - l2 % (long)this.blockSize);
            super.write(byArray3);
            this.currentPos = l2 + (long)byArray3.length;
            if (n4 == 0) {
                return;
            }
            n = n + n2 - n4;
            n2 = n4;
            this.currentPos = l;
        }
        if ((n3 = (n4 = (int)(this.currentPos - l)) + n2) < this.blockSize) {
            System.arraycopy(byArray, n, this.tail, n4, n2);
            this.tailSize = Math.max(this.tailSize, n4 + n2);
            this.currentPos += (long)n2;
            return;
        }
        int n6 = n3 - n3 % this.blockSize;
        int n7 = n3 % this.blockSize;
        byArray2 = new byte[n6];
        System.arraycopy(this.tail, 0, byArray2, 0, n4);
        System.arraycopy(byArray, n, byArray2, n4, n6 - n4);
        byte[] byArray4 = new byte[byArray2.length];
        for (int i = 0; i < byArray4.length; i += this.blockSize) {
            this.df.encrypt(byArray2, i, this.blockSize, byArray4, i, false);
        }
        super.seek(l);
        super.write(byArray4);
        System.arraycopy(byArray, n + n2 - n7, this.tail, 0, n7);
        this.tailSize = n7;
        this.currentPos = (long)this.tailSize + l + (long)byArray4.length;
    }

    void write(byte[] byArray) throws IOException, StandardException {
        this.write(byArray, 0, byArray.length);
    }

    void close() throws IOException {
        super.close();
    }

    int readByte() throws IOException, StandardException {
        long l = super.length();
        if (this.currentPos >= l + (long)this.tailSize) {
            throw new EOFException();
        }
        if (this.currentPos >= l) {
            return this.tail[(int)(this.currentPos++ - l)] & 0xFF;
        }
        byte[] byArray = this.getBlocks(this.currentPos, 1);
        byte[] byArray2 = new byte[byArray.length];
        this.df.decrypt(byArray, 0, byArray.length, byArray2, 0);
        return byArray2[(int)(this.currentPos++ % (long)this.blockSize)] & 0xFF;
    }

    int read(byte[] byArray, int n, int n2) throws IOException, StandardException {
        long l = super.length();
        if (this.currentPos < l) {
            int n3;
            int n4 = (int)Math.max(0L, this.currentPos + (long)n2 - l);
            byte[] byArray2 = this.getBlocks(this.currentPos, n2 - n4);
            byte[] byArray3 = new byte[byArray2.length];
            for (n3 = 0; n3 < byArray2.length; n3 += this.blockSize) {
                this.df.decrypt(byArray2, n3, this.blockSize, byArray3, n3);
            }
            System.arraycopy(byArray3, (int)(this.currentPos % (long)this.blockSize), byArray, n, n2 - n4);
            if (n4 == 0) {
                this.currentPos += (long)n2;
                return n2;
            }
            n3 = Math.min(n4, this.tailSize);
            System.arraycopy(this.tail, 0, byArray, n + n2 - n4, n3);
            this.currentPos += (long)(n2 - n4 + n3);
            return n2 - n4 + n3;
        }
        int n5 = (int)Math.min((long)this.tailSize - this.currentPos + l, (long)n2);
        if (n5 == 0 && n2 != 0) {
            return -1;
        }
        System.arraycopy(this.tail, (int)(this.currentPos - l), byArray, n, n5);
        this.currentPos += (long)n5;
        return n5;
    }

    void setLength(long l) throws IOException, StandardException {
        long l2 = super.length();
        if (l > l2 + (long)this.tailSize) {
            throw new IllegalArgumentException("Internal Error");
        }
        if (l < l2) {
            byte[] byArray = this.getBlocks(l, 1);
            super.setLength(l - l % (long)this.blockSize);
            this.df.decrypt(byArray, 0, this.blockSize, this.tail, 0);
            this.tailSize = (int)(l % (long)this.blockSize);
        } else {
            this.tailSize = (int)(l - l2);
        }
    }
}

