/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.communicate;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ICommunicateDevice;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.util.CRCUtil;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class SerialHandlerSolaris
implements IComUSBHandler,
ICommunicateDevice,
SerialPortEventListener {
    private static final Logger logger = Logger.getLogger(SerialHandlerSolaris.class);
    private CommPortIdentifier portId;
    private InputStream input = null;
    private OutputStream output = null;
    private SerialPort serialPort;
    private String dataBuff;
    private int _errorcount = 0;
    protected AbstractProcessor notifyProcesser;

    public SerialHandlerSolaris(CommPortIdentifier portId) throws Exception {
        this.portId = portId;
        int baudRate = 2400;
        this.serialPort = (SerialPort)portId.open("Arista", baudRate);
        try {
            this.serialPort.enableReceiveTimeout(1200);
        }
        catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
        }
        this.serialPort.setSerialPortParams(baudRate, 8, 1, 0);
        this.input = this.serialPort.getInputStream();
        this.output = this.serialPort.getOutputStream();
        this.serialPort.addEventListener((SerialPortEventListener)this);
        this.serialPort.notifyOnDataAvailable(true);
        this.serialPort.notifyOnCTS(true);
        this.serialPort.notifyOnDSR(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized String excuteSimpleCommand(String command) {
        this.dataBuff = "";
        boolean result = true;
        try {
            try {
                int time = 0;
                while (true) {
                    if (this.dataBuff != null && this.dataBuff.length() != 0) {
                        if (!this.dataBuff.startsWith("(NAK")) return this.dataBuff;
                    }
                    if (time >= 3) {
                        return this.dataBuff;
                    }
                    byte[] crc = CRCUtil.getCRCByte(command);
                    byte[] bytes = command.getBytes();
                    this.output.write(bytes);
                    this.output.write(crc);
                    this.output.write(13);
                    this.output.flush();
                    long end = System.currentTimeMillis() + 2000L;
                    while (System.currentTimeMillis() < end && this.dataBuff.length() <= 0) {
                    }
                    this.dataBuff = CRCUtil.checkCRC(this.dataBuff) ? this.dataBuff.substring(0, this.dataBuff.length() - 2) : "";
                    ++time;
                }
            }
            catch (Exception ex) {
                result = false;
                this.countErrorandNotifyProcesser(result);
                return this.dataBuff;
            }
        }
        finally {
            this.countErrorandNotifyProcesser(result);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public synchronized String excuteCommand(String command, boolean isResponse) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 10[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void countErrorandNotifyProcesser(boolean success) {
        this._errorcount = success ? 0 : ++this._errorcount;
        if (this._errorcount >= 3 && this.notifyProcesser != null) {
            System.out.println("---------communication exception---------" + this._errorcount);
            this.notifyProcesser.close();
        }
    }

    @Override
    public void close() {
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.serialPort != null) {
            try {
                this.serialPort.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void serialEvent(SerialPortEvent evt) {
        switch (evt.getEventType()) {
            case 3: {
                System.out.println("CTS event occured.");
                break;
            }
            case 6: {
                System.out.println("CD event occured.");
                break;
            }
            case 10: {
                System.out.println("BI event occured.");
                break;
            }
            case 4: {
                System.out.println("DSR event occured.");
                break;
            }
            case 9: {
                System.out.println("FE event occured.");
                break;
            }
            case 7: {
                System.out.println("OE event occured.");
                break;
            }
            case 8: {
                System.out.println("PE event occured.");
                break;
            }
            case 5: {
                System.out.println("RI event occured.");
                break;
            }
            case 2: {
                System.out.println("OUTPUT_BUFFER_EMPTY event occured.");
                break;
            }
            case 1: {
                StringBuilder sb = new StringBuilder();
                try {
                    int ch;
                    while ((ch = this.input.read()) >= 0) {
                        if (ch == 13) break;
                        sb.append((char)ch);
                    }
                    this.dataBuff = sb.toString();
                    break;
                }
                catch (Exception e) {
                    this.dataBuff = "";
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public String getDeviceName() {
        String portName = this.portId.getName();
        int index = portName.lastIndexOf("/");
        if (index > 0) {
            portName = portName.substring(index + 1, portName.length());
        }
        return portName;
    }

    @Override
    public void setNotifyProcess(AbstractProcessor process) {
        this.notifyProcesser = process;
    }

    @Override
    public int getMpptTrackNumber() {
        int mpptTrackNumber = 2;
        try {
            String result = this.excuteCommand("QPIRI", true);
            if (result != null && !"".equals(result) && !result.equals("QPIRI")) {
                String[] arr = result.split(" ");
                mpptTrackNumber = Integer.parseInt(arr[7]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mpptTrackNumber;
    }

    @Override
    public String getSerialNo() {
        String serialno = "";
        String serialnoStr = "";
        try {
            int i = 0;
            while (i < 3) {
                serialnoStr = this.excuteCommand("QSID", true);
                if (!(serialnoStr == null || "".equals(serialnoStr) || serialnoStr.equalsIgnoreCase("(NAK") || serialnoStr.equalsIgnoreCase("(ACK") || serialnoStr.equals("QSID"))) {
                    String validLen = serialnoStr.substring(1, 3);
                    serialno = serialnoStr.substring(3, 3 + Integer.valueOf(validLen));
                    break;
                }
                ++i;
            }
            if ("" != serialno) {
                return serialno;
            }
            i = 0;
            serialnoStr = "";
            while (i < 3) {
                serialnoStr = this.excuteCommand("QID", true);
                if (!(serialnoStr == null || "".equals(serialnoStr) || serialnoStr.equalsIgnoreCase("(NAK") || serialnoStr.equalsIgnoreCase("(ACK") || serialnoStr.equals("QID"))) {
                    serialno = serialnoStr.substring(1);
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serialno;
    }

    @Override
    public String getModeType() {
        String machineTypeStr = "";
        try {
            String qpiriStr = this.excuteCommand("QPIRI", true);
            if (!("".equals(qpiriStr) || qpiriStr.equals("(NAK") || qpiriStr.equals("QPIRI"))) {
                String[] ratingInfo = qpiriStr.split(" ");
                machineTypeStr = ratingInfo[8];
                return machineTypeStr;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return machineTypeStr;
    }

    @Override
    public String getDeviceModel() {
        String _deviceModel = "";
        try {
            String qdmStr = this.excuteCommand("QDM", true);
            if (!("".equals(qdmStr) || qdmStr.equals("(NAK") || qdmStr.equals("QDM"))) {
                _deviceModel = qdmStr = qdmStr.substring(1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return _deviceModel;
    }

    @Override
    public boolean isSupportQCTH() {
        String qchtStr = this.excuteCommand("QCHT", true);
        return qchtStr != null && !"".equals(qchtStr) && !qchtStr.equals("(NAK");
    }

    @Override
    public boolean isSupportQPPS() {
        String ppsStr = this.excuteCommand("QPPS", true);
        return ppsStr != null && !"".equals(ppsStr) && !ppsStr.equals("(NAK");
    }
}

